/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.security;

import com.refinedmods.refinedstorage.common.api.security.PlatformPermission;
import com.refinedmods.refinedstorage.common.security.AbstractSecurityCardContainerMenu;
import com.refinedmods.refinedstorage.common.security.SecurityCardData;
import com.refinedmods.refinedstorage.common.support.stretching.AbstractStretchingScreen;
import com.refinedmods.refinedstorage.common.support.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public abstract class AbstractSecurityCardScreen<T extends AbstractSecurityCardContainerMenu>
extends AbstractStretchingScreen<T> {
    private static final ResourceLocation TEXTURE = IdentifierUtil.createIdentifier("textures/gui/security_card.png");
    private static final int RESET_BUTTON_WIDTH = 40;
    private static final int RESET_BUTTON_RIGHT_PADDING = 16;
    private static final Component RESET_TITLE = IdentifierUtil.createTranslation("gui", "security_card.permission.reset");
    private static final Component MODIFIED_TITLE = IdentifierUtil.createTranslation("gui", "security_card.permission.modified").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.YELLOW));
    private final List<Permission> permissions = new ArrayList<Permission>();

    protected AbstractSecurityCardScreen(T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.inventoryLabelY = 97;
        this.imageWidth = 193;
        this.imageHeight = 176;
    }

    @Override
    protected void init(int rows) {
        this.permissions.clear();
        List<SecurityCardData.Permission> menuPermissions = ((AbstractSecurityCardContainerMenu)this.getMenu()).getPermissions();
        for (int i = 0; i < menuPermissions.size(); ++i) {
            Permission permission = this.createPermission(menuPermissions.get(i), i, rows);
            this.addWidget((GuiEventListener)permission.checkbox);
            this.addWidget((GuiEventListener)permission.resetButton);
            this.permissions.add(permission);
        }
        this.updateScrollbar(this.permissions.size());
    }

    private Permission createPermission(SecurityCardData.Permission menuPermission, int index, int rows) {
        int y = this.getPermissionY(index);
        boolean visible = this.isPermissionVisible(rows, y);
        CheckboxWidget checkbox = this.createPermissionCheckbox(menuPermission, y, visible);
        Button resetButton = this.createPermissionResetButton(menuPermission, checkbox, y, visible);
        checkbox.setOnPressed((c, selected) -> this.updatePermission(menuPermission, resetButton, c, selected));
        return new Permission(checkbox, resetButton);
    }

    private CheckboxWidget createPermissionCheckbox(SecurityCardData.Permission menuPermission, int y, boolean visible) {
        CheckboxWidget checkbox = new CheckboxWidget(this.leftPos + 10, y, this.getPermissionName(menuPermission), this.font, menuPermission.allowed(), CheckboxWidget.Size.REGULAR);
        checkbox.visible = visible;
        checkbox.setTooltip(this.getPermissionTooltip(menuPermission));
        return checkbox;
    }

    private void updatePermission(SecurityCardData.Permission menuPermission, Button resetButton, CheckboxWidget checkbox, boolean allowed) {
        this.updateCheckboxAndResetButton(checkbox, resetButton, ((AbstractSecurityCardContainerMenu)this.menu).changePermission(menuPermission.permission(), allowed));
    }

    private Tooltip getPermissionTooltip(SecurityCardData.Permission menuPermission) {
        PlatformPermission permission = menuPermission.permission();
        MutableComponent ownerName = permission.getOwnerName().copy().withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.GRAY));
        MutableComponent tooltip = permission.getDescription().copy().append("\n").append((Component)ownerName);
        return Tooltip.create((Component)(menuPermission.dirty() ? tooltip.append("\n").append(MODIFIED_TITLE) : tooltip));
    }

    private Button createPermissionResetButton(SecurityCardData.Permission menuPermission, CheckboxWidget checkbox, int y, boolean visible) {
        Button resetButton = Button.builder((Component)RESET_TITLE, btn -> this.resetPermission(menuPermission, checkbox, btn)).pos(this.leftPos + this.imageWidth - 16 - 40 - 11, y).size(40, 16).build();
        resetButton.visible = visible;
        resetButton.active = menuPermission.dirty();
        return resetButton;
    }

    private void resetPermission(SecurityCardData.Permission menuPermission, CheckboxWidget checkbox, Button resetButton) {
        this.updateCheckboxAndResetButton(checkbox, resetButton, ((AbstractSecurityCardContainerMenu)this.menu).resetPermission(menuPermission.permission()));
    }

    private void updateCheckboxAndResetButton(CheckboxWidget checkbox, Button resetButton, SecurityCardData.Permission menuPermission) {
        checkbox.setMessage(this.getPermissionName(menuPermission));
        checkbox.setTooltip(this.getPermissionTooltip(menuPermission));
        checkbox.setSelected(menuPermission.allowed());
        resetButton.active = menuPermission.dirty();
    }

    private Component getPermissionName(SecurityCardData.Permission menuPermission) {
        Component name = menuPermission.permission().getName();
        if (!menuPermission.dirty()) {
            return name;
        }
        return name.copy().append(" (*)").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)));
    }

    private int getPermissionY(int index) {
        return this.topPos + 19 + index * 18 + 3;
    }

    private boolean isPermissionVisible(int rows, int y) {
        return y >= this.topPos + 19 - 18 && y < this.topPos + 19 + rows * 18;
    }

    @Override
    protected int getScrollPanePadding() {
        return 4;
    }

    @Override
    protected void scrollbarChanged(int rows) {
        int offset = this.getScrollbarOffset();
        for (int i = 0; i < this.permissions.size(); ++i) {
            Permission permission = this.permissions.get(i);
            int y = this.getPermissionY(i) - offset;
            boolean visible = this.isPermissionVisible(rows, y);
            permission.setY(y);
            permission.setVisible(visible);
        }
    }

    @Override
    protected void renderRows(GuiGraphics graphics, int x, int y, int topHeight, int rows, int mouseX, int mouseY) {
        for (Permission permission : this.permissions) {
            permission.render(graphics, mouseX, mouseY);
        }
    }

    @Override
    protected void renderStretchingBackground(GuiGraphics graphics, int x, int y, int rows) {
        for (int row = 0; row < rows; ++row) {
            int textureY = 37;
            if (row == 0) {
                textureY = 19;
            } else if (row == rows - 1) {
                textureY = 55;
            }
            graphics.blit(this.getTexture(), x, y + 18 * row, 0, textureY, this.imageWidth, 18);
        }
    }

    @Override
    protected int getBottomHeight() {
        return 99;
    }

    @Override
    protected int getBottomV() {
        return 73;
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    private record Permission(CheckboxWidget checkbox, Button resetButton) {
        private void setY(int y) {
            this.checkbox.setY(y);
            this.resetButton.setY(y);
        }

        private void setVisible(boolean visible) {
            this.checkbox.visible = visible;
            this.resetButton.visible = visible;
        }

        private void render(GuiGraphics graphics, int mouseX, int mouseY) {
            this.checkbox.render(graphics, mouseX, mouseY, 0.0f);
            this.resetButton.render(graphics, mouseX, mouseY, 0.0f);
        }
    }
}

