/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.common.networking.CableConnections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class CableShapes {
    private static final VoxelShape CORE = Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape NORTH = Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    private static final VoxelShape EAST = Block.box((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape SOUTH = Block.box((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape WEST = Block.box((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    private static final VoxelShape UP = Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape DOWN = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    private static final Map<CableConnections, VoxelShape> CACHE = new ConcurrentHashMap<CableConnections, VoxelShape>();

    private CableShapes() {
    }

    public static VoxelShape getShape(CableConnections connections) {
        return CACHE.computeIfAbsent(connections, CableShapes::computeShape);
    }

    private static VoxelShape computeShape(CableConnections connections) {
        VoxelShape shape = CORE;
        if (connections.north()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)NORTH);
        }
        if (connections.east()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)EAST);
        }
        if (connections.south()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH);
        }
        if (connections.west()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)WEST);
        }
        if (connections.up()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)UP);
        }
        if (connections.down()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)DOWN);
        }
        return shape;
    }
}

