/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.containermenu;

import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeSlot;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class AbstractSimpleFilterContainerMenu<T extends BlockEntity>
extends AbstractResourceContainerMenu {
    private static final int FILTER_SLOT_X = 8;
    private static final int FILTER_SLOT_Y = 20;
    private final Component filterHelp;

    protected AbstractSimpleFilterContainerMenu(MenuType<?> type, int syncId, Player player, ResourceContainer resourceContainer, @Nullable UpgradeContainer upgradeContainer, T blockEntity, Component filterHelp) {
        super(type, syncId, player);
        this.filterHelp = filterHelp;
        this.registerServerProperties(blockEntity);
        this.addSlots(player, resourceContainer, upgradeContainer);
    }

    protected AbstractSimpleFilterContainerMenu(MenuType<?> type, int syncId, Player player, ResourceContainerData resourceContainerData, @Nullable UpgradeDestinations upgradeDestination, Component filterHelp) {
        super(type, syncId);
        this.filterHelp = filterHelp;
        this.registerClientProperties();
        this.addSlots(player, ResourceContainerImpl.createForFilter(resourceContainerData), upgradeDestination == null ? null : new UpgradeContainer(upgradeDestination));
    }

    protected abstract void registerClientProperties();

    protected abstract void registerServerProperties(T var1);

    private void addSlots(Player player, ResourceContainer resourceContainer, @Nullable UpgradeContainer upgradeContainer) {
        int i;
        for (i = 0; i < resourceContainer.size(); ++i) {
            this.addSlot(this.createFilterSlot(resourceContainer, i));
        }
        if (upgradeContainer != null) {
            for (i = 0; i < upgradeContainer.getContainerSize(); ++i) {
                this.addSlot(new UpgradeSlot(upgradeContainer, i, 187, 6 + i * 18));
            }
        }
        this.addPlayerInventory(player.getInventory(), 8, 55);
        if (upgradeContainer != null) {
            this.transferManager.addBiTransfer((Container)player.getInventory(), (Container)upgradeContainer);
        }
        this.transferManager.addFilterTransfer((Container)player.getInventory());
    }

    private Slot createFilterSlot(ResourceContainer resourceContainer, int i) {
        int x = 8 + 18 * i;
        return new ResourceSlot(resourceContainer, i, this.filterHelp, x, 20, ResourceSlotType.FILTER);
    }
}

