/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.refinedstoragerequestify.block.tile;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProvider;
import com.refinedmods.refinedstorage.api.network.impl.node.SimpleNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.InterfaceTransferResult;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.level.Level;

public class CraftingEmitterNetworkNode
extends SimpleNetworkNode {
    private FilterWithFuzzyMode filter;
    private Level level;
    private InterfaceTransferResult[] results;
    private Consumer<Boolean> shouldEmmitRedstone;

    public CraftingEmitterNetworkNode(long energyUsage) {
        super(energyUsage);
    }

    public void setFilter(FilterWithFuzzyMode filter) {
        this.filter = filter;
        this.results = new InterfaceTransferResult[filter.getFilterContainer().size()];
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setShouldEmmitRedstone(Consumer<Boolean> shouldEmmitRedstone) {
        this.shouldEmmitRedstone = shouldEmmitRedstone;
    }

    public void doWork() {
        super.doWork();
        if (this.network != null && this.isActive() && this.filter != null && this.level != null && this.level.getGameTime() % 20L == 0L) {
            AutocraftingNetworkComponent craftingComponent = (AutocraftingNetworkComponent)this.network.getComponent(AutocraftingNetworkComponent.class);
            for (int i = 0; i < this.filter.getFilterContainer().size(); ++i) {
                try {
                    ResourceAmount resource = this.filter.getFilterContainer().get(i);
                    if (resource == null) {
                        this.results[i] = InterfaceTransferResult.EXPORTED;
                        continue;
                    }
                    List patterns = craftingComponent.getPatternsByOutput(resource.resource());
                    for (Pattern pattern : patterns) {
                        PatternProvider patterProvider = craftingComponent.getProviderByPattern(pattern);
                        for (TaskStatus taskStatus : patterProvider.getTaskStatuses()) {
                            if (!taskStatus.info().resource().equals((Object)resource.resource()) || taskStatus.info().amount() < resource.amount()) continue;
                            this.shouldEmmitRedstone.accept(true);
                            return;
                        }
                    }
                    continue;
                }
                catch (IllegalStateException e) {
                    this.results[i] = InterfaceTransferResult.RESOURCE_MISSING;
                }
            }
            this.shouldEmmitRedstone.accept(false);
        }
    }

    protected void onActiveChanged(boolean newActive) {
        super.onActiveChanged(newActive);
    }

    @Nullable
    public InterfaceTransferResult getLastResult(int slot) {
        if (this.results == null) {
            return null;
        }
        return this.results[slot];
    }
}

