/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.refinedstoragerequestify.container;

import com.buuz135.refinedstoragerequestify.RSRContent;
import com.buuz135.refinedstoragerequestify.block.tile.CraftingEmitterBlockEntity;
import com.buuz135.refinedstoragerequestify.container.CraftingEmitterData;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.Property;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicatorListener;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicators;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CraftingEmitterContainer
extends AbstractResourceContainerMenu
implements ExportingIndicatorListener {
    private static final int EXPORT_CONFIG_SLOT_X = 8;
    private static final int EXPORT_CONFIG_SLOT_Y = 20;
    private final ExportingIndicators indicators;
    private final Predicate<Player> stillValid;

    public CraftingEmitterContainer(int syncId, Player player, CraftingEmitterBlockEntity blockEntity, ResourceContainer exportConfig, ExportingIndicators indicators) {
        super((MenuType)RSRContent.Menus.CRAFTING_EMITTER.get(), syncId, player);
        this.addSlots(player, exportConfig);
        this.registerProperty((Property)new ServerProperty(PropertyTypes.REDSTONE_MODE, () -> ((CraftingEmitterBlockEntity)blockEntity).getRedstoneMode(), arg_0 -> ((CraftingEmitterBlockEntity)blockEntity).setRedstoneMode(arg_0)));
        this.indicators = indicators;
        this.stillValid = p -> Container.stillValidBlockEntity((BlockEntity)blockEntity, (Player)p);
    }

    public CraftingEmitterContainer(int syncId, Inventory playerInventory, CraftingEmitterData interfaceData) {
        super((MenuType)RSRContent.Menus.CRAFTING_EMITTER.get(), syncId);
        ResourceContainer filterContainer = CraftingEmitterBlockEntity.createFilterContainer(interfaceData);
        this.addSlots(playerInventory.player, filterContainer);
        this.registerProperty((Property)new ClientProperty(PropertyTypes.REDSTONE_MODE, (Object)RedstoneMode.IGNORE));
        this.indicators = new ExportingIndicators(interfaceData.exportingIndicators());
        this.stillValid = p -> true;
    }

    private static int getExportSlotX(int index) {
        return 8 + 18 * index;
    }

    private void addSlots(Player player, ResourceContainer exportConfig) {
        for (int i = 0; i < exportConfig.size(); ++i) {
            this.addSlot(this.createExportConfigSlot(exportConfig, i));
        }
        this.addPlayerInventory(player.getInventory(), 8, 55);
        this.transferManager.addFilterTransfer((Container)player.getInventory());
    }

    private Slot createExportConfigSlot(ResourceContainer exportConfig, int index) {
        int x = CraftingEmitterContainer.getExportSlotX(index);
        return new ResourceSlot(exportConfig, index, (Component)Component.translatable((String)"block.rsrequestify.crafting_emitter.tooltip.filter"), x, 20, ResourceSlotType.FILTER_WITH_AMOUNT);
    }

    public ExportingIndicator getIndicator(int idx) {
        return this.indicators.get(idx);
    }

    public int getIndicators() {
        return this.indicators.size();
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.indicators.detectChanges(serverPlayer);
        }
    }

    public boolean stillValid(Player player) {
        return this.stillValid.test(player);
    }

    public void indicatorChanged(int index, ExportingIndicator indicator) {
        this.indicators.set(index, indicator);
    }
}

