/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.debugtools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nonnull;
import mcjty.lib.varia.Tools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DumpBlockNBT {
    public static String dumpBlockNBT(@Nonnull Level world, @Nonnull BlockPos pos, boolean verbose) {
        BlockState state = world.getBlockState(pos);
        BlockEntity te = world.getBlockEntity(pos);
        Block block = state.getBlock();
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("block", (JsonElement)new JsonPrimitive(Tools.getId(block).toString()));
        if (te != null) {
            jsonObject.add("teClass", (JsonElement)new JsonPrimitive(te.getClass().getCanonicalName()));
            CompoundTag tag = te.saveWithoutMetadata((HolderLookup.Provider)world.registryAccess());
            if (verbose) {
                String nbtJson = tag.toString();
                JsonParser parser = new JsonParser();
                JsonElement element = parser.parse(nbtJson);
                jsonObject.add("nbt", element);
            } else {
                JsonArray array = new JsonArray();
                for (String key : tag.getAllKeys()) {
                    array.add((JsonElement)new JsonPrimitive(key));
                }
                jsonObject.add("nbt", (JsonElement)array);
            }
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)jsonObject);
    }
}

