/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.cube;

import java.util.ArrayList;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.camo.CamoContent;
import xfacthd.framedblocks.api.model.cache.QuadCacheKey;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.blockentity.special.FramedCollapsibleCopycatBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedCollapsibleCopycatBlockGeometry
extends Geometry {
    public static final ModelResourceLocation ALT_BASE_MODEL_LOC = ModelResourceLocation.standalone((ResourceLocation)Utils.rl("block/framed_collapsible_copycat_block_alt"));
    private static final int UP = Direction.UP.ordinal();
    private static final int DOWN = Direction.DOWN.ordinal();
    private static final int NORTH = Direction.NORTH.ordinal();
    private static final int EAST = Direction.EAST.ordinal();
    private static final int SOUTH = Direction.SOUTH.ordinal();
    private static final int WEST = Direction.WEST.ordinal();
    private final int solidFaces;
    private final BakedModel altBaseModel;

    public FramedCollapsibleCopycatBlockGeometry(GeometryFactory.Context ctx) {
        this.solidFaces = (Integer)ctx.state().getValue((Property)PropertyHolder.SOLID_FACES);
        this.altBaseModel = ctx.modelLookup().get(ALT_BASE_MODEL_LOC);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad, ModelData data) {
        Direction quadDir = quad.getDirection();
        Integer packedOffsets = (Integer)data.get(FramedCollapsibleCopycatBlockEntity.OFFSETS);
        if (packedOffsets == null) {
            quadMap.get(quadDir).add(quad);
            return;
        }
        byte[] offsets = FramedCollapsibleCopycatBlockEntity.unpackOffsets(packedOffsets);
        boolean solid = (this.solidFaces & 1 << quadDir.ordinal()) != 0;
        ArrayList<QuadModifier> mods = new ArrayList<QuadModifier>(2);
        QuadModifier initialModifier = QuadModifier.of(quad).apply(Modifiers.setPosition((16.0f - (float)offsets[quadDir.ordinal()]) / 16.0f));
        if (Utils.isY(quadDir)) {
            Object length;
            if (offsets[NORTH] > 0 || offsets[SOUTH] > 0) {
                length = FramedCollapsibleCopycatBlockGeometry.getLenghts(offsets[NORTH], offsets[SOUTH]);
                if (((FloatPair)length).valOne > 0.0f) {
                    mods.add(initialModifier.derive().apply(Modifiers.cutTopBottom(Direction.SOUTH, ((FloatPair)length).valOne)).apply(Modifiers.offset(Direction.SOUTH, (float)offsets[NORTH] / 16.0f)));
                }
                if (((FloatPair)length).valTwo > 0.0f) {
                    mods.add(initialModifier.apply(Modifiers.cutTopBottom(Direction.NORTH, ((FloatPair)length).valTwo)).apply(Modifiers.offset(Direction.NORTH, (float)offsets[SOUTH] / 16.0f)));
                }
            } else {
                mods.add(initialModifier);
            }
            if (offsets[EAST] > 0 || offsets[WEST] > 0) {
                length = FramedCollapsibleCopycatBlockGeometry.getLenghts(offsets[WEST], offsets[EAST]);
                for (QuadModifier modifier : mods) {
                    if (((FloatPair)length).valOne > 0.0f) {
                        modifier.derive().apply(Modifiers.cutTopBottom(Direction.EAST, ((FloatPair)length).valOne)).apply(Modifiers.offset(Direction.EAST, (float)offsets[WEST] / 16.0f)).export(quadMap.get((Direction)(solid ? quadDir : null)));
                    }
                    if (!(((FloatPair)length).valTwo > 0.0f)) continue;
                    modifier.apply(Modifiers.cutTopBottom(Direction.WEST, ((FloatPair)length).valTwo)).apply(Modifiers.offset(Direction.WEST, (float)offsets[EAST] / 16.0f)).export(quadMap.get((Direction)(solid ? quadDir : null)));
                }
            } else {
                for (QuadModifier modifier : mods) {
                    modifier.export(quadMap.get((Direction)(solid ? quadDir : null)));
                }
            }
        } else {
            FloatPair length;
            int axisMax;
            boolean xAxis = Utils.isX(quadDir);
            Direction axisNeg = xAxis ? Direction.NORTH : Direction.WEST;
            int axisMin = xAxis ? NORTH : WEST;
            int n = axisMax = xAxis ? SOUTH : EAST;
            if (offsets[axisMin] > 0 || offsets[axisMax] > 0) {
                length = FramedCollapsibleCopycatBlockGeometry.getLenghts(offsets[axisMin], offsets[axisMax]);
                if (length.valOne > 0.0f) {
                    mods.add(initialModifier.derive().apply(Modifiers.cutSideLeftRight(axisNeg.getOpposite(), length.valOne)).apply(Modifiers.offset(axisNeg.getOpposite(), (float)offsets[axisMin] / 16.0f)));
                }
                if (length.valTwo > 0.0f) {
                    mods.add(initialModifier.apply(Modifiers.cutSideLeftRight(axisNeg, length.valTwo)).apply(Modifiers.offset(axisNeg, (float)offsets[axisMax] / 16.0f)));
                }
            } else {
                mods.add(initialModifier);
            }
            if (offsets[DOWN] > 0 || offsets[UP] > 0) {
                length = FramedCollapsibleCopycatBlockGeometry.getLenghts(offsets[DOWN], offsets[UP]);
                for (QuadModifier modifier : mods) {
                    if (length.valOne > 0.0f) {
                        modifier.derive().apply(Modifiers.cutSideUpDown(false, length.valOne)).apply(Modifiers.offset(Direction.UP, (float)offsets[DOWN] / 16.0f)).export(quadMap.get((Direction)(solid ? quadDir : null)));
                    }
                    if (!(length.valTwo > 0.0f)) continue;
                    modifier.apply(Modifiers.cutSideUpDown(true, length.valTwo)).apply(Modifiers.offset(Direction.DOWN, (float)offsets[UP] / 16.0f)).export(quadMap.get((Direction)(solid ? quadDir : null)));
                }
            } else {
                for (QuadModifier modifier : mods) {
                    modifier.export(quadMap.get((Direction)(solid ? quadDir : null)));
                }
            }
        }
    }

    private static FloatPair getLenghts(int offsetMin, int offsetMax) {
        float length = (float)(16 - offsetMin - offsetMax) / 2.0f;
        boolean ceilFirst = offsetMin > offsetMax;
        return new FloatPair((float)(ceilFirst ? Math.ceil(length) : Math.floor(length)) / 16.0f, (float)(ceilFirst ? Math.floor(length) : Math.ceil(length)) / 16.0f);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
    }

    @Override
    public boolean useBaseModel() {
        return true;
    }

    @Override
    public BakedModel getBaseModel(BakedModel baseModel, boolean useAltModel) {
        return useAltModel ? this.altBaseModel : baseModel;
    }

    @Override
    public QuadCacheKey makeCacheKey(CamoContent<?> camo, Object ctCtx, ModelData data) {
        Integer packedOffsets = (Integer)data.get(FramedCollapsibleCopycatBlockEntity.OFFSETS);
        return new CollapsibleCopycatBlockQuadCacheKey(camo, ctCtx, packedOffsets);
    }

    private record FloatPair(float valOne, float valTwo) {
    }

    private record CollapsibleCopycatBlockQuadCacheKey(CamoContent<?> camo, Object ctCtx, Integer packedOffsets) implements QuadCacheKey
    {
    }
}

