/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.cube;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedMiniCubeGeometry
extends Geometry {
    private static final Vector3f ORIGIN_BOTTOM = new Vector3f(0.5f, 0.0f, 0.5f);
    private static final Vector3f ORIGIN_TOP = new Vector3f(0.5f, 1.0f, 0.5f);
    private final float rotAngle;
    private final Direction bottomFace;
    private final Vector3f origin;

    public FramedMiniCubeGeometry(GeometryFactory.Context ctx) {
        int rot = (Integer)ctx.state().getValue((Property)BlockStateProperties.ROTATION_16);
        this.rotAngle = (float)(4 - rot % 4) * 22.5f;
        boolean top = (Boolean)ctx.state().getValue((Property)FramedProperties.TOP);
        this.bottomFace = top ? Direction.UP : Direction.DOWN;
        this.origin = top ? ORIGIN_TOP : ORIGIN_BOTTOM;
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        QuadModifier.of(quad).apply(Modifiers.scaleFace(0.5f, this.origin)).applyIf(Modifiers.setPosition(0.5f), quadDir == this.bottomFace.getOpposite()).applyIf(Modifiers.setPosition(0.75f), !Utils.isY(quadDir)).apply(Modifiers.rotate(Direction.Axis.Y, this.origin, this.rotAngle, false)).export(quadMap.get((Direction)(quadDir == this.bottomFace ? quadDir : null)));
    }
}

