/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.stairs.vertical;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedDoubleBlock;
import xfacthd.framedblocks.common.block.stairs.vertical.FramedVerticalSlopedStairsBlock;
import xfacthd.framedblocks.common.blockentity.doubled.stairs.FramedVerticalSlopedDoubleStairsBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.util.FramedUtils;

public class FramedVerticalSlopedDoubleStairsBlock
extends FramedVerticalSlopedStairsBlock
implements IFramedDoubleBlock {
    public FramedVerticalSlopedDoubleStairsBlock() {
        super(BlockType.FRAMED_VERTICAL_SLOPED_DOUBLE_STAIRS);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        FramedUtils.removeProperty(builder, BlockStateProperties.WATERLOGGED);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedVerticalSlopedDoubleStairsBlockEntity(pos, state);
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        boolean ySlope = (Boolean)state.getValue((Property)FramedProperties.Y_SLOPE);
        boolean top = rot == HorizontalRotation.RIGHT || rot == HorizontalRotation.UP;
        boolean right = rot == HorizontalRotation.RIGHT || rot == HorizontalRotation.DOWN;
        Direction facingTwo = right ? facing.getClockWise() : facing.getCounterClockWise();
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_SLOPED_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue(PropertyHolder.ROTATION, (Comparable)((Object)rot))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_SLOPE.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facingTwo)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(right))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        boolean rearTop = rot == HorizontalRotation.LEFT || rot == HorizontalRotation.DOWN;
        return rearTop ? DoubleBlockTopInteractionMode.FIRST : DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        Direction dirTwo = rot.getOpposite().withFacing(facing);
        Direction dirThree = rot.rotate(Rotation.CLOCKWISE_90).withFacing(facing);
        if (side == facing || side == dirTwo || side == dirThree) {
            return SolidityCheck.FIRST;
        }
        return SolidityCheck.BOTH;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        Direction dirTwo = rot.getOpposite().withFacing(facing);
        Direction dirThree = rot.rotate(Rotation.CLOCKWISE_90).withFacing(facing);
        if (side == facing || side == dirTwo || side == dirThree) {
            return CamoGetter.FIRST;
        }
        if (side == facing.getOpposite()) {
            if (edge == dirTwo || edge == dirThree) {
                return CamoGetter.FIRST;
            }
            if (edge == dirTwo.getOpposite() || edge == dirThree.getOpposite()) {
                return CamoGetter.SECOND;
            }
            return CamoGetter.NONE;
        }
        if (side == dirTwo.getOpposite() || side == dirThree.getOpposite()) {
            if (edge == facing) {
                return CamoGetter.FIRST;
            }
            if (edge == facing.getOpposite()) {
                return CamoGetter.SECOND;
            }
            return CamoGetter.NONE;
        }
        return CamoGetter.NONE;
    }
}

