/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece;

import com.yungnickyoung.minecraft.betterdungeons.mixin.accessor.BoundingBoxAccessor;
import com.yungnickyoung.minecraft.betterdungeons.module.StructurePieceTypeModule;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece.SpiderDungeonNestPiece;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece.SpiderDungeonPiece;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece.SpiderDungeonSmallTunnelPiece;
import java.util.BitSet;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.material.Fluids;

@ParametersAreNonnullByDefault
public class SpiderDungeonBigTunnelPiece
extends SpiderDungeonPiece {
    private final BlockPos startPos;
    private BlockPos endPos;
    private float pitch = 0.0f;
    private final float[] yaws = new float[30];
    private static final int LENGTH = 30;
    private static final float X_MINRADIUS = 2.0f;
    private static final float X_MAXRADIUS = 2.5f;
    private static final float Y_MINRADIUS = 2.0f;
    private static final float Y_MAXRADIUS = 2.5f;
    private static final float Z_MINRADIUS = 2.0f;
    private static final float Z_MAXRADIUS = 2.5f;

    public SpiderDungeonBigTunnelPiece(BlockPos startPos) {
        this(startPos, 0);
    }

    public SpiderDungeonBigTunnelPiece(BlockPos startPos, int pieceChainLength, float initialPitch, float initialYaw) {
        this(startPos, pieceChainLength);
        this.pitch = initialPitch;
        this.yaws[0] = initialYaw;
    }

    public SpiderDungeonBigTunnelPiece(CompoundTag compoundTag) {
        super(StructurePieceTypeModule.BIG_TUNNEL, compoundTag);
        int[] start = compoundTag.getIntArray("startPos");
        int[] end = compoundTag.getIntArray("endPos");
        this.startPos = new BlockPos(start[0], start[1], start[2]);
        this.endPos = new BlockPos(end[0], end[1], end[2]);
        this.pitch = compoundTag.getFloat("pitch");
        ListTag yawListNBT = compoundTag.getList("yawList", 5);
        for (int i = 0; i < 30; ++i) {
            this.yaws[i] = yawListNBT.getFloat(i);
        }
    }

    private SpiderDungeonBigTunnelPiece(BlockPos startPos, int pieceChainLength) {
        super(StructurePieceTypeModule.BIG_TUNNEL, pieceChainLength, SpiderDungeonBigTunnelPiece.getInitialBoundingBox(startPos));
        this.startPos = new BlockPos((Vec3i)startPos);
        this.endPos = new BlockPos((Vec3i)startPos);
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        compoundTag.putIntArray("startPos", new int[]{this.startPos.getX(), this.startPos.getY(), this.startPos.getZ()});
        compoundTag.putIntArray("endPos", new int[]{this.endPos.getX(), this.endPos.getY(), this.endPos.getZ()});
        compoundTag.putFloat("pitch", this.pitch);
        ListTag yawListNBT = new ListTag();
        for (int i = 0; i < 30; ++i) {
            yawListNBT.add((Object)FloatTag.valueOf((float)this.yaws[i]));
        }
        compoundTag.put("yawList", (Tag)yawListNBT);
    }

    public void addChildren(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, RandomSource randomSource) {
        if (this.pitch == 0.0f) {
            this.pitch = Mth.clamp((float)(randomSource.nextFloat() * (float)(-Math.PI)), (float)-2.6f, (float)-0.6f);
        }
        if (this.pitch > -2.2f && this.pitch < -1.0f) {
            this.pitch = -2.2f;
        }
        float pitchY = Mth.sin((float)this.pitch);
        float pitchXZ = Mth.cos((float)this.pitch);
        if (this.yaws[0] == 0.0f) {
            this.yaws[0] = randomSource.nextFloat() * ((float)Math.PI * 2);
        }
        float yawModifier = 0.0f;
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        float caveStartX = this.startPos.getX();
        float caveStartY = this.startPos.getY();
        float caveStartZ = this.startPos.getZ();
        caveStartX += Mth.cos((float)this.yaws[0]) * pitchXZ;
        caveStartY += Mth.sin((float)pitchY);
        caveStartZ += Mth.sin((float)this.yaws[0]) * pitchXZ;
        if (caveStartX - 2.5f - 4.0f < (float)minX) {
            minX = (int)caveStartX - 2 - 4;
        }
        if (caveStartX + 2.5f + 4.0f > (float)maxX) {
            maxX = (int)caveStartX + 2 + 4;
        }
        if (caveStartY - 2.5f - 4.0f < (float)minY) {
            minY = (int)caveStartY - 2 - 4;
        }
        if (caveStartY + 2.5f + 4.0f > (float)maxY) {
            maxY = (int)caveStartY + 2 + 4;
        }
        if (caveStartZ - 2.5f - 4.0f < (float)minZ) {
            minZ = (int)caveStartZ - 2 - 4;
        }
        if (caveStartZ + 2.5f + 4.0f > (float)maxZ) {
            maxZ = (int)caveStartZ + 2 + 4;
        }
        for (int i = 1; i < 30; ++i) {
            yawModifier *= 0.75f;
            this.yaws[i] = this.yaws[i - 1] + (yawModifier += randomSource.nextFloat() * randomSource.nextFloat()) * 0.01f;
            caveStartX += Mth.cos((float)this.yaws[i]) * pitchXZ;
            caveStartY += Mth.sin((float)pitchY);
            caveStartZ += Mth.sin((float)this.yaws[i]) * pitchXZ;
            if (caveStartX - 2.5f - 4.0f < (float)minX) {
                minX = (int)caveStartX - 2 - 4;
            }
            if (caveStartX + 2.5f + 4.0f > (float)maxX) {
                maxX = (int)caveStartX + 2 + 4;
            }
            if (caveStartY - 2.5f - 4.0f < (float)minY) {
                minY = (int)caveStartY - 2 - 4;
            }
            if (caveStartY + 2.5f + 4.0f > (float)maxY) {
                maxY = (int)caveStartY + 2 + 4;
            }
            if (caveStartZ - 2.5f - 4.0f < (float)minZ) {
                minZ = (int)caveStartZ - 2 - 4;
            }
            if (!(caveStartZ + 2.5f + 4.0f > (float)maxZ)) continue;
            maxZ = (int)caveStartZ + 2 + 4;
        }
        ((BoundingBoxAccessor)this.boundingBox).setMinX(minX);
        ((BoundingBoxAccessor)this.boundingBox).setMaxX(maxX);
        ((BoundingBoxAccessor)this.boundingBox).setMinY(minY);
        ((BoundingBoxAccessor)this.boundingBox).setMaxY(maxY);
        ((BoundingBoxAccessor)this.boundingBox).setMinZ(minZ);
        ((BoundingBoxAccessor)this.boundingBox).setMaxZ(maxZ);
        this.endPos = new BlockPos((int)caveStartX, (int)caveStartY, (int)caveStartZ);
        if (this.genDepth == 0) {
            SpiderDungeonBigTunnelPiece nextBigTunnelPiece = new SpiderDungeonBigTunnelPiece(this.endPos, this.genDepth + 1, 0.0f, this.yaws[29]);
            structurePieceAccessor.addPiece((StructurePiece)nextBigTunnelPiece);
            nextBigTunnelPiece.addChildren(nextBigTunnelPiece, structurePieceAccessor, randomSource);
        }
        float smallTunnelAngle = this.yaws[29] + 0.3f;
        SpiderDungeonSmallTunnelPiece smallTunnelPiece1 = new SpiderDungeonSmallTunnelPiece(this.endPos, smallTunnelAngle += randomSource.nextFloat() * 0.4f + 0.9f, this.genDepth + 1);
        structurePieceAccessor.addPiece((StructurePiece)smallTunnelPiece1);
        smallTunnelPiece1.addChildren(smallTunnelPiece1, structurePieceAccessor, randomSource);
        SpiderDungeonSmallTunnelPiece smallTunnelPiece2 = new SpiderDungeonSmallTunnelPiece(this.endPos, smallTunnelAngle += randomSource.nextFloat() * 0.4f + 0.9f, this.genDepth + 1);
        structurePieceAccessor.addPiece((StructurePiece)smallTunnelPiece2);
        smallTunnelPiece2.addChildren(smallTunnelPiece2, structurePieceAccessor, randomSource);
        SpiderDungeonSmallTunnelPiece smallTunnelPiece3 = new SpiderDungeonSmallTunnelPiece(this.endPos, smallTunnelAngle += randomSource.nextFloat() * 0.4f + 0.9f, this.genDepth + 1);
        structurePieceAccessor.addPiece((StructurePiece)smallTunnelPiece3);
        smallTunnelPiece3.addChildren(smallTunnelPiece3, structurePieceAccessor, randomSource);
        smallTunnelAngle += randomSource.nextFloat() * 0.4f + 0.9f;
        if (randomSource.nextFloat() < 0.5f) {
            SpiderDungeonSmallTunnelPiece smallTunnelPiece4 = new SpiderDungeonSmallTunnelPiece(this.endPos, smallTunnelAngle, this.genDepth + 1);
            structurePieceAccessor.addPiece((StructurePiece)smallTunnelPiece4);
            smallTunnelPiece4.addChildren(smallTunnelPiece4, structurePieceAccessor, randomSource);
        } else if (this.genDepth == 0) {
            SpiderDungeonBigTunnelPiece extraBigTunnelPiece = new SpiderDungeonBigTunnelPiece(this.endPos, this.genDepth + 1, randomSource.nextFloat() * (float)Math.PI / 6.0f - 0.5235988f, smallTunnelAngle);
            structurePieceAccessor.addPiece((StructurePiece)extraBigTunnelPiece);
            extraBigTunnelPiece.addChildren(extraBigTunnelPiece, structurePieceAccessor, randomSource);
        }
        SpiderDungeonNestPiece nestPiece = new SpiderDungeonNestPiece(this.endPos, this.genDepth + 1);
        structurePieceAccessor.addPiece((StructurePiece)nestPiece);
        nestPiece.addChildren(nestPiece, structurePieceAccessor, randomSource);
    }

    public void postProcess(WorldGenLevel world, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        WorldgenRandom decoRand = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        decoRand.setLargeFeatureSeed(world.getSeed(), this.startPos.getX(), this.startPos.getZ());
        int xBits = 4;
        int zBits = 4;
        int yBits = Mth.ceillog2((int)(world.getMaxBuildHeight() - world.getMinBuildHeight()));
        BitSet carvingMask = new BitSet((int)Math.pow(2.0, xBits + zBits + yBits));
        int[] surface = new int[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                mutable.set(chunkPos.getMinBlockX() + x, 1, chunkPos.getMinBlockZ() + z);
                surface[x * 16 + z] = world.getHeight(Heightmap.Types.WORLD_SURFACE_WG, mutable.getX(), mutable.getZ());
            }
        }
        float caveStartX = this.startPos.getX();
        float caveStartY = this.startPos.getY();
        float caveStartZ = this.startPos.getZ();
        for (int i = 0; i < 30; ++i) {
            float pitchY = Mth.sin((float)this.pitch);
            float pitchXZ = Mth.cos((float)this.pitch);
            float yaw = this.yaws[i];
            caveStartX += Mth.cos((float)yaw) * pitchXZ;
            caveStartY += Mth.sin((float)pitchY);
            caveStartZ += Mth.sin((float)yaw) * pitchXZ;
            float xRadius = Mth.lerp((float)Mth.sin((float)((float)i * (float)Math.PI / 30.0f)), (float)2.0f, (float)2.5f);
            float yRadius = Mth.lerp((float)Mth.sin((float)((float)i * (float)Math.PI / 30.0f)), (float)2.0f, (float)2.5f);
            float zRadius = Mth.lerp((float)Mth.sin((float)((float)i * (float)Math.PI / 30.0f)), (float)2.0f, (float)2.5f);
            int minX = Mth.floor((float)(caveStartX - xRadius)) - chunkPos.x * 16 - 1;
            int maxX = Mth.floor((float)(caveStartX + xRadius)) - chunkPos.x * 16 + 1;
            int minY = Mth.clamp((int)(Mth.floor((float)(caveStartY - yRadius)) - 1), (int)world.getMinBuildHeight(), (int)world.getMaxBuildHeight());
            int maxY = Mth.clamp((int)(Mth.floor((float)(caveStartY + yRadius)) + 1), (int)world.getMinBuildHeight(), (int)world.getMaxBuildHeight());
            int minZ = Mth.floor((float)(caveStartZ - zRadius)) - chunkPos.z * 16 - 1;
            int maxZ = Mth.floor((float)(caveStartZ + zRadius)) - chunkPos.z * 16 + 1;
            minX = Mth.clamp((int)minX, (int)0, (int)15);
            maxX = Mth.clamp((int)maxX, (int)0, (int)15);
            minZ = Mth.clamp((int)minZ, (int)0, (int)15);
            maxZ = Mth.clamp((int)maxZ, (int)0, (int)15);
            for (float x = (float)minX; x <= (float)maxX; x += 1.0f) {
                int globalX = (int)x + chunkPos.x * 16;
                if (globalX < chunkPos.getMinBlockX() || globalX > chunkPos.getMaxBlockX()) continue;
                float radialXDist = ((float)globalX - caveStartX + 0.5f) / xRadius;
                for (float z = (float)minZ; z <= (float)maxZ; z += 1.0f) {
                    int globalY;
                    int globalZ = (int)z + chunkPos.z * 16;
                    if (globalZ < chunkPos.getMinBlockZ() || globalZ > chunkPos.getMaxBlockZ()) continue;
                    float radialZDist = ((float)globalZ - caveStartZ + 0.5f) / zRadius;
                    for (float y = (float)minY; y <= (float)maxY && (globalY = (int)y) <= surface[(int)x % 16 * 16 + (int)z % 16]; y += 1.0f) {
                        BlockState state;
                        float radialYDist = (y - caveStartY - 0.5f) / yRadius;
                        int mask = (int)x | (int)z << 4 | (int)(y - (float)world.getMinBuildHeight()) << 8;
                        float radialDist = radialXDist * radialXDist + radialYDist * radialYDist + radialZDist * radialZDist;
                        if (!carvingMask.get(mask) && (double)radialDist < 1.0) {
                            if (BLOCK_BLACKLIST.contains(this.getBlock((BlockGetter)world, globalX, globalY, globalZ, box).getBlock())) continue;
                            this.placeBlock(world, Blocks.CAVE_AIR.defaultBlockState(), globalX, globalY, globalZ, box);
                            carvingMask.set(mask);
                            continue;
                        }
                        float radialXDistShell = ((float)globalX - caveStartX + 0.5f) / (xRadius + 1.2f);
                        float radialYDistShell = (y - caveStartY - 0.5f) / (yRadius + 1.2f);
                        float radialZDistShell = ((float)globalZ - caveStartZ + 0.5f) / (zRadius + 1.2f);
                        float radialDistShell = radialXDistShell * radialXDistShell + radialYDistShell * radialYDistShell + radialZDistShell * radialZDistShell;
                        if (carvingMask.get(mask) || !((double)radialDistShell < 1.0) || BLOCK_BLACKLIST.contains((state = this.getBlock((BlockGetter)world, globalX, globalY, globalZ, box)).getBlock()) || !state.isAir() && state.getFluidState().getType() == Fluids.EMPTY && !(decoRand.nextFloat() < 0.2f)) continue;
                        this.placeBlock(world, Blocks.COBBLESTONE.defaultBlockState(), globalX, globalY, globalZ, box);
                    }
                }
            }
        }
        this.decorateCave(world, (RandomSource)decoRand, chunkPos, box, carvingMask);
    }
}

