/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import fi.dy.masa.litematica.render.schematic.BufferAllocatorCache;
import fi.dy.masa.litematica.render.schematic.OverlayRenderType;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;

public class BufferBuilderCache
implements AutoCloseable {
    private final ConcurrentHashMap<RenderType, BufferBuilder> blockBufferBuilders = new ConcurrentHashMap();
    private final ConcurrentHashMap<OverlayRenderType, BufferBuilder> overlayBufferBuilders = new ConcurrentHashMap();

    protected BufferBuilderCache() {
    }

    protected boolean hasBufferByLayer(RenderType layer) {
        return this.blockBufferBuilders.containsKey(layer);
    }

    protected boolean hasBufferByOverlay(OverlayRenderType type) {
        return this.overlayBufferBuilders.containsKey((Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferBuilder getBufferByLayer(RenderType layer, @Nonnull BufferAllocatorCache allocators) {
        ConcurrentHashMap<RenderType, BufferBuilder> concurrentHashMap = this.blockBufferBuilders;
        synchronized (concurrentHashMap) {
            return this.blockBufferBuilders.computeIfAbsent(layer, key -> new BufferBuilder(allocators.getBufferByLayer((RenderType)key), key.mode(), key.format()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferBuilder getBufferByOverlay(OverlayRenderType type, @Nonnull BufferAllocatorCache allocators) {
        ConcurrentHashMap<OverlayRenderType, BufferBuilder> concurrentHashMap = this.overlayBufferBuilders;
        synchronized (concurrentHashMap) {
            return this.overlayBufferBuilders.computeIfAbsent(type, key -> new BufferBuilder(allocators.getBufferByOverlay((OverlayRenderType)((Object)key)), key.getDrawMode(), key.getVertexFormat()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAll() {
        ArrayList<BufferBuilder> buffers;
        Object object = this.blockBufferBuilders;
        synchronized (object) {
            buffers = new ArrayList<BufferBuilder>(this.blockBufferBuilders.values());
            this.blockBufferBuilders.clear();
        }
        object = this.overlayBufferBuilders;
        synchronized (object) {
            buffers.addAll(this.overlayBufferBuilders.values());
            this.overlayBufferBuilders.clear();
        }
        for (BufferBuilder buffer : buffers) {
            try {
                MeshData built = buffer.build();
                if (built == null) continue;
                built.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void close() throws Exception {
        this.clearAll();
    }
}

