/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.fluidvessel;

import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.ConnectedLang;
import com.hlysine.create_connected.content.fluidvessel.FluidVesselBlockEntity;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.ComparatorUtil;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.DeferredSoundType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidVesselBlock
extends Block
implements IWrenchable,
IBE<FluidVesselBlockEntity> {
    public static final BooleanProperty POSITIVE = BooleanProperty.create((String)"positive");
    public static final BooleanProperty NEGATIVE = BooleanProperty.create((String)"negative");
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final EnumProperty<Shape> SHAPE = EnumProperty.create((String)"shape", Shape.class);
    private final boolean creative;
    static final VoxelShape CAMPFIRE_SMOKE_CLIP = Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final SoundType SILENCED_METAL = new DeferredSoundType(0.1f, 1.5f, () -> SoundEvents.METAL_BREAK, () -> SoundEvents.METAL_STEP, () -> SoundEvents.METAL_PLACE, () -> SoundEvents.METAL_HIT, () -> SoundEvents.METAL_FALL);

    public static FluidVesselBlock regular(BlockBehaviour.Properties p_i48440_1_) {
        return new FluidVesselBlock(p_i48440_1_, false);
    }

    public static FluidVesselBlock creative(BlockBehaviour.Properties p_i48440_1_) {
        return new FluidVesselBlock(p_i48440_1_, true);
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy((Level)pLevel, (BlockPos)pPos, (LivingEntity)pPlacer);
    }

    protected FluidVesselBlock(BlockBehaviour.Properties p_i48440_1_, boolean creative) {
        super(p_i48440_1_);
        this.creative = creative;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POSITIVE, (Comparable)Boolean.valueOf(true))).setValue((Property)POSITIVE, (Comparable)Boolean.valueOf(true))).setValue(AXIS, (Comparable)Direction.Axis.X)).setValue(SHAPE, (Comparable)((Object)Shape.WINDOW)));
    }

    public static boolean isVessel(BlockState state) {
        return state.getBlock() instanceof FluidVesselBlock;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        if (oldState.getBlock() == state.getBlock()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, FluidVesselBlockEntity::updateConnectivity);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.add(new Property[]{POSITIVE, NEGATIVE, AXIS, SHAPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState placedOn;
        Direction.Axis preferredAxis;
        if (!(pContext.getPlayer() != null && pContext.getPlayer().isShiftKeyDown() || (preferredAxis = (Direction.Axis)(placedOn = pContext.getLevel().getBlockState(pContext.getClickedPos().relative(pContext.getClickedFace().getOpposite()))).getOptionalValue(AXIS).orElse(null)) == null)) {
            return (BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)preferredAxis);
        }
        return (BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)pContext.getHorizontalDirection().getAxis());
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        FluidVesselBlockEntity vesselAt = (FluidVesselBlockEntity)ConnectivityHandler.partAt(this.getBlockEntityType(), (BlockGetter)world, (BlockPos)pos);
        if (vesselAt == null) {
            return 0;
        }
        FluidVesselBlockEntity controllerBE = vesselAt.getControllerBE();
        if (controllerBE == null || !controllerBE.hasWindow()) {
            return 0;
        }
        return vesselAt.getLuminosity();
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        this.withBlockEntityDo((BlockGetter)context.getLevel(), context.getClickedPos(), FluidVesselBlockEntity::toggleWindows);
        return InteractionResult.SUCCESS;
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pContext == CollisionContext.empty()) {
            return CAMPFIRE_SMOKE_CLIP;
        }
        return pState.getShape(pLevel, pPos);
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.block();
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pDirection == Direction.DOWN && pNeighborState.getBlock() != this) {
            this.withBlockEntityDo((BlockGetter)pLevel, pCurrentPos, FluidTankBlockEntity::updateBoilerTemperature);
        }
        return pState;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        FluidVesselBlockEntity controllerBE;
        Fluid fluid;
        boolean onClient = level.isClientSide;
        if (stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!player.isCreative() && !this.creative) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        FluidHelper.FluidExchange exchange = null;
        FluidVesselBlockEntity be = (FluidVesselBlockEntity)ConnectivityHandler.partAt(this.getBlockEntityType(), (BlockGetter)level, (BlockPos)pos);
        if (be == null) {
            return ItemInteractionResult.FAIL;
        }
        IFluidHandler vesselCapability = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, be.getBlockPos(), null);
        if (vesselCapability == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        FluidStack prevFluidInVessel = vesselCapability.getFluidInTank(0).copy();
        if (FluidHelper.tryEmptyItemIntoBE((Level)level, (Player)player, (InteractionHand)hand, (ItemStack)stack, (SmartBlockEntity)be)) {
            exchange = FluidHelper.FluidExchange.ITEM_TO_TANK;
        } else if (FluidHelper.tryFillItemFromBE((Level)level, (Player)player, (InteractionHand)hand, (ItemStack)stack, (SmartBlockEntity)be)) {
            exchange = FluidHelper.FluidExchange.TANK_TO_ITEM;
        }
        if (exchange == null) {
            if (GenericItemEmptying.canItemBeEmptied((Level)level, (ItemStack)stack) || GenericItemFilling.canItemBeFilled((Level)level, (ItemStack)stack)) {
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        SoundEvent soundevent = null;
        BlockState fluidState = null;
        FluidStack fluidInVessel = vesselCapability.getFluidInTank(0);
        if (exchange == FluidHelper.FluidExchange.ITEM_TO_TANK) {
            FluidStack fluidInItem;
            if (this.creative && !onClient && !(fluidInItem = (FluidStack)GenericItemEmptying.emptyItem((Level)level, (ItemStack)stack, (boolean)true).getFirst()).isEmpty() && vesselCapability instanceof CreativeFluidTankBlockEntity.CreativeSmartFluidTank) {
                CreativeFluidTankBlockEntity.CreativeSmartFluidTank creativeVessel = (CreativeFluidTankBlockEntity.CreativeSmartFluidTank)vesselCapability;
                creativeVessel.setContainedFluid(fluidInItem);
            }
            fluid = fluidInVessel.getFluid();
            fluidState = fluid.defaultFluidState().createLegacyBlock();
            soundevent = FluidHelper.getEmptySound((FluidStack)fluidInVessel);
        }
        if (exchange == FluidHelper.FluidExchange.TANK_TO_ITEM) {
            if (this.creative && !onClient && vesselCapability instanceof CreativeFluidTankBlockEntity.CreativeSmartFluidTank) {
                CreativeFluidTankBlockEntity.CreativeSmartFluidTank creativeVessel = (CreativeFluidTankBlockEntity.CreativeSmartFluidTank)vesselCapability;
                creativeVessel.setContainedFluid(FluidStack.EMPTY);
            }
            fluid = prevFluidInVessel.getFluid();
            fluidState = fluid.defaultFluidState().createLegacyBlock();
            soundevent = FluidHelper.getFillSound((FluidStack)prevFluidInVessel);
        }
        if (soundevent != null && !onClient) {
            float pitch = Mth.clamp((float)(1.0f - 1.0f * (float)fluidInVessel.getAmount() / (float)(FluidVesselBlockEntity.getCapacityMultiplier() * 16)), (float)0.0f, (float)1.0f);
            pitch /= 1.5f;
            pitch += 0.5f;
            level.playSound(null, pos, soundevent, SoundSource.BLOCKS, 0.5f, pitch += (level.random.nextFloat() - 0.5f) / 4.0f);
        }
        if (!FluidStack.isSameFluidSameComponents((FluidStack)fluidInVessel, (FluidStack)prevFluidInVessel) && be instanceof FluidVesselBlockEntity && (controllerBE = be.getControllerBE()) != null) {
            if (fluidState != null && onClient) {
                BlockParticleOption blockParticleData = new BlockParticleOption(ParticleTypes.BLOCK, fluidState);
                float fluidLevel = (float)fluidInVessel.getAmount() / (float)vesselCapability.getTankCapacity(0);
                boolean reversed = fluidInVessel.getFluid().getFluidType().isLighterThanAir();
                if (reversed) {
                    fluidLevel = 1.0f - fluidLevel;
                }
                Vec3 vec = hitResult.getLocation();
                vec = new Vec3(vec.x, (double)((float)controllerBE.getBlockPos().getY() + fluidLevel * ((float)controllerBE.getHeight() - 0.5f) + 0.25f), vec.z);
                Vec3 motion = player.position().subtract(vec).scale((double)0.05f);
                vec = vec.add(motion);
                level.addParticle((ParticleOptions)blockParticleData, vec.x, vec.y, vec.z, motion.x, motion.y, motion.z);
                return ItemInteractionResult.SUCCESS;
            }
            controllerBE.sendDataImmediately();
            controllerBE.setChanged();
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasBlockEntity() && (state.getBlock() != newState.getBlock() || !newState.hasBlockEntity())) {
            BlockEntity be = world.getBlockEntity(pos);
            if (!(be instanceof FluidVesselBlockEntity)) {
                return;
            }
            FluidVesselBlockEntity vesselBE = (FluidVesselBlockEntity)be;
            world.removeBlockEntity(pos);
            ConnectivityHandler.splitMulti((BlockEntity)vesselBE);
        }
    }

    public Class<FluidVesselBlockEntity> getBlockEntityClass() {
        return FluidVesselBlockEntity.class;
    }

    public BlockEntityType<? extends FluidVesselBlockEntity> getBlockEntityType() {
        return this.creative ? (BlockEntityType)CCBlockEntityTypes.CREATIVE_FLUID_VESSEL.get() : (BlockEntityType)CCBlockEntityTypes.FLUID_VESSEL.get();
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        Direction.Axis mirrorAxis = mirror == Mirror.FRONT_BACK ? Direction.Axis.X : Direction.Axis.Z;
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        if (axis == mirrorAxis) {
            return (BlockState)((BlockState)state.setValue((Property)POSITIVE, (Comparable)((Boolean)state.getValue((Property)NEGATIVE)))).setValue((Property)NEGATIVE, (Comparable)((Boolean)state.getValue((Property)POSITIVE)));
        }
        return state;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        for (int i = 0; i < rotation.ordinal(); ++i) {
            state = this.rotateOnce(state);
        }
        return state;
    }

    private BlockState rotateOnce(BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        if (axis == Direction.Axis.X) {
            return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
        }
        if (axis == Direction.Axis.Z) {
            return (BlockState)((BlockState)((BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X)).setValue((Property)POSITIVE, (Comparable)((Boolean)state.getValue((Property)NEGATIVE)))).setValue((Property)NEGATIVE, (Comparable)((Boolean)state.getValue((Property)POSITIVE)));
        }
        return state;
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        SoundType soundType = super.getSoundType(state, world, pos, entity);
        if (entity != null && entity.getPersistentData().contains("SilenceVesselSound")) {
            return SILENCED_METAL;
        }
        return soundType;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        return this.getBlockEntityOptional((BlockGetter)worldIn, pos).map(FluidVesselBlockEntity::getControllerBE).map(be -> ComparatorUtil.fractionToRedstoneLevel((double)be.getFillState())).orElse(0);
    }

    public static void updateBoilerState(BlockState pState, Level pLevel, BlockPos vesselPos) {
        BlockState vesselState = pLevel.getBlockState(vesselPos);
        Block block = vesselState.getBlock();
        if (!(block instanceof FluidVesselBlock)) {
            return;
        }
        FluidVesselBlock vessel = (FluidVesselBlock)block;
        FluidVesselBlockEntity vesselBE = (FluidVesselBlockEntity)vessel.getBlockEntity((BlockGetter)pLevel, vesselPos);
        if (vesselBE == null) {
            return;
        }
        FluidVesselBlockEntity controllerBE = vesselBE.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        controllerBE.updateBoilerState();
    }

    public static enum Shape implements StringRepresentable
    {
        PLAIN,
        WINDOW,
        WINDOW_TOP,
        WINDOW_MIDDLE,
        WINDOW_BOTTOM,
        WINDOW_SINGLE,
        WINDOW_TOP_SINGLE,
        WINDOW_MIDDLE_SINGLE,
        WINDOW_BOTTOM_SINGLE;


        public String getSerializedName() {
            return ConnectedLang.asId((String)this.name());
        }

        public Shape nonSingleVariant() {
            return switch (this.ordinal()) {
                case 5 -> WINDOW;
                case 6 -> WINDOW_TOP;
                case 7 -> WINDOW_MIDDLE;
                case 8 -> WINDOW_BOTTOM;
                default -> this;
            };
        }
    }

    public static enum WindowType implements StringRepresentable
    {
        SIDE_WIDE,
        SIDE_NARROW_ENDS,
        SIDE_NARROW_THIRDS,
        SIDE_HORIZONTAL;


        public String getSerializedName() {
            return ConnectedLang.asId((String)this.name());
        }
    }
}

