/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.linkedtransmitter;

import com.hlysine.create_connected.content.linkedtransmitter.LinkedTransmitterFrequencySlot;
import com.hlysine.create_connected.mixin.linkedtransmitter.AnalogLeverBlockEntityAccessor;
import com.simibubi.create.content.redstone.analogLever.AnalogLeverBlockEntity;
import com.simibubi.create.content.redstone.link.LinkBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;

public class LinkedAnalogLeverBlockEntity
extends AnalogLeverBlockEntity {
    private int transmittedSignal;
    public boolean containsBase = true;
    private LinkBehaviour link;

    public LinkedAnalogLeverBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.createLink();
        behaviours.add((BlockEntityBehaviour)this.link);
    }

    public void initialize() {
        super.initialize();
        this.transmit(this.getState());
    }

    protected void createLink() {
        Pair slots = ValueBoxTransform.Dual.makeSlots(LinkedTransmitterFrequencySlot::new);
        this.link = LinkBehaviour.transmitter((SmartBlockEntity)this, (Pair)slots, this::getSignal);
    }

    public int getSignal() {
        return this.transmittedSignal;
    }

    public void transmit(int strength) {
        this.transmittedSignal = strength;
        if (this.link != null) {
            this.link.notifySignalChange();
        }
    }

    private int lastChange() {
        return ((AnalogLeverBlockEntityAccessor)((Object)this)).getLastChange();
    }

    private LerpedFloat getClientState() {
        return ((AnalogLeverBlockEntityAccessor)((Object)this)).getClientState();
    }

    public void tick() {
        int prevTick = this.lastChange();
        super.tick();
        if (!this.level.isClientSide && prevTick > 0 && this.lastChange() == 0) {
            this.transmit(this.getState());
        }
        if (this.level.isClientSide && prevTick > 0 && this.lastChange() == 0) {
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf((double)this.getClientState().getValue() > 0.1)), 0);
        }
    }

    public void remove() {
        super.remove();
        this.transmit(0);
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putInt("Transmit", this.transmittedSignal);
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        if (this.level == null || this.level.isClientSide || !this.link.newPosition) {
            this.transmittedSignal = compound.getInt("Transmit");
        }
    }
}

