/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.network.c2s;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.entity.EngineVehicle;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class EnginePowerMessage
extends Message {
    public static final StreamCodec<RegistryFriendlyByteBuf, EnginePowerMessage> STREAM_CODEC = StreamCodec.ofMember(EnginePowerMessage::encode, EnginePowerMessage::new);
    public static final CustomPacketPayload.Type<EnginePowerMessage> TYPE = Message.createType("engine_power");
    private final float engineTarget;

    public CustomPacketPayload.Type<EnginePowerMessage> type() {
        return TYPE;
    }

    public EnginePowerMessage(float engineTarget) {
        this.engineTarget = engineTarget;
    }

    public EnginePowerMessage(RegistryFriendlyByteBuf b) {
        this.engineTarget = b.readFloat();
    }

    @Override
    public void encode(RegistryFriendlyByteBuf b) {
        b.writeFloat(this.engineTarget);
    }

    @Override
    public void receiveServer(ServerPlayer e) {
        EngineVehicle entity;
        Entity entity2 = e.getRootVehicle();
        if (entity2 instanceof EngineVehicle && (entity = (EngineVehicle)entity2).hasPassenger((Entity)e)) {
            entity.setEngineTarget(this.engineTarget);
        }
    }
}

