/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.interndep.flowsched.scheduler;

import ca.spottedleaf.starlight.interndep.flowsched.util.Assertions;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import java.util.Objects;

public class BusyRefCounter {
    private final ReferenceList<Runnable> onComplete = new ReferenceArrayList();
    private Runnable onCompleteOnce = null;
    private int counter = 0;

    public synchronized boolean isBusy() {
        return this.counter != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Runnable runnable) {
        Objects.requireNonNull(runnable);
        boolean runNow = false;
        BusyRefCounter busyRefCounter = this;
        synchronized (busyRefCounter) {
            if (!this.isBusy()) {
                runNow = true;
            } else {
                this.onComplete.add((Object)runnable);
            }
        }
        if (runNow) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListenerOnce(Runnable runnable) {
        Objects.requireNonNull(runnable);
        boolean runNow = false;
        BusyRefCounter busyRefCounter = this;
        synchronized (busyRefCounter) {
            if (!this.isBusy()) {
                runNow = true;
            } else {
                this.onCompleteOnce = runnable;
            }
        }
        if (runNow) {
            runnable.run();
        }
    }

    public synchronized void incrementRefCount() {
        ++this.counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementRefCount() {
        Runnable[] onCompleteArray = null;
        Runnable onCompleteOnce = null;
        Runnable[] runnableArray = this;
        synchronized (this) {
            Assertions.assertTrue(this.counter > 0);
            if (--this.counter == 0) {
                onCompleteArray = (Runnable[])this.onComplete.toArray(Runnable[]::new);
                this.onComplete.clear();
            }
            onCompleteOnce = this.onCompleteOnce;
            this.onCompleteOnce = null;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (onCompleteArray != null) {
                for (Runnable runnable : onCompleteArray) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            if (onCompleteOnce != null) {
                try {
                    onCompleteOnce.run();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            return;
        }
    }
}

