/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.interndep.flowsched.scheduler;

import ca.spottedleaf.starlight.interndep.flowsched.scheduler.BusyRefCounter;
import ca.spottedleaf.starlight.interndep.flowsched.scheduler.CancellationSignaller;
import ca.spottedleaf.starlight.interndep.flowsched.scheduler.ItemStatus;
import ca.spottedleaf.starlight.interndep.flowsched.scheduler.ItemTicket;
import ca.spottedleaf.starlight.interndep.flowsched.scheduler.KeyStatusPair;
import ca.spottedleaf.starlight.interndep.flowsched.scheduler.ObjectFactory;
import ca.spottedleaf.starlight.interndep.flowsched.scheduler.StatusAdvancingScheduler;
import ca.spottedleaf.starlight.interndep.flowsched.scheduler.TicketSet;
import ca.spottedleaf.starlight.interndep.flowsched.util.Assertions;
import io.reactivex.rxjava3.core.Completable;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class ItemHolder<K, V, Ctx, UserData> {
    private static final VarHandle FUTURES_HANDLE = MethodHandles.arrayElementVarHandle(CompletableFuture[].class);
    public static final IllegalStateException UNLOADED_EXCEPTION = new IllegalStateException("Not loaded");
    private static final CompletableFuture<Void> UNLOADED_FUTURE = CompletableFuture.failedFuture(UNLOADED_EXCEPTION);
    private static final CompletableFuture<Void> COMPLETED_VOID_FUTURE = CompletableFuture.completedFuture(null);
    public static final int FLAG_REMOVED = 1;
    public static final int FLAG_BROKEN = 2;
    public static final int FLAG_HAVE_RETRIED = 4;
    private final K key;
    private final ItemStatus<K, V, Ctx> unloadedStatus;
    private final AtomicReference<V> item = new AtomicReference();
    private final AtomicReference<UserData> userData = new AtomicReference();
    private final BusyRefCounter busyRefCounter = new BusyRefCounter();
    private final AtomicReference<Pair<CancellationSignaller, ItemStatus<K, V, Ctx>>> runningUpgradeAction = new AtomicReference();
    private final TicketSet<K, V, Ctx> tickets;
    private volatile ItemStatus<K, V, Ctx> status = null;
    private final KeyStatusPair<K, V, Ctx>[][] requestedDependencies;
    private final CompletableFuture<Void>[] futures;
    private final AtomicInteger flags = new AtomicInteger(0);
    private final Object2ReferenceLinkedOpenHashMap<K, DependencyInfo> dependencyInfos = new Object2ReferenceLinkedOpenHashMap<K, DependencyInfo>(){

        protected void rehash(int newN) {
            if (this.n < newN) {
                super.rehash(newN);
            }
        }
    };
    private boolean dependencyDirty = false;

    ItemHolder(ItemStatus<K, V, Ctx> initialStatus, K key, ObjectFactory objectFactory) {
        this.unloadedStatus = Objects.requireNonNull(initialStatus);
        this.status = this.unloadedStatus;
        this.key = Objects.requireNonNull(key);
        this.tickets = new TicketSet<K, V, Ctx>(this.unloadedStatus, objectFactory);
        ItemStatus<K, V, Ctx>[] allStatuses = initialStatus.getAllStatuses();
        this.futures = new CompletableFuture[allStatuses.length];
        this.requestedDependencies = new KeyStatusPair[allStatuses.length][];
        int allStatusesLength = allStatuses.length;
        for (int i = 0; i < allStatusesLength; ++i) {
            this.futures[i] = UNLOADED_FUTURE;
            this.requestedDependencies[i] = null;
        }
        VarHandle.fullFence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFutures() {
        this.assertOpen();
        CompletableFuture<Void>[] completableFutureArray = this.futures;
        synchronized (this.futures) {
            ItemStatus<K, V, Ctx> targetStatus = this.getTargetStatus();
            for (int i = this.unloadedStatus.ordinal() + 1; i <= targetStatus.ordinal(); ++i) {
                this.futures[i] = this.futures[i] == UNLOADED_FUTURE ? new CompletableFuture() : this.futures[i];
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public ItemStatus<K, V, Ctx> getTargetStatus() {
        return this.tickets.getTargetStatus();
    }

    public ItemStatus<K, V, Ctx> getStatus() {
        return this.status;
    }

    public synchronized boolean isBusy() {
        this.assertOpen();
        return this.busyRefCounter.isBusy();
    }

    public ItemStatus<K, V, Ctx> upgradingStatusTo() {
        this.assertOpen();
        Pair<CancellationSignaller, ItemStatus<K, V, Ctx>> pair = this.runningUpgradeAction.get();
        return pair != null ? (ItemStatus)pair.right() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTicket(ItemTicket<K, V, Ctx> ticket) {
        boolean needConsumption;
        this.assertOpen();
        boolean add = this.tickets.add(ticket);
        if (!add) {
            throw new IllegalStateException("Ticket already exists");
        }
        this.createFutures();
        ItemHolder itemHolder = this;
        synchronized (itemHolder) {
            needConsumption = ticket.getTargetStatus().ordinal() <= this.getStatus().ordinal();
        }
        if (needConsumption) {
            ticket.consumeCallback();
        }
    }

    public void removeTicket(ItemTicket<K, V, Ctx> ticket) {
        this.assertOpen();
        boolean remove = this.tickets.remove(ticket);
        if (!remove) {
            throw new IllegalStateException("Ticket does not exist");
        }
    }

    public void submitOp(CompletionStage<Void> op) {
        this.assertOpen();
        this.busyRefCounter.incrementRefCount();
        op.whenComplete((unused, throwable) -> this.busyRefCounter.decrementRefCount());
    }

    public void subscribeOp(Completable op) {
        this.assertOpen();
        this.busyRefCounter.incrementRefCount();
        op.onErrorComplete().subscribe(this.busyRefCounter::decrementRefCount);
    }

    BusyRefCounter busyRefCounter() {
        return this.busyRefCounter;
    }

    public void submitUpgradeAction(CancellationSignaller signaller, ItemStatus<K, V, Ctx> status) {
        this.assertOpen();
        boolean success = this.runningUpgradeAction.compareAndSet(null, Pair.of((Object)signaller, status));
        Assertions.assertTrue(success, "Only one action can happen at a time");
        signaller.addListener(unused -> this.runningUpgradeAction.set(null));
    }

    public void tryCancelUpgradeAction() {
        this.assertOpen();
        Pair<CancellationSignaller, ItemStatus<K, V, Ctx>> signaller = this.runningUpgradeAction.get();
        if (signaller != null) {
            ((CancellationSignaller)signaller.left()).cancel();
        }
    }

    public CompletableFuture<Void> getOpFuture() {
        this.assertOpen();
        if (!this.busyRefCounter.isBusy()) {
            return COMPLETED_VOID_FUTURE;
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.busyRefCounter.addListener(() -> future.complete(null));
        return future;
    }

    public void submitOpListener(Runnable runnable) {
        this.assertOpen();
        this.busyRefCounter.addListener(runnable);
    }

    public void consolidateMarkDirty(StatusAdvancingScheduler<K, V, Ctx, ?> scheduler) {
        this.assertOpen();
        this.busyRefCounter.addListenerOnce(() -> scheduler.markDirty(this.getKey()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setStatus(ItemStatus<K, V, Ctx> status) {
        this.assertOpen();
        ItemTicket[] ticketsToFire = null;
        CompletableFuture<Void> futureToFire = null;
        ItemHolder itemHolder = this;
        synchronized (itemHolder) {
            ItemStatus<K, V, Ctx> prevStatus = this.getStatus();
            Assertions.assertTrue(status != prevStatus, "duplicate setStatus call");
            int compare = Integer.compare(status.ordinal(), prevStatus.ordinal());
            if (compare < 0) {
                Assertions.assertTrue(prevStatus.getPrev() == status, "Invalid status downgrade");
                if (this.getTargetStatus().ordinal() > status.ordinal()) {
                    return false;
                }
                this.status = status;
                CompletableFuture<Void>[] completableFutureArray = this.futures;
                synchronized (this.futures) {
                    ItemStatus<K, V, Ctx> targetStatus = this.getTargetStatus();
                    for (int i = prevStatus.ordinal(); i < this.futures.length; ++i) {
                        if (i > targetStatus.ordinal()) {
                            this.futures[i].completeExceptionally(UNLOADED_EXCEPTION);
                            this.futures[i] = UNLOADED_FUTURE;
                            continue;
                        }
                        this.futures[i] = this.futures[i].isDone() ? new CompletableFuture() : this.futures[i];
                    }
                    // ** MonitorExit[completableFutureArray] (shouldn't be in output)
                }
            } else if (compare > 0) {
                Assertions.assertTrue(prevStatus.getNext() == status, "Invalid status upgrade");
                this.status = status;
                CompletableFuture<Void> completableFuture = this.futures[status.ordinal()];
                Assertions.assertTrue(completableFuture != UNLOADED_FUTURE);
                Assertions.assertTrue(!completableFuture.isDone());
                futureToFire = completableFuture;
                ticketsToFire = (ItemTicket[])this.tickets.getTicketsForStatus(status).toArray(ItemTicket[]::new);
            }
            {
            }
        }
        {
            if (ticketsToFire != null) {
                for (ItemHolder itemHolder2 : ticketsToFire) {
                    ((ItemTicket)((Object)itemHolder2)).consumeCallback();
                }
            }
            if (futureToFire != null) {
                futureToFire.complete(null);
            }
            return true;
        }
    }

    public synchronized void setDependencies(ItemStatus<K, V, Ctx> status, KeyStatusPair<K, V, Ctx>[] dependencies) {
        this.assertOpen();
        int ordinal = status.ordinal();
        if (dependencies != null) {
            Assertions.assertTrue(this.requestedDependencies[ordinal] == null, "Duplicate setDependencies call");
            this.requestedDependencies[ordinal] = dependencies;
        } else {
            Assertions.assertTrue(this.requestedDependencies[ordinal] != null, "Duplicate setDependencies call");
            this.requestedDependencies[ordinal] = null;
        }
    }

    public synchronized KeyStatusPair<K, V, Ctx>[] getDependencies(ItemStatus<K, V, Ctx> status) {
        this.assertOpen();
        return this.requestedDependencies[status.ordinal()];
    }

    public K getKey() {
        return this.key;
    }

    public synchronized CompletableFuture<Void> getFutureForStatus(ItemStatus<K, V, Ctx> status) {
        return this.futures[status.ordinal()].thenApply(Function.identity());
    }

    public synchronized CompletableFuture<Void> getFutureForStatus0(ItemStatus<K, V, Ctx> status) {
        return this.futures[status.ordinal()];
    }

    public AtomicReference<V> getItem() {
        return this.item;
    }

    public AtomicReference<UserData> getUserData() {
        return this.userData;
    }

    public int getFlags() {
        return this.flags.get();
    }

    public void setFlag(int flag) {
        this.assertOpen();
        this.flags.getAndUpdate(operand -> operand | flag);
    }

    void release() {
        this.assertOpen();
        this.tickets.assertEmpty();
        this.setFlag(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependencyTicket(StatusAdvancingScheduler<K, V, Ctx, ?> scheduler, K key, ItemStatus<K, V, Ctx> status, Runnable callback) {
        Object2ReferenceLinkedOpenHashMap<K, DependencyInfo> object2ReferenceLinkedOpenHashMap = this.dependencyInfos;
        synchronized (object2ReferenceLinkedOpenHashMap) {
            DependencyInfo info = (DependencyInfo)this.dependencyInfos.computeIfAbsent(key, k -> new DependencyInfo(status.getAllStatuses().length));
            int ordinal = status.ordinal();
            if (info.refCnt[ordinal] == -1) {
                info.refCnt[ordinal] = 0;
                info.callbacks[ordinal] = new ObjectArrayList();
                scheduler.addTicket(key, ItemTicket.TicketType.DEPENDENCY, this.getKey(), status, () -> {
                    ObjectArrayList<Runnable> list;
                    ObjectListIterator objectListIterator = this.dependencyInfos;
                    synchronized (objectListIterator) {
                        list = info.callbacks[ordinal];
                        if (list != null) {
                            info.callbacks[ordinal] = null;
                        }
                    }
                    if (list != null) {
                        for (Runnable runnable : list) {
                            try {
                                runnable.run();
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                    }
                });
            }
            int n = ordinal;
            info.refCnt[n] = info.refCnt[n] + 1;
            ObjectArrayList<Runnable> list = info.callbacks[ordinal];
            if (list != null) {
                list.add((Object)callback);
            } else {
                callback.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDependencyTicket(K key, ItemStatus<K, V, Ctx> status) {
        Object2ReferenceLinkedOpenHashMap<K, DependencyInfo> object2ReferenceLinkedOpenHashMap = this.dependencyInfos;
        synchronized (object2ReferenceLinkedOpenHashMap) {
            DependencyInfo info = (DependencyInfo)this.dependencyInfos.get(key);
            Assertions.assertTrue(info != null);
            int n = status.ordinal();
            int n2 = info.refCnt[n];
            info.refCnt[n] = n2 - 1;
            int old = n2;
            Assertions.assertTrue(old > 0);
            if (old == 1) {
                this.dependencyDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDependencyDirty() {
        Object2ReferenceLinkedOpenHashMap<K, DependencyInfo> object2ReferenceLinkedOpenHashMap = this.dependencyInfos;
        synchronized (object2ReferenceLinkedOpenHashMap) {
            return this.dependencyDirty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean holdsDependency() {
        Object2ReferenceLinkedOpenHashMap<K, DependencyInfo> object2ReferenceLinkedOpenHashMap = this.dependencyInfos;
        synchronized (object2ReferenceLinkedOpenHashMap) {
            ObjectBidirectionalIterator iterator = this.dependencyInfos.object2ReferenceEntrySet().fastIterator();
            while (iterator.hasNext()) {
                int[] refCnt;
                Object2ReferenceMap.Entry entry = (Object2ReferenceMap.Entry)iterator.next();
                DependencyInfo info = (DependencyInfo)entry.getValue();
                for (int i : refCnt = info.refCnt) {
                    if (i == -1) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupDependencies(StatusAdvancingScheduler<K, V, Ctx, ?> scheduler) {
        Object2ReferenceLinkedOpenHashMap<K, DependencyInfo> object2ReferenceLinkedOpenHashMap = this.dependencyInfos;
        synchronized (object2ReferenceLinkedOpenHashMap) {
            if (!this.dependencyDirty) {
                return;
            }
            ObjectBidirectionalIterator iterator = this.dependencyInfos.object2ReferenceEntrySet().fastIterator();
            while (iterator.hasNext()) {
                Object2ReferenceMap.Entry entry = (Object2ReferenceMap.Entry)iterator.next();
                Object key = entry.getKey();
                DependencyInfo info = (DependencyInfo)entry.getValue();
                int[] refCnt = info.refCnt;
                boolean isEmpty = true;
                int refCntLength = refCnt.length;
                for (int ordinal = 0; ordinal < refCntLength; ++ordinal) {
                    if (refCnt[ordinal] == 0) {
                        scheduler.removeTicket(key, ItemTicket.TicketType.DEPENDENCY, this.getKey(), this.unloadedStatus.getAllStatuses()[ordinal]);
                        refCnt[ordinal] = -1;
                        info.callbacks[ordinal] = null;
                    }
                    if (refCnt[ordinal] == -1) continue;
                    isEmpty = false;
                }
                if (!isEmpty) continue;
                iterator.remove();
            }
            this.dependencyDirty = false;
        }
    }

    private void assertOpen() {
        Assertions.assertTrue(this.isOpen());
    }

    public boolean isOpen() {
        return (this.getFlags() & 1) == 0;
    }

    private static class DependencyInfo {
        private final int[] refCnt;
        private final ObjectArrayList<Runnable>[] callbacks;

        private DependencyInfo(int statuses) {
            this.refCnt = new int[statuses];
            this.callbacks = new ObjectArrayList[statuses];
            Arrays.fill(this.refCnt, -1);
        }
    }
}

