/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.mixin.common.blockstate;

import ca.spottedleaf.starlight.common.blockstate.ExtendedAbstractBlockState;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.extensions.IBlockExtension;
import net.neoforged.neoforge.common.extensions.IBlockStateExtension;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class BlockStateBaseMixin
extends StateHolder<Block, BlockState>
implements ExtendedAbstractBlockState {
    @Shadow
    @Final
    private boolean useShapeForLightOcclusion;
    @Shadow
    @Final
    private boolean canOcclude;
    @Shadow
    protected BlockBehaviour.BlockStateBase.Cache cache;
    @Unique
    private int opacityIfCached;
    @Unique
    private boolean isConditionallyFullOpaque;
    @Unique
    private boolean scalablelux$actuallyDynamicLightEmission;

    @Shadow
    public abstract Block getBlock();

    protected BlockStateBaseMixin(Block object, Reference2ObjectArrayMap<Property<?>, Comparable<?>> reference2ObjectArrayMap, MapCodec<BlockState> mapCodec) {
        super((Object)object, reference2ObjectArrayMap, mapCodec);
    }

    @Inject(method={"initCache()V"}, at={@At(value="RETURN")})
    public void initLightAccessState(CallbackInfo ci) {
        this.isConditionallyFullOpaque = this.canOcclude & this.useShapeForLightOcclusion;
        this.opacityIfCached = this.cache == null || this.isConditionallyFullOpaque ? -1 : this.cache.lightBlock;
        try {
            IBlockStateExtension extension;
            BlockStateBaseMixin blockStateBaseMixin = this;
            if (blockStateBaseMixin instanceof IBlockStateExtension && (extension = (IBlockStateExtension)blockStateBaseMixin).hasDynamicLightEmission() || this.getClass().getMethod("getLightEmission", BlockGetter.class, BlockPos.class).getDeclaringClass() != IBlockStateExtension.class || this.getBlock().getClass().getMethod("getLightEmission", BlockState.class, BlockGetter.class, BlockPos.class).getDeclaringClass() != IBlockExtension.class) {
                this.opacityIfCached = -1;
                this.scalablelux$actuallyDynamicLightEmission = true;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.opacityIfCached = -1;
            this.scalablelux$actuallyDynamicLightEmission = true;
        }
    }

    @Override
    public final boolean isConditionallyFullOpaque() {
        return this.isConditionallyFullOpaque;
    }

    @Override
    public final int getOpacityIfCached() {
        return this.opacityIfCached;
    }

    @Override
    @Unique
    public boolean scalablelux$actuallyDynamicLightEmission() {
        return this.scalablelux$actuallyDynamicLightEmission;
    }
}

