/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import net.mehvahdjukaar.moonlight.api.block.IColored;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AwningBlock
extends WaterBlock
implements IColored {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty BOTTOM = BlockStateProperties.BOTTOM;
    public static final BooleanProperty SLANTED = ModBlockProperties.SLANTED;
    protected static final VoxelShape BOTTOM_INTERACTION = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape BOTTOM_COLLISION = Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TOP_INTERACTION = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape TOP_COLLISION = Block.box((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final DyeColor color;

    public AwningBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(false))).setValue((Property)SLANTED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean canBeReplaced(BlockState state, Fluid fluid) {
        return true;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        return !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState behindAbove;
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos behind = pos.relative(direction.getOpposite());
        BlockState behindState = level.getBlockState(behind);
        if (behindState.isSolid()) {
            return true;
        }
        if (behindState.getBlock() instanceof AwningBlock) {
            if (!((Boolean)behindState.getValue((Property)SLANTED)).booleanValue()) {
                return true;
            }
            if (((Boolean)behindState.getValue((Property)SLANTED)).booleanValue() && ((Boolean)state.getValue((Property)BOTTOM)).booleanValue()) {
                return true;
            }
        }
        if ((behindAbove = level.getBlockState(behind.above())).getBlock() instanceof AwningBlock && ((Boolean)behindAbove.getValue((Property)SLANTED)).booleanValue()) {
            return true;
        }
        BlockState left = level.getBlockState(pos.relative(direction.getClockWise()));
        BlockState right = level.getBlockState(pos.relative(direction.getCounterClockWise()));
        return left.isSolid() || right.isSolid();
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        if (side.getAxis().isHorizontal() && !((Boolean)state.getValue((Property)SLANTED)).booleanValue() && adjacentBlockState.getBlock() instanceof AwningBlock && adjacentBlockState.getValue((Property)BOTTOM) == state.getValue((Property)BOTTOM)) {
            if (((Boolean)adjacentBlockState.getValue((Property)SLANTED)).booleanValue()) {
                return state.getValue((Property)FACING) != adjacentBlockState.getValue((Property)FACING);
            }
            return true;
        }
        return super.skipRendering(state, adjacentBlockState, side);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)BOTTOM) != false ? BOTTOM_INTERACTION : TOP_INTERACTION;
    }

    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.getValue((Property)BOTTOM) != false ? BOTTOM_COLLISION : TOP_COLLISION;
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)BOTTOM) != false ? BOTTOM_INTERACTION : TOP_INTERACTION;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ec;
        boolean bottom = (Boolean)state.getValue((Property)BOTTOM);
        if (CommonConfigs.Building.AWNING_FALL_THROUGH.get().booleanValue() && context instanceof EntityCollisionContext && (ec = (EntityCollisionContext)context).getEntity() != null && (context.isDescending() || !context.isAbove(bottom ? TOP_COLLISION : BOTTOM_COLLISION, bottom ? pos.below() : pos, false))) {
            return Shapes.empty();
        }
        return super.getCollisionShape(state, level, pos, context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SLANTED});
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{BOTTOM});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = super.getStateForPlacement(context);
        Direction face = context.getClickedFace();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        LinkedList<Direction> directions = new LinkedList<Direction>(Arrays.stream(context.getNearestLookingDirections()).toList());
        BlockState clickedOn = level.getBlockState(pos.relative(face.getOpposite()));
        boolean slanted = false;
        if (clickedOn.getBlock() instanceof AwningBlock) {
            Direction dir = ((Direction)clickedOn.getValue((Property)FACING)).getOpposite();
            if (context.getNearestLookingDirection() == dir) {
                directions.remove(dir);
                directions.add(0, dir);
                if (((Boolean)clickedOn.getValue((Property)SLANTED)).booleanValue()) {
                    slanted = true;
                }
            }
        }
        for (Direction direction : directions) {
            if (!direction.getAxis().isHorizontal()) continue;
            Direction opposite = direction.getOpposite();
            boolean bottom = !(face == Direction.DOWN || face != Direction.UP && context.getClickLocation().y - (double)pos.getY() > 0.5);
            ArrayList<BlockPos> behindPos = new ArrayList<BlockPos>();
            behindPos.add(pos.relative(direction));
            if (!bottom) {
                behindPos.add(pos.relative(direction).above());
            }
            if (!CommonConfigs.Building.AWNING_SLANT.get().booleanValue()) {
                behindPos.clear();
            }
            for (int i = 0; i < behindPos.size(); ++i) {
                BlockState behindState = level.getBlockState((BlockPos)behindPos.get(i));
                if (!(behindState.getBlock() instanceof AwningBlock) || !((Boolean)behindState.getValue((Property)SLANTED)).booleanValue() || behindState.getValue((Property)FACING) != direction.getOpposite()) continue;
                bottom = i == 0;
                slanted = true;
                break;
            }
            if (!(blockState = (BlockState)((BlockState)((BlockState)blockState.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(bottom))).setValue((Property)SLANTED, (Comparable)Boolean.valueOf(slanted))).setValue((Property)FACING, (Comparable)opposite)).canSurvive((LevelReader)level, pos)) continue;
            return blockState;
        }
        return null;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (entity.isSuppressingBounce()) {
            super.fallOn(level, state, pos, entity, fallDistance);
        } else {
            entity.causeFallDamage(fallDistance, 0.0f, level.damageSources().fall());
        }
    }

    public void updateEntityAfterFallOn(BlockGetter level, Entity entity) {
        if (entity.isSuppressingBounce() || entity.getType().is(ModTags.AWNING_BLACKLIST)) {
            super.updateEntityAfterFallOn(level, entity);
        }
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!entity.isSuppressingBounce() && !entity.getType().is(ModTags.AWNING_BLACKLIST)) {
            Vec3 movement = entity.getDeltaMovement();
            if (movement.y < (double)-0.32f) {
                Vector3f normal = AwningBlock.getNormalVector(state);
                Vector3f newMovement = movement.toVector3f().reflect((Vector3fc)normal);
                entity.setDeltaMovement(new Vec3(newMovement));
                entity.hasImpulse = true;
                level.playSound(null, pos, ModSounds.AWNING_BOUNCES.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
            }
        }
        super.stepOn(level, pos, state, entity);
    }

    @NotNull
    public static Vector3f getNormalVector(BlockState state) {
        if (!((Boolean)state.getValue((Property)SLANTED)).booleanValue()) {
            return new Vector3f(0.0f, 1.0f, 0.0f);
        }
        Direction dir = (Direction)state.getValue((Property)FACING);
        Vector3f normal = new Vector3f(0.0f, 1.0f, 0.0f);
        if (((Boolean)state.getValue((Property)SLANTED)).booleanValue()) {
            double angleDeg = CommonConfigs.Building.AWNINGS_BOUNCE_ANGLE.get();
            normal.rotate((Quaternionfc)Axis.XP.rotationDegrees((float)(90.0 - angleDeg)));
        }
        normal.rotate((Quaternionfc)Axis.YP.rotationDegrees(-dir.toYRot()));
        return normal;
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public boolean supportsBlankColor() {
        return true;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (CommonConfigs.Building.AWNING_SLANT.get().booleanValue() && stack.isEmpty()) {
            level.setBlock(pos, (BlockState)state.cycle((Property)SLANTED), 3);
            boolean isSlanted = (Boolean)state.getValue((Property)SLANTED);
            level.playSound(player, pos, this.getSoundType(state).getPlaceSound(), SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
            level.gameEvent((Entity)player, (Holder)(isSlanted ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

