/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.LightUpBlock;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.GunpowderExplosion;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GunpowderBlock
extends LightUpBlock {
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.NORTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.EAST_REDSTONE;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.SOUTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.WEST_REDSTONE;
    public static final IntegerProperty BURNING = ModBlockProperties.BURNING;
    public static final Map<Direction, EnumProperty<RedstoneSide>> PROPERTY_BY_DIRECTION = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));
    private static final VoxelShape SHAPE_DOT = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final Map<Direction, VoxelShape> SHAPES_FLOOR = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), (Object)Direction.SOUTH, (Object)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), (Object)Direction.EAST, (Object)Block.box((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), (Object)Direction.WEST, (Object)Block.box((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)));
    private static final Map<Direction, VoxelShape> SHAPES_UP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.or((VoxelShape)SHAPES_FLOOR.get(Direction.NORTH), (VoxelShape)Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0)), (Object)Direction.SOUTH, (Object)Shapes.or((VoxelShape)SHAPES_FLOOR.get(Direction.SOUTH), (VoxelShape)Block.box((double)3.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0, (double)16.0)), (Object)Direction.EAST, (Object)Shapes.or((VoxelShape)SHAPES_FLOOR.get(Direction.EAST), (VoxelShape)Block.box((double)15.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0)), (Object)Direction.WEST, (Object)Shapes.or((VoxelShape)SHAPES_FLOOR.get(Direction.WEST), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)16.0, (double)13.0))));
    private final Map<BlockState, VoxelShape> SHAPES_CACHE;
    private final BlockState crossState;

    private static int getDelay() {
        return CommonConfigs.Tweaks.GUNPOWDER_BURN_SPEED.get();
    }

    private static int getSpreadAge() {
        return CommonConfigs.Tweaks.GUNPOWDER_SPREAD_AGE.get();
    }

    public GunpowderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(NORTH, (Comparable)RedstoneSide.NONE)).setValue(EAST, (Comparable)RedstoneSide.NONE)).setValue(SOUTH, (Comparable)RedstoneSide.NONE)).setValue(WEST, (Comparable)RedstoneSide.NONE)).setValue((Property)BURNING, (Comparable)Integer.valueOf(0)));
        this.crossState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(NORTH, (Comparable)RedstoneSide.SIDE)).setValue(EAST, (Comparable)RedstoneSide.SIDE)).setValue(SOUTH, (Comparable)RedstoneSide.SIDE)).setValue(WEST, (Comparable)RedstoneSide.SIDE)).setValue((Property)BURNING, (Comparable)Integer.valueOf(0));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState blockstate : this.getStateDefinition().getPossibleStates()) {
            if ((Integer)blockstate.getValue((Property)BURNING) != 0) continue;
            builder.put((Object)blockstate, (Object)this.calculateVoxelShape(blockstate));
        }
        this.SHAPES_CACHE = builder.build();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, BURNING});
    }

    private VoxelShape calculateVoxelShape(BlockState state) {
        VoxelShape voxelshape = SHAPE_DOT;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.getValue((Property)PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneside == RedstoneSide.SIDE) {
                voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)SHAPES_FLOOR.get(direction));
                continue;
            }
            if (redstoneside != RedstoneSide.UP) continue;
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)SHAPES_UP.get(direction));
        }
        return voxelshape;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.SHAPES_CACHE.get(state.setValue((Property)BURNING, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getConnectionState((BlockGetter)context.getLevel(), this.crossState, context.getClickedPos());
    }

    private BlockState getConnectionState(BlockGetter world, BlockState state, BlockPos pos) {
        boolean isDot = GunpowderBlock.isDot(state);
        state = this.getMissingConnections(world, (BlockState)this.defaultBlockState().setValue((Property)BURNING, (Comparable)((Integer)state.getValue((Property)BURNING))), pos);
        if (!isDot || !GunpowderBlock.isDot(state)) {
            boolean noZAxis;
            boolean northConnected = ((RedstoneSide)state.getValue(NORTH)).isConnected();
            boolean southConnected = ((RedstoneSide)state.getValue(SOUTH)).isConnected();
            boolean eastConnected = ((RedstoneSide)state.getValue(EAST)).isConnected();
            boolean westConnected = ((RedstoneSide)state.getValue(WEST)).isConnected();
            boolean noXAxis = !northConnected && !southConnected;
            boolean bl = noZAxis = !eastConnected && !westConnected;
            if (!westConnected && noXAxis) {
                state = (BlockState)state.setValue(WEST, (Comparable)RedstoneSide.SIDE);
            }
            if (!eastConnected && noXAxis) {
                state = (BlockState)state.setValue(EAST, (Comparable)RedstoneSide.SIDE);
            }
            if (!northConnected && noZAxis) {
                state = (BlockState)state.setValue(NORTH, (Comparable)RedstoneSide.SIDE);
            }
            if (!southConnected && noZAxis) {
                state = (BlockState)state.setValue(SOUTH, (Comparable)RedstoneSide.SIDE);
            }
        }
        return state;
    }

    private BlockState getMissingConnections(BlockGetter world, BlockState state, BlockPos pos) {
        boolean canClimbUp = !world.getBlockState(pos.above()).isRedstoneConductor(world, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)state.getValue((Property)PROPERTY_BY_DIRECTION.get(direction))).isConnected()) continue;
            RedstoneSide redstoneside = this.getConnectingSide(world, pos, direction, canClimbUp);
            state = (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside);
        }
        return state;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState otherState, LevelAccessor world, BlockPos pos, BlockPos otherPos) {
        RedstoneSide redstoneside;
        BlockState newState = direction == Direction.DOWN ? (this.canSurvive(state, (LevelReader)world, pos) ? state : Blocks.AIR.defaultBlockState()) : (direction == Direction.UP ? this.getConnectionState((BlockGetter)world, state, pos) : ((redstoneside = this.getConnectingSide((BlockGetter)world, pos, direction)).isConnected() == ((RedstoneSide)state.getValue((Property)PROPERTY_BY_DIRECTION.get(direction))).isConnected() && !GunpowderBlock.isCross(state) ? (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside) : this.getConnectionState((BlockGetter)world, (BlockState)((BlockState)this.crossState.setValue((Property)BURNING, (Comparable)((Integer)state.getValue((Property)BURNING)))).setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside), pos)));
        return newState;
    }

    private static boolean isCross(BlockState state) {
        return ((RedstoneSide)state.getValue(NORTH)).isConnected() && ((RedstoneSide)state.getValue(SOUTH)).isConnected() && ((RedstoneSide)state.getValue(EAST)).isConnected() && ((RedstoneSide)state.getValue(WEST)).isConnected();
    }

    private static boolean isDot(BlockState state) {
        return !((RedstoneSide)state.getValue(NORTH)).isConnected() && !((RedstoneSide)state.getValue(SOUTH)).isConnected() && !((RedstoneSide)state.getValue(EAST)).isConnected() && !((RedstoneSide)state.getValue(WEST)).isConnected();
    }

    public void updateIndirectNeighbourShapes(BlockState state, LevelAccessor world, BlockPos pos, int var1, int var2) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.getValue((Property)PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneside == RedstoneSide.NONE || world.getBlockState((BlockPos)mutable.setWithOffset((Vec3i)pos, direction)).is((Block)this)) continue;
            mutable.move(Direction.DOWN);
            BlockState downState = world.getBlockState((BlockPos)mutable);
            if (!downState.is(Blocks.OBSERVER)) {
                BlockPos blockpos = mutable.relative(direction.getOpposite());
                BlockState blockstate1 = downState.updateShape(direction.getOpposite(), world.getBlockState(blockpos), world, (BlockPos)mutable, blockpos);
                GunpowderBlock.updateOrDestroy((BlockState)downState, (BlockState)blockstate1, (LevelAccessor)world, (BlockPos)mutable, (int)var1, (int)var2);
            }
            mutable.setWithOffset((Vec3i)pos, direction).move(Direction.UP);
            BlockState upState = world.getBlockState((BlockPos)mutable);
            if (upState.is(Blocks.OBSERVER)) continue;
            BlockPos pos1 = mutable.relative(direction.getOpposite());
            BlockState blockstate2 = upState.updateShape(direction.getOpposite(), world.getBlockState(pos1), world, (BlockPos)mutable, pos1);
            GunpowderBlock.updateOrDestroy((BlockState)upState, (BlockState)blockstate2, (LevelAccessor)world, (BlockPos)mutable, (int)var1, (int)var2);
        }
    }

    private RedstoneSide getConnectingSide(BlockGetter world, BlockPos pos, Direction dir) {
        return this.getConnectingSide(world, pos, dir, !world.getBlockState(pos.above()).isRedstoneConductor(world, pos));
    }

    private RedstoneSide getConnectingSide(BlockGetter world, BlockPos pos, Direction dir, boolean canClimbUp) {
        boolean canSurvive;
        BlockPos facingPos = pos.relative(dir);
        BlockState facingState = world.getBlockState(facingPos);
        if (canClimbUp && (canSurvive = this.canSurviveOn(world, facingPos, facingState)) && this.canClimbTo(world.getBlockState(facingPos.above()), world, facingPos.above(), null)) {
            if (facingState.isFaceSturdy(world, facingPos, dir.getOpposite())) {
                return RedstoneSide.UP;
            }
            return RedstoneSide.SIDE;
        }
        return !this.canConnectTo(facingState, world, facingPos, dir) && (facingState.isRedstoneConductor(world, facingPos) || !this.canConnectTo(world.getBlockState(facingPos.below()), world, facingPos.below(), null)) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate = world.getBlockState(blockpos);
        return this.canSurviveOn((BlockGetter)world, blockpos, blockstate);
    }

    private boolean canSurviveOn(BlockGetter world, BlockPos pos, BlockState state) {
        return state.isFaceSturdy(world, pos, Direction.UP) || state.is(Blocks.HOPPER);
    }

    protected boolean canClimbTo(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction dir) {
        Block b = state.getBlock();
        return state.is(ModTags.LIGHTABLE_BY_GUNPOWDER) || b instanceof ILightable || b instanceof TntBlock || b instanceof AbstractCandleBlock;
    }

    protected boolean canConnectTo(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction dir) {
        Block b = state.getBlock();
        return state.is(ModTags.LIGHTS_GUNPOWDER) || state.is(ModTags.LIGHTABLE_BY_GUNPOWDER) || b instanceof ILightable || b instanceof TntBlock || b instanceof AbstractCandleBlock;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((RedstoneSide)state.getValue(SOUTH)))).setValue(EAST, (Comparable)((RedstoneSide)state.getValue(WEST)))).setValue(SOUTH, (Comparable)((RedstoneSide)state.getValue(NORTH)))).setValue(WEST, (Comparable)((RedstoneSide)state.getValue(EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((RedstoneSide)state.getValue(EAST)))).setValue(EAST, (Comparable)((RedstoneSide)state.getValue(SOUTH)))).setValue(SOUTH, (Comparable)((RedstoneSide)state.getValue(WEST)))).setValue(WEST, (Comparable)((RedstoneSide)state.getValue(NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((RedstoneSide)state.getValue(WEST)))).setValue(EAST, (Comparable)((RedstoneSide)state.getValue(NORTH)))).setValue(SOUTH, (Comparable)((RedstoneSide)state.getValue(EAST)))).setValue(WEST, (Comparable)((RedstoneSide)state.getValue(SOUTH)));
            default -> state;
        };
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.setValue(NORTH, (Comparable)((RedstoneSide)state.getValue(SOUTH)))).setValue(SOUTH, (Comparable)((RedstoneSide)state.getValue(NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.setValue(EAST, (Comparable)((RedstoneSide)state.getValue(WEST)))).setValue(WEST, (Comparable)((RedstoneSide)state.getValue(EAST)));
            default -> super.mirror(state, mirror);
        };
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        if (!oldState.is(state.getBlock()) && !world.isClientSide) {
            world.scheduleTick(pos, (Block)this, GunpowderBlock.getDelay());
            for (Direction direction : Direction.Plane.VERTICAL) {
                world.updateNeighborsAt(pos.relative(direction), (Block)this);
            }
            this.updateNeighborsOfNeighboringWires(world, pos);
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.is(newState.getBlock())) {
            super.onRemove(state, world, pos, newState, isMoving);
            if (!world.isClientSide) {
                for (Direction direction : Direction.values()) {
                    world.updateNeighborsAt(pos.relative(direction), (Block)this);
                }
                this.updateNeighborsOfNeighboringWires(world, pos);
            }
        }
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean moving) {
        super.neighborChanged(state, world, pos, neighborBlock, neighborPos, moving);
        if (!world.isClientSide) {
            world.scheduleTick(pos, (Block)this, GunpowderBlock.getDelay());
        }
    }

    private void updateNeighborsOfNeighboringWires(Level world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.checkCornerChangeAt(world, pos.relative(direction));
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.relative(direction1);
            if (world.getBlockState(blockpos).isRedstoneConductor((BlockGetter)world, blockpos)) {
                this.checkCornerChangeAt(world, blockpos.above());
                continue;
            }
            this.checkCornerChangeAt(world, blockpos.below());
        }
    }

    private void checkCornerChangeAt(Level world, BlockPos pos) {
        if (world.getBlockState(pos).is((Block)this)) {
            world.updateNeighborsAt(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                world.updateNeighborsAt(pos.relative(direction), (Block)this);
            }
        }
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemInteractionResult lightUp = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        if (lightUp.consumesAction()) {
            return lightUp;
        }
        if (Utils.mayPerformBlockAction((Player)player, (BlockPos)pos, (ItemStack)player.getItemInHand(hand)) && (GunpowderBlock.isCross(state) || GunpowderBlock.isDot(state))) {
            BlockState blockstate = GunpowderBlock.isCross(state) ? this.defaultBlockState() : this.crossState;
            blockstate = (BlockState)blockstate.setValue((Property)BURNING, (Comparable)((Integer)state.getValue((Property)BURNING)));
            if ((blockstate = this.getConnectionState((BlockGetter)level, blockstate, pos)) != state) {
                level.setBlock(pos, blockstate, 3);
                this.updatesOnShapeChange(level, pos, state, blockstate);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private void updatesOnShapeChange(Level world, BlockPos pos, BlockState state, BlockState newState) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.relative(direction);
            if (((RedstoneSide)state.getValue((Property)PROPERTY_BY_DIRECTION.get(direction))).isConnected() == ((RedstoneSide)newState.getValue((Property)PROPERTY_BY_DIRECTION.get(direction))).isConnected() || !world.getBlockState(blockpos).isRedstoneConductor((BlockGetter)world, blockpos)) continue;
            world.updateNeighborsAtExceptFromFacing(blockpos, newState.getBlock(), direction.getOpposite());
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int burning = (Integer)state.getValue((Property)BURNING);
        if (!world.isClientSide) {
            if (burning == 8) {
                world.removeBlock(pos, false);
                GunpowderExplosion.explode(world, pos);
            } else if (burning > 0) {
                if (burning >= GunpowderBlock.getSpreadAge()) {
                    this.lightUpNeighbouringWires(pos, state, (Level)world);
                }
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BURNING, (Comparable)Integer.valueOf(burning + 1)));
                world.scheduleTick(pos, (Block)this, GunpowderBlock.getDelay());
            } else {
                for (Direction dir : Direction.values()) {
                    BlockPos p = pos.relative(dir);
                    if (!GunpowderBlock.canBlockLightMeOnFire((LevelAccessor)world, p)) continue;
                    this.tryLightUp(null, state, pos, (LevelAccessor)world, ILightable.FireSoundType.FLAMING_ARROW);
                    world.scheduleTick(pos, (Block)this, GunpowderBlock.getDelay());
                    break;
                }
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static void createMiniExplosion(Level world, BlockPos pos, boolean alwaysFire) {
        if (world instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)world;
            GunpowderExplosion.explode(sl, pos);
        }
    }

    public boolean tryLightUp(Entity entity, BlockState state, BlockPos pos, LevelAccessor world, ILightable.FireSoundType fireSourceType) {
        boolean ret = super.tryLightUp(entity, state, pos, world, fireSourceType);
        if (ret) {
            if (!world.isClientSide()) {
                ((Level)world).blockEvent(pos, (Block)this, 0, 0);
            }
            world.scheduleTick(pos, (Block)this, GunpowderBlock.getDelay());
        }
        return ret;
    }

    private void lightUpByWire(BlockState state, BlockPos pos, LevelAccessor level) {
        if (!this.isLitUp(state, (BlockGetter)level, pos)) {
            if (!level.isClientSide()) {
                ((Level)level).blockEvent(pos, (Block)this, 0, 0);
            }
            this.setLitUp(state, level, pos, true);
            level.playSound(null, pos, ModSounds.GUNPOWDER_IGNITE.get(), SoundSource.BLOCKS, 2.0f, 1.9f + level.getRandom().nextFloat() * 0.1f);
        }
    }

    protected void lightUpNeighbouringWires(BlockPos pos, BlockState state, Level world) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockState neighbourState;
            BlockPos p;
            RedstoneSide side = (RedstoneSide)state.getValue((Property)PROPERTY_BY_DIRECTION.get(dir));
            if (side == RedstoneSide.UP) {
                p = pos.relative(dir).above();
                neighbourState = world.getBlockState(p);
            } else {
                if (side != RedstoneSide.SIDE) continue;
                p = pos.relative(dir);
                neighbourState = world.getBlockState(p);
                if (!neighbourState.is((Block)this) && !neighbourState.isRedstoneConductor((BlockGetter)world, pos)) {
                    p = p.below();
                    neighbourState = world.getBlockState(p);
                }
            }
            if (!neighbourState.is((Block)this)) continue;
            world.scheduleTick(p, (Block)this, Math.max(GunpowderBlock.getDelay() - 1, 1));
            this.lightUpByWire(neighbourState, p, (LevelAccessor)world);
        }
    }

    public static boolean canBlockLightMeOnFire(BlockState state, BlockGetter level, BlockPos pos) {
        Block b = state.getBlock();
        if (state.is(ModTags.LIGHTS_GUNPOWDER)) {
            Block block = state.getBlock();
            if (block instanceof ILightable) {
                ILightable l = (ILightable)block;
                return l.isLitUp(state, level, pos);
            }
            if (state.hasProperty((Property)BlockStateProperties.LIT)) {
                return (Boolean)state.getValue((Property)BlockStateProperties.LIT);
            }
            return true;
        }
        return b instanceof TorchBlock && !(b instanceof RedstoneTorchBlock);
    }

    public static boolean canBlockLightMeOnFire(LevelAccessor world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return GunpowderBlock.canBlockLightMeOnFire(state, (BlockGetter)world, pos);
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float height) {
        super.fallOn(world, state, pos, entity, height);
        if (height > 1.0f) {
            this.tryExtinguish(entity, world.getBlockState(pos), pos, (LevelAccessor)world);
        }
    }

    public void onCaughtFire(BlockState state, Level world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
    }

    @Override
    public boolean isLitUp(BlockState state, BlockGetter level, BlockPos pos) {
        return (Integer)state.getValue((Property)BURNING) != 0;
    }

    public void setLitUp(BlockState state, LevelAccessor world, BlockPos pos, boolean lit) {
        world.setBlock(pos, (BlockState)state.setValue((Property)BURNING, (Comparable)Integer.valueOf(lit ? 1 : 0)), 3);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        if (eventID == 0) {
            this.animateTick((BlockState)state.setValue((Property)BURNING, (Comparable)Integer.valueOf(1)), world, pos, world.random);
            return true;
        }
        return super.triggerEvent(state, world, pos, eventID, eventParam);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        int i = (Integer)state.getValue((Property)BURNING);
        if (i != 0) {
            block4: for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide redstoneside = (RedstoneSide)state.getValue((Property)PROPERTY_BY_DIRECTION.get(direction));
                switch (redstoneside) {
                    case UP: {
                        this.spawnParticlesAlongLine(world, random, pos, i, direction, Direction.UP, -0.5f, 0.5f);
                    }
                    case SIDE: {
                        this.spawnParticlesAlongLine(world, random, pos, i, Direction.DOWN, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                this.spawnParticlesAlongLine(world, random, pos, i, Direction.DOWN, direction, 0.0f, 0.3f);
            }
        }
    }

    private void spawnParticlesAlongLine(Level world, RandomSource rand, BlockPos pos, int burning, Direction dir1, Direction dir2, float from, float to) {
        float f = to - from;
        float in = (7.5f - (float)(burning - 1)) / 7.5f;
        if (rand.nextFloat() < 1.0f * f * in) {
            float f2 = from + f * rand.nextFloat();
            double x = (double)pos.getX() + 0.5 + (double)(0.4375f * (float)dir1.getStepX()) + (double)(f2 * (float)dir2.getStepX());
            double y = (double)pos.getY() + 0.5 + (double)(0.4375f * (float)dir1.getStepY()) + (double)(f2 * (float)dir2.getStepY());
            double z = (double)pos.getZ() + 0.5 + (double)(0.4375f * (float)dir1.getStepZ()) + (double)(f2 * (float)dir2.getStepZ());
            float velY = (float)burning / 15.0f * 0.03f;
            float velX = rand.nextFloat() * 0.02f - 0.01f;
            float velZ = rand.nextFloat() * 0.02f - 0.01f;
            world.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, (double)velX, (double)velY, (double)velZ);
            world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, x, y, z, (double)velX, (double)velY, (double)velZ);
        }
    }

    public static enum Type implements StringRepresentable
    {
        DEFAULT,
        TRIGGERED,
        HIDDEN;


        public boolean canRender() {
            return this != HIDDEN;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean isHidden() {
            return this != DEFAULT;
        }

        public boolean canBeTriggered() {
            return this == HIDDEN;
        }

        public boolean isDefault() {
            return this == DEFAULT;
        }
    }
}

