/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CannonBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.TrappedPresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.TrappedPresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.misc.IMovingBlockSource;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PearlMarker
extends Entity {
    private Pair<ThrownEnderpearl, HitResult> event = null;
    private final List<ThrownEnderpearl> pearls = new ArrayList<ThrownEnderpearl>();
    private static final EntityDataAccessor<BlockPos> TELEPORT_POS = SynchedEntityData.defineId(PearlMarker.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);

    public PearlMarker(Level worldIn) {
        super(ModEntities.PEARL_MARKER.get(), worldIn);
        this.setNoGravity(true);
        this.setInvulnerable(true);
    }

    public PearlMarker(EntityType<PearlMarker> type, Level level) {
        super(type, level);
        this.setInvisible(true);
        this.setNoGravity(true);
        this.setInvulnerable(true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TELEPORT_POS, (Object)this.blockPosition());
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        return false;
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
    }

    public void kill() {
        this.discard();
    }

    public void tick() {
        BlockPos pos;
        BlockState state;
        super.baseTick();
        this.pearls.removeIf(Entity::isRemoved);
        boolean dead = this.pearls.isEmpty();
        Level level = this.level();
        if (!dead && !PearlMarker.isValidBlock(state = level.getBlockState(pos = this.blockPosition()))) {
            PistonMovingBlockEntity p;
            PistonMovingBlockEntity piston = null;
            boolean didOffset = false;
            BlockEntity tile = level.getBlockEntity(pos);
            if (tile instanceof PistonMovingBlockEntity && PearlMarker.isValidBlock((p = (PistonMovingBlockEntity)tile).getMovedState())) {
                piston = p;
            } else {
                for (Direction d : Direction.values()) {
                    PistonMovingBlockEntity p2;
                    BlockPos offPos = pos.relative(d);
                    tile = level.getBlockEntity(offPos);
                    if (!(tile instanceof PistonMovingBlockEntity) || !PearlMarker.isValidBlock((p2 = (PistonMovingBlockEntity)tile).getMovedState())) continue;
                    piston = p2;
                    break;
                }
            }
            if (piston != null) {
                Direction dir = piston.getMovementDirection();
                this.move(MoverType.PISTON, new Vec3((double)dir.getStepX() * 0.33, (double)dir.getStepY() * 0.33, (double)dir.getStepZ() * 0.33));
                didOffset = true;
            }
            boolean bl = dead = !didOffset;
        }
        if (dead && !level.isClientSide) {
            this.discard();
        }
    }

    @NotNull
    private static boolean isValidBlock(BlockState p) {
        Block b = p.getBlock();
        return b instanceof DispenserBlock || b instanceof CannonBlock || b instanceof TrappedPresentBlock;
    }

    private void removePearl(ThrownEnderpearl pearl) {
        this.pearls.remove(pearl);
    }

    public void addPearl(ThrownEnderpearl pearl) {
        this.pearls.add(pearl);
    }

    public void teleportTo(double pX, double pY, double pZ) {
        if (this.event != null) {
            HitResult trace = (HitResult)this.event.getSecond();
            ThrownEnderpearl pearl = (ThrownEnderpearl)this.event.getFirst();
            if (trace instanceof BlockHitResult) {
                BlockHitResult hitResult = (BlockHitResult)trace;
                Level level = this.level();
                BlockPos fromPos = this.blockPosition();
                BlockState state = level.getBlockState(fromPos);
                BlockEntity blockEntity = level.getBlockEntity(fromPos);
                if (PearlMarker.isValidBlockEntity(blockEntity)) {
                    Direction direction = hitResult.getDirection();
                    BlockPos toPos = hitResult.getBlockPos().relative(direction);
                    if (level.getBlockState(toPos).canBeReplaced()) {
                        CompoundTag nbt = blockEntity.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
                        blockEntity.setRemoved();
                        BlockState newState = PearlMarker.getLandingState(state, toPos, direction, level);
                        if (level.setBlockAndUpdate(fromPos, Blocks.AIR.defaultBlockState()) && level.setBlockAndUpdate(toPos, newState)) {
                            newState.handleNeighborChanged(level, toPos, level.getBlockState(toPos.below()).getBlock(), toPos.below(), true);
                            BlockEntity dstEntity = level.getBlockEntity(toPos);
                            if (PearlMarker.isValidBlockEntity(dstEntity)) {
                                dstEntity.loadWithComponents(nbt, (HolderLookup.Provider)level.registryAccess());
                            }
                            SoundType type = state.getSoundType();
                            level.playSound(null, toPos, type.getPlaceSound(), SoundSource.BLOCKS, (type.getVolume() + 1.0f) / 2.0f, type.getPitch() * 0.8f);
                        }
                    }
                    NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new ClientBoundParticlePacket(fromPos.getCenter(), ClientBoundParticlePacket.Kind.PEARL_TELEPORT, 0, toPos.getCenter()));
                    super.teleportTo((double)toPos.getX() + 0.5, (double)toPos.getY() + 0.5 - (double)(this.getBbHeight() / 2.0f), (double)toPos.getZ() + 0.5);
                }
            }
            this.removePearl(pearl);
            pearl.discard();
            this.event = null;
        } else {
            super.teleportTo(pX, pY, pZ);
            Supplementaries.error();
        }
    }

    @NotNull
    private static BlockState getLandingState(BlockState state, BlockPos pos, Direction direction, Level level) {
        if (state.hasProperty((Property)DispenserBlock.FACING)) {
            state = (BlockState)state.setValue((Property)DispenserBlock.FACING, (Comparable)direction);
        }
        return Block.updateFromNeighbourShapes((BlockState)state, (LevelAccessor)level, (BlockPos)pos);
    }

    private static boolean isValidBlockEntity(BlockEntity blockEntity) {
        return blockEntity instanceof CannonBlockTile || blockEntity instanceof DispenserBlockEntity || blockEntity instanceof TrappedPresentBlockTile;
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        super.lerpTo(x, y, z, yRot, xRot, steps);
        this.setPos(x, y, z);
    }

    public static void onProjectileImpact(Projectile projectile, HitResult hitResult) {
        Level level = projectile.level();
        if (!level.isClientSide && projectile instanceof ThrownEnderpearl) {
            ThrownEnderpearl pearl = (ThrownEnderpearl)projectile;
            Entity entity = projectile.getOwner();
            if (entity instanceof PearlMarker) {
                PearlMarker markerEntity = (PearlMarker)entity;
                if (projectile.removeTag("dispensed")) {
                    markerEntity.event = Pair.of((Object)pearl, (Object)hitResult);
                }
            }
        }
    }

    public static ThrownEnderpearl createPearlToDispenseAndPlaceMarker(BlockSource source, Position pearlPos) {
        ServerLevel level = source.level();
        BlockPos pos = source.pos();
        Entity dispCart = ((IMovingBlockSource)source).supp$getEntity();
        return PearlMarker.createPearlToDispenseAndPlaceMarker(level, pos, dispCart, pearlPos);
    }

    public static ThrownEnderpearl createPearlToDispenseAndPlaceMarker(ServerLevel level, BlockPos pos, @Nullable Entity owner, Position pearlPos) {
        ThrownEnderpearl pearl = new ThrownEnderpearl(EntityType.ENDER_PEARL, (Level)level);
        pearl.setPos(pearlPos.x(), pearlPos.y(), pearlPos.z());
        if (owner != null) {
            pearl.setOwner(owner);
        } else {
            PearlMarker marker;
            Optional entity = level.getEntitiesOfClass(PearlMarker.class, new AABB(pos), e -> e.blockPosition().equals((Object)pos)).stream().findAny();
            if (entity.isEmpty()) {
                marker = new PearlMarker((Level)level);
                marker.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5 - (double)(marker.getBbHeight() / 2.0f), (double)pos.getZ() + 0.5);
                level.addFreshEntity((Entity)marker);
            } else {
                marker = (PearlMarker)((Object)entity.get());
            }
            marker.addPearl(pearl);
            pearl.setOwner((Entity)marker);
        }
        pearl.addTag("dispensed");
        return pearl;
    }
}

