/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.trades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.supplementaries.common.entities.trades.AdventurerMapsHandler;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;

public record StructureMapListing(Item cost, int minPrice, int maxPrice, Optional<ItemCost> cost2, HolderSet<Structure> structure, int maxTrades, float priceMult, int level, String mapName, int mapColor, ResourceLocation mapMarker) implements ModItemListing
{
    private static final Codec<HolderSet<Structure>> TARGET_CODEC = Codec.either((Codec)RegistryCodecs.homogeneousList((ResourceKey)Registries.STRUCTURE, (boolean)true), (Codec)Structure.CODEC).xmap(either -> (HolderSet)either.map(Function.identity(), xva$0 -> HolderSet.direct((Holder[])new Holder[]{xva$0})), Either::left);
    public static final MapCodec<StructureMapListing> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(StructureMapListing::cost), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("price_min", (Object)7).forGetter(StructureMapListing::minPrice), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("price_max", (Object)13).forGetter(StructureMapListing::maxPrice), (App)ItemCost.CODEC.optionalFieldOf("price_secondary").forGetter(StructureMapListing::cost2), (App)TARGET_CODEC.fieldOf("structure").forGetter(p -> p.structure), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("max_trades", (Object)16).forGetter(StructureMapListing::maxTrades), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("price_multiplier", (Object)Float.valueOf(0.05f)).forGetter(StructureMapListing::priceMult), (App)Codec.intRange((int)1, (int)5).optionalFieldOf("level", (Object)1).forGetter(StructureMapListing::level), (App)Codec.STRING.optionalFieldOf("map_name", (Object)"").forGetter(p -> p.mapName), (App)ColorUtils.CODEC.optionalFieldOf("map_color", (Object)0xFFFFFF).forGetter(p -> p.mapColor), (App)ResourceLocation.CODEC.optionalFieldOf("map_marker", (Object)ResourceLocation.parse((String)"")).forGetter(p -> p.mapMarker)).apply((Applicative)i, StructureMapListing::new));

    public MerchantOffer getOffer(@NotNull Entity entity, @NotNull RandomSource random) {
        ItemStack itemstack = AdventurerMapsHandler.createCustomMapForTrade(entity.level(), entity.blockPosition(), this.structure, this.mapName.isEmpty() ? null : this.mapName, this.mapColor, this.mapMarker.getPath().isEmpty() ? null : this.mapMarker);
        if (itemstack.isEmpty()) {
            return null;
        }
        int i = Math.max(1, random.nextInt(Math.max(1, this.maxPrice - this.minPrice)) + this.minPrice);
        return new MerchantOffer(new ItemCost((ItemLike)this.cost, i), this.cost2, itemstack, this.maxTrades, ModItemListing.defaultXp((boolean)false, (int)this.level), this.priceMult);
    }

    public MapCodec<? extends ModItemListing> getCodec() {
        return CODEC;
    }

    public int getLevel() {
        return this.level;
    }
}

