/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedFallingBlockEntity;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.entities.CannonBallEntity;
import net.mehvahdjukaar.supplementaries.common.entities.CannonBoatEntity;
import net.mehvahdjukaar.supplementaries.common.entities.FallingAshEntity;
import net.mehvahdjukaar.supplementaries.common.entities.FallingUrnEntity;
import net.mehvahdjukaar.supplementaries.common.entities.HatStandEntity;
import net.mehvahdjukaar.supplementaries.common.entities.PearlMarker;
import net.mehvahdjukaar.supplementaries.common.entities.RedMerchantEntity;
import net.mehvahdjukaar.supplementaries.common.entities.RopeArrowEntity;
import net.mehvahdjukaar.supplementaries.common.entities.SlimeBallEntity;
import net.mehvahdjukaar.supplementaries.common.entities.SlingshotProjectileEntity;
import net.mehvahdjukaar.supplementaries.common.entities.ThrowableBrickEntity;
import net.mehvahdjukaar.supplementaries.common.entities.dispenser_minecart.DispenserMinecartEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;

public class ModEntities {
    public static final Supplier<EntityType<PearlMarker>> PEARL_MARKER = ModEntities.regEntity("pearl_marker", PearlMarker::new, MobCategory.MISC, 0.999f, 0.999f, 4, false, -1);
    public static final Supplier<EntityType<DispenserMinecartEntity>> DISPENSER_MINECART = ModEntities.regEntity("dispenser_minecart", () -> EntityType.Builder.of(DispenserMinecartEntity::new, (MobCategory)MobCategory.MISC).sized(0.98f, 0.7f).clientTrackingRange(8));
    public static final Supplier<EntityType<HatStandEntity>> HAT_STAND = ModEntities.regEntity("hat_stand", HatStandEntity::new, MobCategory.MISC, 0.625f, 0.75f, 10, false, 3);
    public static final Supplier<EntityType<RedMerchantEntity>> RED_MERCHANT = ModEntities.regEntity("red_merchant", RedMerchantEntity::new, MobCategory.CREATURE, 0.6f, 1.95f, 10, true, 3);
    public static final Supplier<EntityType<FallingUrnEntity>> FALLING_URN = ModEntities.regEntity("falling_urn", () -> EntityType.Builder.of(FallingUrnEntity::new, (MobCategory)MobCategory.MISC).sized(0.98f, 0.98f).clientTrackingRange(10).updateInterval(20));
    public static final Supplier<EntityType<FallingAshEntity>> FALLING_ASH = ModEntities.regEntity("falling_ash", () -> EntityType.Builder.of(FallingAshEntity::new, (MobCategory)MobCategory.MISC).sized(0.98f, 0.98f).clientTrackingRange(10).updateInterval(20));
    public static final Supplier<EntityType<ImprovedFallingBlockEntity>> FALLING_SACK = ModEntities.regEntity("falling_sack", () -> EntityType.Builder.of(ImprovedFallingBlockEntity::new, (MobCategory)MobCategory.MISC).sized(0.98f, 0.98f).clientTrackingRange(10).updateInterval(20));
    public static final Supplier<EntityType<ThrowableBrickEntity>> THROWABLE_BRICK = ModEntities.regEntity("brick_projectile", () -> EntityType.Builder.of(ThrowableBrickEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(6).updateInterval(5));
    public static final Supplier<EntityType<SlimeBallEntity>> THROWABLE_SLIMEBALL = ModEntities.regEntity("slimeball_projectile", () -> EntityType.Builder.of(SlimeBallEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(6).updateInterval(5));
    public static final Supplier<EntityType<BombEntity>> BOMB = ModEntities.regEntity("bomb", () -> EntityType.Builder.of(BombEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(8).updateInterval(5));
    public static final Supplier<EntityType<CannonBallEntity>> CANNONBALL = ModEntities.regEntity("cannonball", () -> EntityType.Builder.of(CannonBallEntity::new, (MobCategory)MobCategory.MISC).sized(0.75f, 0.75f).clientTrackingRange(10).updateInterval(1000));
    public static final Supplier<EntityType<RopeArrowEntity>> ROPE_ARROW = ModEntities.regEntity("rope_arrow", () -> EntityType.Builder.of(RopeArrowEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(6).updateInterval(20));
    public static final Supplier<EntityType<SlingshotProjectileEntity>> SLINGSHOT_PROJECTILE = ModEntities.regEntity("slingshot_projectile", () -> EntityType.Builder.of(SlingshotProjectileEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(6).updateInterval(1));
    public static final Supplier<EntityType<CannonBoatEntity>> CANNON_BOAT = ModEntities.regEntity("cannon_boat", () -> EntityType.Builder.of(CannonBoatEntity::new, (MobCategory)MobCategory.MISC).sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));

    public static void init() {
        RegHelper.addAttributeRegistration(ModEntities::registerEntityAttributes);
    }

    public static void registerEntityAttributes(RegHelper.AttributeEvent event) {
        event.register(RED_MERCHANT.get(), Mob.createMobAttributes());
        event.register(HAT_STAND.get(), LivingEntity.createLivingAttributes());
    }

    public static <T extends Entity> Supplier<EntityType<T>> regEntity(String name, Supplier<EntityType.Builder<T>> builder) {
        return RegHelper.registerEntityType((ResourceLocation)Supplementaries.res(name), builder.get());
    }

    public static <T extends Entity> Supplier<EntityType<T>> regEntity(String name, EntityType.EntityFactory<T> factory, MobCategory category, float width, float height, int clientTrackingRange, boolean velocityUpdates, int updateInterval) {
        return RegHelper.registerEntityType((ResourceLocation)Supplementaries.res(name), () -> PlatHelper.newEntityType((String)name, (EntityType.EntityFactory)factory, (MobCategory)category, (float)width, (float)height, (int)clientTrackingRange, (boolean)velocityUpdates, (int)updateInterval));
    }
}

