/*
 * Decompiled with CFR 0.152.
 */
package dev.kleinbox.cccbridge.client.animatronic;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.kleinbox.cccbridge.client.blockEntityRenderer.AnimatronicBlockEntityRenderer;
import dev.kleinbox.cccbridge.common.assistance.animatronic.Face;
import dev.kleinbox.cccbridge.common.minecraft.blockEntity.AnimatronicBlockEntity;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnimatronicModel<T extends AnimatronicBlockEntity>
extends Model {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"cccbridge", (String)"animatronic"), "main");
    private static final float awesomeFactor = (float)Math.PI / 180;
    private final ModelPart root;
    private final ModelPart hat;
    private final ModelPart support;

    public AnimatronicModel(ModelPart root) {
        super(RenderType::entityTranslucent);
        this.root = root.getChild("root");
        this.support = root.getChild("support");
        this.hat = this.root.getChild("head").getChild("hat");
        this.hat.visible = false;
    }

    public void hasJob(boolean value) {
        this.hat.visible = value;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create().texOffs(8, 32).addBox(-1.0f, -7.0f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 20).addBox(-3.0f, -5.0f, -3.0f, 6.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(26, 20).addBox(-6.0f, -3.5f, -1.5f, 12.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -9.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)-1.0f));
        PartDefinition hat = head.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(40, 0).addBox(-2.0f, -2.0f, -2.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(52, 7).addBox(-2.05f, -0.85f, -2.6f, 4.15f, 1.0f, 1.5f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-9.0f, (float)0.0f));
        PartDefinition nose_r1 = hat.addOrReplaceChild("nose_r1", CubeListBuilder.create().texOffs(40, 7).addBox(-1.975f, 0.0f, -4.4f, 3.95f, 0.5f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition face = head.addOrReplaceChild("face", CubeListBuilder.create().texOffs(40, 10).addBox(-5.0f, -9.0f, -5.025f, 10.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = root.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(0, 32).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)-3.0f, (float)-1.0f));
        PartDefinition leftarm = root.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(20, 20).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)-3.0f, (float)-1.0f));
        PartDefinition support = partdefinition.addOrReplaceChild("support", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)22.0f, (float)0.0f));
        PartDefinition upper_arm_r1 = support.addOrReplaceChild("upper_arm_r1", CubeListBuilder.create().texOffs(0, 47).addBox(7.5f, 2.775f, -6.725f, 1.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.0f, (float)-7.0f, (float)7.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition lower_arm_r1 = support.addOrReplaceChild("lower_arm_r1", CubeListBuilder.create().texOffs(0, 46).addBox(7.5f, -1.0f, -5.5f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.0f, (float)-0.25f, (float)7.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float partialTicks, float netHeadYaw, float headPitch) {
        if (((AnimatronicBlockEntity)entity).isMoving()) {
            ((AnimatronicBlockEntity)entity).updateCurrentPoses(partialTicks);
        }
        float facing = (((Direction)entity.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).toYRot() + ((AnimatronicBlockEntity)entity).getBodyPose().getY()) * ((float)Math.PI / 180);
        this.root.getChild((String)"head").xRot = ((AnimatronicBlockEntity)entity).getHeadPose().getX() * ((float)Math.PI / 180);
        this.root.getChild((String)"head").yRot = ((AnimatronicBlockEntity)entity).getHeadPose().getY() * ((float)Math.PI / 180);
        this.root.getChild((String)"head").zRot = ((AnimatronicBlockEntity)entity).getHeadPose().getZ() * ((float)Math.PI / 180);
        this.root.xRot = ((AnimatronicBlockEntity)entity).getBodyPose().getX() * ((float)Math.PI / 180);
        this.root.yRot = facing;
        this.root.zRot = ((AnimatronicBlockEntity)entity).getBodyPose().getZ() * ((float)Math.PI / 180);
        this.support.xRot = 0.0f;
        this.support.yRot = facing;
        this.support.zRot = 0.0f;
        this.root.getChild((String)"leftarm").xRot = ((AnimatronicBlockEntity)entity).getLeftArmPose().getX() * ((float)Math.PI / 180);
        this.root.getChild((String)"leftarm").yRot = ((AnimatronicBlockEntity)entity).getLeftArmPose().getY() * ((float)Math.PI / 180);
        this.root.getChild((String)"leftarm").zRot = ((AnimatronicBlockEntity)entity).getLeftArmPose().getZ() * ((float)Math.PI / 180);
        this.root.getChild((String)"rightarm").xRot = ((AnimatronicBlockEntity)entity).getRightArmPose().getX() * ((float)Math.PI / 180);
        this.root.getChild((String)"rightarm").yRot = ((AnimatronicBlockEntity)entity).getRightArmPose().getY() * ((float)Math.PI / 180);
        this.root.getChild((String)"rightarm").zRot = ((AnimatronicBlockEntity)entity).getRightArmPose().getZ() * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int i1, int i2) {
        this.root.render(poseStack, vertexConsumer, i, i1, i2);
        this.support.render(poseStack, vertexConsumer, i, i1, i2);
    }

    public static ResourceLocation getFace(AnimatronicBlockEntity be) {
        Face face = be.getFace();
        if (face == null) {
            return AnimatronicBlockEntityRenderer.TEXTURE_FACE_NORMAL;
        }
        return switch (face) {
            default -> throw new MatchException(null, null);
            case Face.NORMAL -> AnimatronicBlockEntityRenderer.TEXTURE_FACE_NORMAL;
            case Face.HAPPY -> AnimatronicBlockEntityRenderer.TEXTURE_FACE_HAPPY;
            case Face.QUESTION -> AnimatronicBlockEntityRenderer.TEXTURE_FACE_QUESTION;
            case Face.SAD -> AnimatronicBlockEntityRenderer.TEXTURE_FACE_SAD;
        };
    }
}

