/*
 * Decompiled with CFR 0.152.
 */
package dev.kleinbox.cccbridge.common.assistance.animatronic;

import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public enum Face {
    NORMAL("normal"),
    HAPPY("happy"),
    QUESTION("question"),
    SAD("sad");

    private final String id;

    private Face(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public static Face contains(String kind) {
        return Arrays.stream(Face.values()).filter(face -> face.getId().equalsIgnoreCase(kind)).findFirst().orElse(null);
    }

    public static String availableOptions() {
        String values = Arrays.stream(Face.values()).map(Face::getId).collect(Collectors.joining(", "));
        return "{ " + values + " }";
    }
}

