/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.fabric;

import com.seibel.distanthorizons.core.api.internal.ServerApi;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IPluginPacketSender;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.AbstractModInitializer;
import loaderCommon.fabric.com.seibel.distanthorizons.common.AbstractPluginPacketSender;
import loaderCommon.fabric.com.seibel.distanthorizons.common.CommonPacketPayload;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.misc.ServerPlayerWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2791;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_442;
import net.minecraft.class_638;
import net.minecraft.class_9139;
import org.apache.logging.log4j.Logger;

public class FabricServerProxy
implements AbstractModInitializer.IEventProxy {
    private static final ServerApi SERVER_API = ServerApi.INSTANCE;
    private static final AbstractPluginPacketSender PACKET_SENDER = (AbstractPluginPacketSender)SingletonInjector.INSTANCE.get(IPluginPacketSender.class);
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private final boolean isDedicatedServer;

    public FabricServerProxy(boolean isDedicatedServer) {
        this.isDedicatedServer = isDedicatedServer;
    }

    private boolean isValidTime() {
        if (this.isDedicatedServer) {
            return true;
        }
        return !(class_310.method_1551().field_1755 instanceof class_442);
    }

    private IClientLevelWrapper getClientLevelWrapper(class_638 level) {
        return ClientLevelWrapper.getWrapper(level);
    }

    private ServerLevelWrapper getServerLevelWrapper(class_3218 level) {
        return ServerLevelWrapper.getWrapper(level);
    }

    private ServerPlayerWrapper getServerPlayerWrapper(class_3222 player) {
        return ServerPlayerWrapper.getWrapper(player);
    }

    @Override
    public void registerEvents() {
        LOGGER.info("Registering Fabric Server Events");
        ServerTickEvents.END_SERVER_TICK.register(server -> SERVER_API.serverTickEvent());
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            if (this.isValidTime()) {
                ServerApi.INSTANCE.serverLoadEvent(this.isDedicatedServer);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            if (this.isValidTime()) {
                ServerApi.INSTANCE.serverUnloadEvent();
            }
        });
        ServerWorldEvents.LOAD.register((server, level) -> {
            if (this.isValidTime()) {
                ServerApi.INSTANCE.serverLevelLoadEvent(this.getServerLevelWrapper(level));
            }
        });
        ServerWorldEvents.UNLOAD.register((server, level) -> {
            if (this.isValidTime()) {
                ServerApi.INSTANCE.serverLevelUnloadEvent(this.getServerLevelWrapper(level));
            }
        });
        ServerChunkEvents.CHUNK_LOAD.register((server, chunk) -> {
            ServerLevelWrapper level = this.getServerLevelWrapper((class_3218)chunk.method_12200());
            if (this.isValidTime()) {
                ServerApi.INSTANCE.serverChunkLoadEvent(new ChunkWrapper((class_2791)chunk, level), level);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (this.isValidTime()) {
                ServerApi.INSTANCE.serverPlayerJoinEvent(this.getServerPlayerWrapper(handler.field_14140));
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            if (this.isValidTime()) {
                ServerApi.INSTANCE.serverPlayerDisconnectEvent(this.getServerPlayerWrapper(handler.field_14140));
            }
        });
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, originLevel, destinationLevel) -> {
            if (this.isValidTime()) {
                ServerApi.INSTANCE.serverPlayerLevelChangeEvent(this.getServerPlayerWrapper(player), this.getServerLevelWrapper(originLevel), this.getServerLevelWrapper(destinationLevel));
            }
        });
        PayloadTypeRegistry.playC2S().register(CommonPacketPayload.TYPE, (class_9139)new CommonPacketPayload.Codec());
        if (this.isDedicatedServer) {
            PayloadTypeRegistry.playS2C().register(CommonPacketPayload.TYPE, (class_9139)new CommonPacketPayload.Codec());
        }
        ServerPlayNetworking.registerGlobalReceiver(CommonPacketPayload.TYPE, (payload, context) -> {
            if (payload.message() == null) {
                return;
            }
            ServerApi.INSTANCE.pluginMessageReceived(ServerPlayerWrapper.getWrapper(context.player()), payload.message());
        });
    }
}

