/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.gui;

import com.seibel.distanthorizons.api.enums.config.DisallowSelectingViaConfigGui;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.ConfigHandler;
import com.seibel.distanthorizons.core.config.types.AbstractConfigBase;
import com.seibel.distanthorizons.core.config.types.ConfigCategory;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.config.types.ConfigUIButton;
import com.seibel.distanthorizons.core.config.types.ConfigUIComment;
import com.seibel.distanthorizons.core.config.types.ConfigUISpacer;
import com.seibel.distanthorizons.core.config.types.ConfigUiLinkedEntry;
import com.seibel.distanthorizons.core.config.types.enums.EConfigCommentTextPosition;
import com.seibel.distanthorizons.core.config.types.enums.EConfigValidity;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.jar.updater.SelfUpdater;
import com.seibel.distanthorizons.core.logging.SpamReducedLogger;
import com.seibel.distanthorizons.core.util.AnnotationUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.config.IConfigGui;
import com.seibel.distanthorizons.core.wrapperInterfaces.config.ILangWrapper;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.gui.DhScreen;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.gui.GuiHelper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.gui.TexturedButtonWidget;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.gui.config.ConfigGuiInfo;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.gui.updater.ChangelogScreen;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassicConfigGUI {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final SpamReducedLogger SPAM_LOGGER = new SpamReducedLogger(4);
    public static final ConfigCoreInterface CONFIG_CORE_INTERFACE = new ConfigCoreInterface();
    private static final Pattern INTEGER_ONLY_REGEX = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY_REGEX = Pattern.compile("-?([\\d]+\\.?[\\d]*|[\\d]*\\.?[\\d]+|\\.)");

    public static class_437 getScreen(class_437 parent, String category) {
        return new ConfigScreen(parent, category);
    }

    private static class ConfigScreen
    extends DhScreen {
        private static final ILangWrapper LANG_WRAPPER = SingletonInjector.INSTANCE.get(ILangWrapper.class);
        private static final String TRANSLATION_PREFIX = "distanthorizons.config.";
        private final class_437 parent;
        private final String category;
        private ConfigListWidget configListWidget;
        private boolean reload = false;
        private class_4185 doneButton;

        protected ConfigScreen(class_437 parent, String category) {
            super((class_2561)GuiHelper.Translatable((String)(LANG_WRAPPER.langExists("distanthorizons.config" + (String)(category.isEmpty() ? "." + category : "") + ".title") ? "distanthorizons.config.title" : "distanthorizons.config" + (String)(category.isEmpty() ? "" : "." + category) + ".title"), new Object[0]));
            this.parent = parent;
            this.category = category;
        }

        public void method_25393() {
            super.method_25393();
        }

        protected void method_25426() {
            super.method_25426();
            if (!this.reload) {
                ConfigHandler.INSTANCE.configFileHandler.loadFromFile();
            }
            if (Config.Client.Advanced.AutoUpdater.enableAutoUpdater.get().booleanValue() && !ModInfo.IS_DEV_BUILD) {
                this.addBtn(new TexturedButtonWidget(this.field_22789 - 28, this.field_22790 - 28, 20, 20, 0, 0, 0, class_2960.method_60655((String)"distanthorizons", (String)"textures/gui/changelog.png"), 20, 20, buttonWidget -> {
                    ChangelogScreen changelogScreen = new ChangelogScreen(this);
                    if (changelogScreen.usable) {
                        Objects.requireNonNull(this.field_22787).method_1507((class_437)changelogScreen);
                    } else {
                        LOGGER.warn("Changelog was not able to open");
                    }
                }, (class_2561)GuiHelper.Translatable("distanthorizons.updater.title", new Object[0])));
            }
            this.addBtn(GuiHelper.MakeBtn((class_2561)GuiHelper.Translatable("distanthorizons.general.back", new Object[0]), this.field_22789 / 2 - 154, this.field_22790 - 28, 150, 20, button -> {
                ConfigHandler.INSTANCE.configFileHandler.loadFromFile();
                Objects.requireNonNull(this.field_22787).method_1507(this.parent);
            }));
            this.doneButton = this.addBtn(GuiHelper.MakeBtn((class_2561)GuiHelper.Translatable("distanthorizons.general.done", new Object[0]), this.field_22789 / 2 + 4, this.field_22790 - 28, 150, 20, button -> {
                ConfigHandler.INSTANCE.configFileHandler.saveToFile();
                Objects.requireNonNull(this.field_22787).method_1507(this.parent);
            }));
            this.configListWidget = new ConfigListWidget(this.field_22787, this.field_22789 * 2, this.field_22790, 32, 32, 25);
            this.method_25429((class_364)this.configListWidget);
            for (AbstractConfigBase<?> configEntry : ConfigHandler.INSTANCE.configBaseList) {
                try {
                    if (!configEntry.getCategory().matches(this.category) || !configEntry.getAppearance().showInGui) continue;
                    this.addMenuItem(configEntry);
                }
                catch (Exception e) {
                    String message = "ERROR: Failed to show [" + configEntry.getNameAndCategory() + "], error: [" + e.getMessage() + "]";
                    if (configEntry.get() != null) {
                        message = message + " with the value [" + String.valueOf(configEntry.get()) + "] with type [" + String.valueOf(configEntry.getType()) + "]";
                    }
                    LOGGER.error(message, (Throwable)e);
                }
            }
            ClassicConfigGUI.CONFIG_CORE_INTERFACE.onScreenChangeListenerList.forEach(listener -> listener.run());
        }

        private void addMenuItem(AbstractConfigBase<?> configEntry) {
            ConfigScreen.trySetupConfigEntry(configEntry);
            if (this.tryCreateInputField(configEntry)) {
                return;
            }
            if (this.tryCreateCategoryButton(configEntry)) {
                return;
            }
            if (this.tryCreateButton(configEntry)) {
                return;
            }
            if (this.tryCreateComment(configEntry)) {
                return;
            }
            if (this.tryCreateSpacer(configEntry)) {
                return;
            }
            if (this.tryCreateLinkedEntry(configEntry)) {
                return;
            }
            LOGGER.warn("Config [" + configEntry.getNameAndCategory() + "] failed to show. Please try something like changing its type.");
        }

        private static void trySetupConfigEntry(AbstractConfigBase<?> configMenuOption) {
            configMenuOption.guiValue = new ConfigGuiInfo();
            Class<?> configValueClass = configMenuOption.getType();
            if (configMenuOption instanceof ConfigEntry) {
                ConfigEntry configEntry = (ConfigEntry)configMenuOption;
                if (configValueClass == Integer.class) {
                    ConfigScreen.setupTextMenuOption(configEntry, Integer::parseInt, INTEGER_ONLY_REGEX, true);
                } else if (configValueClass == Double.class) {
                    ConfigScreen.setupTextMenuOption(configEntry, Double::parseDouble, DECIMAL_ONLY_REGEX, false);
                } else if (configValueClass == String.class || configValueClass == List.class) {
                    ConfigScreen.setupTextMenuOption(configEntry, String::length, null, true);
                } else if (configValueClass == Boolean.class) {
                    ConfigEntry booleanConfigEntry = configEntry;
                    ConfigScreen.setupBooleanMenuOption(booleanConfigEntry);
                } else if (configValueClass.isEnum()) {
                    ConfigEntry enumConfigEntry = configEntry;
                    Class<?> configEnumClass = configValueClass;
                    ConfigScreen.setupEnumMenuOption(enumConfigEntry, configEnumClass);
                }
            }
        }

        private static void setupTextMenuOption(AbstractConfigBase<?> configMenuOption, Function<String, Number> parsingFunc, @Nullable Pattern pattern, boolean cast) {
            ConfigGuiInfo configGuiInfo = (ConfigGuiInfo)configMenuOption.guiValue;
            configGuiInfo.tooltipFunction = (editBox, button) -> stringValue -> {
                boolean isNumber = pattern != null;
                if (!(stringValue = stringValue.trim()).isEmpty() && isNumber && !pattern.matcher((CharSequence)stringValue).matches()) {
                    return false;
                }
                Number numberValue = configMenuOption.typeIsFloatingPointNumber() ? 0.0 : 0.0;
                configGuiInfo.errorMessage = null;
                if (isNumber && !stringValue.isEmpty() && !stringValue.equals("-") && !stringValue.equals(".")) {
                    ConfigEntry numberConfigEntry = (ConfigEntry)configMenuOption;
                    try {
                        numberValue = (Number)parsingFunc.apply((String)stringValue);
                    }
                    catch (Exception e) {
                        numberValue = null;
                    }
                    EConfigValidity validity = numberConfigEntry.getValidity(numberValue);
                    switch (validity) {
                        case VALID: {
                            configGuiInfo.errorMessage = null;
                            break;
                        }
                        case NUMBER_TOO_LOW: {
                            configGuiInfo.errorMessage = GuiHelper.TextOrTranslatable("\u00a7cMinimum length is " + String.valueOf(numberConfigEntry.getMin()));
                            break;
                        }
                        case NUMBER_TOO_HIGH: {
                            configGuiInfo.errorMessage = GuiHelper.TextOrTranslatable("\u00a7cMaximum length is " + String.valueOf(numberConfigEntry.getMax()));
                            break;
                        }
                        case INVALID: {
                            configGuiInfo.errorMessage = GuiHelper.TextOrTranslatable("\u00a7cValue is invalid");
                        }
                    }
                }
                editBox.method_1868(((ConfigEntry)configMenuOption).getValidity(numberValue) == EConfigValidity.VALID ? -1 : -34953);
                if (configMenuOption.getType() == String.class || configMenuOption.getType() == List.class) {
                    ((ConfigEntry)configMenuOption).uiSetWithoutSaving(stringValue);
                } else if (((ConfigEntry)configMenuOption).getValidity(numberValue) == EConfigValidity.VALID) {
                    if (!cast) {
                        ((ConfigEntry)configMenuOption).uiSetWithoutSaving(numberValue);
                    } else {
                        ((ConfigEntry)configMenuOption).uiSetWithoutSaving(numberValue != null ? numberValue.intValue() : 0);
                    }
                }
                return true;
            };
        }

        private static void setupBooleanMenuOption(ConfigEntry<Boolean> booleanConfigEntry) {
            Function<Object, class_2561> func = value -> GuiHelper.Translatable("distanthorizons.general." + ((Boolean)value != false ? "true" : "false"), new Object[0]).method_27692((Boolean)value != false ? class_124.field_1060 : class_124.field_1061);
            ConfigGuiInfo configGuiInfo = (ConfigGuiInfo)booleanConfigEntry.guiValue;
            configGuiInfo.buttonOptionMap = new AbstractMap.SimpleEntry<class_4185.class_4241, Function<Object, class_2561>>(button -> {
                button.field_22763 = !booleanConfigEntry.apiIsOverriding();
                booleanConfigEntry.uiSetWithoutSaving((Boolean)booleanConfigEntry.get() == false);
                button.method_25355((class_2561)func.apply(booleanConfigEntry.get()));
            }, func);
        }

        private static void setupEnumMenuOption(ConfigEntry<Enum<?>> enumConfigEntry, Class<? extends Enum<?>> enumClass) {
            List<Enum<?>> enumList = Arrays.asList(enumClass.getEnumConstants());
            ConfigGuiInfo configGuiInfo = (ConfigGuiInfo)enumConfigEntry.guiValue;
            Function<Object, class_2561> getEnumTranslatableFunc = value -> GuiHelper.Translatable("distanthorizons.config.enum." + enumClass.getSimpleName() + "." + ((Enum)enumConfigEntry.get()).toString(), new Object[0]);
            configGuiInfo.buttonOptionMap = new AbstractMap.SimpleEntry<class_4185.class_4241, Function<Object, class_2561>>(button -> {
                int startingIndex = enumList.indexOf(enumConfigEntry.get());
                Enum enumValue = (Enum)enumList.get(startingIndex);
                int index = startingIndex + 1;
                int n = index = index >= enumList.size() ? 0 : index;
                while (index != startingIndex && AnnotationUtil.doesEnumHaveAnnotation(enumValue = (Enum)enumList.get(index), DisallowSelectingViaConfigGui.class)) {
                    index = ++index >= enumList.size() ? 0 : index;
                }
                if (index == startingIndex) {
                    enumValue = (Enum)enumList.get(startingIndex);
                    LOGGER.warn("Enum [" + String.valueOf(enumValue.getClass()) + "] doesn't contain any values that should be selectable via the UI, sticking to the currently selected value [" + String.valueOf(enumValue) + "].");
                }
                enumConfigEntry.uiSetWithoutSaving(enumValue);
                button.field_22763 = !enumConfigEntry.apiIsOverriding();
                button.method_25355((class_2561)getEnumTranslatableFunc.apply(enumConfigEntry.get()));
            }, getEnumTranslatableFunc);
        }

        private boolean tryCreateInputField(AbstractConfigBase<?> configBase) {
            ConfigGuiInfo configGuiInfo = (ConfigGuiInfo)configBase.guiValue;
            if (configBase instanceof ConfigEntry) {
                ConfigEntry configEntry = (ConfigEntry)configBase;
                class_4185.class_4241 btnAction = button -> {
                    configEntry.uiSetWithoutSaving(configEntry.getDefaultValue());
                    this.reload = true;
                    Objects.requireNonNull(this.field_22787).method_1507((class_437)this);
                };
                int resetButtonPosX = this.field_22789 - 60 - 10;
                int resetButtonPosZ = 0;
                class_4185 resetButton = GuiHelper.MakeBtn((class_2561)GuiHelper.Translatable("distanthorizons.general.reset", new Object[0]).method_27692(class_124.field_1061), resetButtonPosX, resetButtonPosZ, 60, 20, btnAction);
                if (configEntry.apiIsOverriding()) {
                    resetButton.field_22763 = false;
                    resetButton.method_25355((class_2561)GuiHelper.Translatable("distanthorizons.general.apiOverride", new Object[0]).method_27692(class_124.field_1063));
                } else {
                    resetButton.field_22763 = true;
                }
                class_2561 textComponent = this.GetTranslatableTextComponentForConfig(configEntry);
                int optionFieldPosX = this.field_22789 - 10 - 60 - 5 - 150;
                int optionFieldPosZ = 0;
                if (configGuiInfo.buttonOptionMap != null) {
                    AbstractMap.SimpleEntry<class_4185.class_4241, Function<Object, class_2561>> widget = configGuiInfo.buttonOptionMap;
                    if (configEntry.getType().isEnum()) {
                        widget.setValue(value -> GuiHelper.Translatable("distanthorizons.config.enum." + configEntry.getType().getSimpleName() + "." + configEntry.get().toString(), new Object[0]));
                    }
                    class_4185 button2 = GuiHelper.MakeBtn((class_2561)((Function)widget.getValue()).apply(configEntry.get()), optionFieldPosX, optionFieldPosZ, 150, 20, (class_4185.class_4241)widget.getKey());
                    button2.field_22763 = !configEntry.apiIsOverriding();
                    this.configListWidget.addButton(this, configEntry, (class_339)button2, (class_339)resetButton, null, textComponent);
                    return true;
                }
                class_342 widget = new class_342(this.field_22793, optionFieldPosX, optionFieldPosZ, 146, 20, (class_2561)GuiHelper.Translatable("", new Object[0]));
                widget.method_1880(150);
                widget.method_1867(String.valueOf(configEntry.get()));
                Predicate<String> processor = configGuiInfo.tooltipFunction.apply(widget, this.doneButton);
                widget.method_1890(processor);
                this.configListWidget.addButton(this, configEntry, (class_339)widget, (class_339)resetButton, null, textComponent);
                return true;
            }
            return false;
        }

        private boolean tryCreateCategoryButton(AbstractConfigBase<?> configType) {
            if (configType instanceof ConfigCategory) {
                ConfigCategory configCategory = (ConfigCategory)configType;
                class_2561 textComponent = this.GetTranslatableTextComponentForConfig(configCategory);
                int categoryPosX = this.field_22789 - 200 - 10;
                int categoryPosZ = this.field_22790 - 20;
                class_4185 widget = GuiHelper.MakeBtn(textComponent, categoryPosX, categoryPosZ, 200, 20, button -> {
                    ConfigHandler.INSTANCE.configFileHandler.saveToFile();
                    Objects.requireNonNull(this.field_22787).method_1507(ClassicConfigGUI.getScreen(this, configCategory.getDestination()));
                });
                this.configListWidget.addButton(this, configType, (class_339)widget, null, null, null);
                return true;
            }
            return false;
        }

        private boolean tryCreateButton(AbstractConfigBase<?> configType) {
            if (configType instanceof ConfigUIButton) {
                ConfigUIButton configUiButton = (ConfigUIButton)configType;
                class_2561 textComponent = this.GetTranslatableTextComponentForConfig(configUiButton);
                int buttonPosX = this.field_22789 - 200 - 10;
                class_4185 widget = GuiHelper.MakeBtn(textComponent, buttonPosX, this.field_22790 - 28, 200, 20, button -> ((ConfigUIButton)configType).runAction());
                this.configListWidget.addButton(this, configType, (class_339)widget, null, null, null);
                return true;
            }
            return false;
        }

        private boolean tryCreateComment(AbstractConfigBase<?> configType) {
            if (configType instanceof ConfigUIComment) {
                ConfigUIComment configUiComment = (ConfigUIComment)configType;
                class_2561 textComponent = this.GetTranslatableTextComponentForConfig(configUiComment);
                if (configUiComment.parentConfigPath != null) {
                    textComponent = GuiHelper.Translatable(TRANSLATION_PREFIX + configUiComment.parentConfigPath, new Object[0]);
                }
                this.configListWidget.addButton(this, configType, null, null, null, textComponent);
                return true;
            }
            return false;
        }

        private boolean tryCreateSpacer(AbstractConfigBase<?> configType) {
            if (configType instanceof ConfigUISpacer) {
                class_4185 spacerButton = GuiHelper.MakeBtn((class_2561)GuiHelper.Translatable("distanthorizons.general.spacer", new Object[0]), 10, 10, 1, 1, button -> {});
                spacerButton.field_22764 = false;
                this.configListWidget.addButton(this, configType, (class_339)spacerButton, null, null, null);
                return true;
            }
            return false;
        }

        private boolean tryCreateLinkedEntry(AbstractConfigBase<?> configType) {
            if (configType instanceof ConfigUiLinkedEntry) {
                this.addMenuItem((AbstractConfigBase)((ConfigUiLinkedEntry)configType).get());
                return true;
            }
            return false;
        }

        private class_2561 GetTranslatableTextComponentForConfig(AbstractConfigBase<?> configType) {
            return GuiHelper.Translatable(TRANSLATION_PREFIX + configType.getNameAndCategory(), new Object[0]);
        }

        public void method_25394(class_332 matrices, int mouseX, int mouseY, float delta) {
            super.method_25394(matrices, mouseX, mouseY, delta);
            this.configListWidget.method_25394(matrices, mouseX, mouseY, delta);
            this.DhDrawCenteredString(matrices, this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
            this.DhDrawString(matrices, this.field_22793, (class_2561)GuiHelper.TextOrLiteral("2.3.6-b"), 2, this.field_22790 - 10, 0xAAAAAA);
            if (SelfUpdater.deleteOldJarOnJvmShutdown) {
                this.DhDrawString(matrices, this.field_22793, (class_2561)GuiHelper.Translatable("distanthorizons.updater.waitingForClose", new Object[0]), 4, this.field_22790 - 42, 0xFFFFFF);
            }
            this.renderTooltip(matrices, mouseX, mouseY, delta);
        }

        private void renderTooltip(class_332 matrices, int mouseX, int mouseY, float delta) {
            class_339 hoveredWidget = this.configListWidget.getHoveredButton(mouseX, mouseY);
            if (hoveredWidget == null) {
                return;
            }
            ButtonEntry button = ButtonEntry.BUTTON_BY_WIDGET.get(hoveredWidget);
            AbstractConfigBase configBase = ConfigUiLinkedEntry.class.isAssignableFrom(button.dhConfigType.getClass()) ? (AbstractConfigBase)((ConfigUiLinkedEntry)button.dhConfigType).get() : button.dhConfigType;
            boolean apiOverrideActive = false;
            if (configBase instanceof ConfigEntry) {
                apiOverrideActive = ((ConfigEntry)configBase).apiIsOverriding();
            }
            Object key = TRANSLATION_PREFIX + (String)(configBase.category.isEmpty() ? "" : configBase.category + ".") + configBase.getName() + ".@tooltip";
            if (apiOverrideActive) {
                key = "distanthorizons.general.disabledByApi.@tooltip";
            }
            ConfigGuiInfo configGuiInfo = (ConfigGuiInfo)configBase.guiValue;
            if (configGuiInfo.errorMessage != null) {
                this.DhRenderTooltip(matrices, this.field_22793, configGuiInfo.errorMessage, mouseX, mouseY);
            } else if (LANG_WRAPPER.langExists((String)key)) {
                ArrayList<class_2561> list = new ArrayList<class_2561>();
                String lang = LANG_WRAPPER.getLang((String)key);
                for (String langLine : lang.split("\n")) {
                    list.add((class_2561)GuiHelper.TextOrTranslatable(langLine));
                }
                this.DhRenderComponentTooltip(matrices, this.field_22793, list, mouseX, mouseY);
            }
        }

        public void method_25419() {
            ConfigHandler.INSTANCE.configFileHandler.saveToFile();
            Objects.requireNonNull(this.field_22787).method_1507(this.parent);
            ClassicConfigGUI.CONFIG_CORE_INTERFACE.onScreenChangeListenerList.forEach(listener -> listener.run());
        }
    }

    public static class ConfigCoreInterface
    implements IConfigGui {
        public final ArrayList<Runnable> onScreenChangeListenerList = new ArrayList();

        @Override
        public void addOnScreenChangeListener(Runnable newListener) {
            this.onScreenChangeListenerList.add(newListener);
        }

        @Override
        public void removeOnScreenChangeListener(Runnable oldListener) {
            this.onScreenChangeListenerList.remove(oldListener);
        }
    }

    public static class ButtonEntry
    extends class_4265.class_4266<ButtonEntry> {
        private static final class_327 textRenderer = class_310.method_1551().field_1772;
        private final class_339 button;
        private final ConfigScreen gui;
        private final AbstractConfigBase dhConfigType;
        private final class_339 resetButton;
        private final class_339 indexButton;
        private final class_2561 text;
        private final List<class_339> children = new ArrayList<class_339>();
        @NotNull
        private final EConfigCommentTextPosition textPosition;
        public static final Map<class_339, class_2561> TEXT_BY_WIDGET = new HashMap<class_339, class_2561>();
        public static final Map<class_339, ButtonEntry> BUTTON_BY_WIDGET = new HashMap<class_339, ButtonEntry>();

        public ButtonEntry(ConfigScreen gui, AbstractConfigBase dhConfigType, class_339 button, class_2561 text, class_339 resetButton, class_339 indexButton) {
            TEXT_BY_WIDGET.put(button, text);
            BUTTON_BY_WIDGET.put(button, this);
            this.gui = gui;
            this.dhConfigType = dhConfigType;
            this.button = button;
            this.resetButton = resetButton;
            this.text = text;
            this.indexButton = indexButton;
            if (button != null) {
                this.children.add(button);
            }
            if (resetButton != null) {
                this.children.add(resetButton);
            }
            if (indexButton != null) {
                this.children.add(indexButton);
            }
            EConfigCommentTextPosition textPosition = null;
            if (this.dhConfigType instanceof ConfigUIComment) {
                textPosition = ((ConfigUIComment)this.dhConfigType).textPosition;
            }
            if (textPosition == null) {
                textPosition = this.button != null ? EConfigCommentTextPosition.RIGHT_JUSTIFIED : EConfigCommentTextPosition.CENTERED_OVER_BUTTONS;
            }
            this.textPosition = textPosition;
        }

        public void method_25343(class_332 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            try {
                if (this.button != null) {
                    GuiHelper.SetY(this.button, y);
                    this.button.method_25394(matrices, mouseX, mouseY, tickDelta);
                }
                if (this.resetButton != null) {
                    GuiHelper.SetY(this.resetButton, y);
                    this.resetButton.method_25394(matrices, mouseX, mouseY, tickDelta);
                }
                if (this.indexButton != null) {
                    GuiHelper.SetY(this.indexButton, y);
                    this.indexButton.method_25394(matrices, mouseX, mouseY, tickDelta);
                }
                if (this.text != null) {
                    int textXPos;
                    int translatedLength = textRenderer.method_27525((class_5348)this.text);
                    if (this.textPosition == EConfigCommentTextPosition.RIGHT_JUSTIFIED) {
                        textXPos = this.gui.field_22789 - translatedLength - 8 - 10 - 150 - 5 - 60;
                    } else if (this.textPosition == EConfigCommentTextPosition.CENTERED_OVER_BUTTONS) {
                        textXPos = this.gui.field_22789 - translatedLength / 2 - 100 - 10;
                    } else if (this.textPosition == EConfigCommentTextPosition.CENTER_OF_SCREEN) {
                        textXPos = this.gui.field_22789 / 2 - translatedLength / 2;
                    } else {
                        throw new UnsupportedOperationException("No text position render defined for [" + String.valueOf((Object)this.textPosition) + "]");
                    }
                    matrices.method_27535(textRenderer, this.text, textXPos, y + 5, 0xFFFFFF);
                }
            }
            catch (Exception e) {
                SPAM_LOGGER.error("Unexpected gui rendering issue: [" + e.getMessage() + "]", e);
            }
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return this.children;
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return this.children;
        }
    }

    public static class ConfigListWidget
    extends class_4265<ButtonEntry> {
        class_327 textRenderer;

        public ConfigListWidget(class_310 minecraftClient, int canvasWidth, int canvasHeight, int topMargin, int botMargin, int itemSpacing) {
            super(minecraftClient, canvasWidth, canvasHeight - (topMargin + botMargin), topMargin, itemSpacing);
            this.field_22744 = false;
            this.textRenderer = minecraftClient.field_1772;
        }

        public void addButton(ConfigScreen gui, AbstractConfigBase dhConfigType, class_339 button, class_339 resetButton, class_339 indexButton, class_2561 text) {
            this.method_25321((class_350.class_351)new ButtonEntry(gui, dhConfigType, button, text, resetButton, indexButton));
        }

        public int method_25322() {
            return 10000;
        }

        public class_339 getHoveredButton(double mouseX, double mouseY) {
            for (ButtonEntry buttonEntry : this.method_25396()) {
                class_339 button = buttonEntry.button;
                if (button == null || !button.field_22764) continue;
                double minX = button.method_46426();
                double minY = button.method_46427();
                double maxX = minX + (double)button.method_25368();
                double maxY = minY + (double)button.method_25364();
                if (!(mouseX >= minX) || !(mouseX < maxX) || !(mouseY >= minY) || !(mouseY < maxY)) continue;
                return button;
            }
            return null;
        }
    }

    private static class ConfigScreenConfigs {
        public static final int SPACE_FROM_RIGHT_SCREEN = 10;
        public static final int SPACE_BETWEEN_TEXT_AND_OPTION_FIELD = 8;
        public static final int BUTTON_WIDTH_SPACING = 5;
        public static final int RESET_BUTTON_WIDTH = 60;
        public static final int RESET_BUTTON_HEIGHT = 20;
        public static final int OPTION_FIELD_WIDTH = 150;
        public static final int OPTION_FIELD_HEIGHT = 20;
        public static final int CATEGORY_BUTTON_WIDTH = 200;
        public static final int CATEGORY_BUTTON_HEIGHT = 20;

        private ConfigScreenConfigs() {
        }
    }
}

