/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer.mainthread;

import dan200.computercraft.core.computer.mainthread.MainThreadConfig;
import dan200.computercraft.core.computer.mainthread.MainThreadExecutor;
import dan200.computercraft.core.computer.mainthread.MainThreadScheduler;
import dan200.computercraft.core.metrics.MetricsObserver;
import java.util.HashSet;
import java.util.TreeSet;

public final class MainThread
implements MainThreadScheduler {
    private final TreeSet<MainThreadExecutor> executors = new TreeSet((a, b) -> {
        if (a == b) {
            return 0;
        }
        long at = a.virtualTime;
        long bt = b.virtualTime;
        if (at == bt) {
            return Integer.compare(a.hashCode(), b.hashCode());
        }
        return at < bt ? -1 : 1;
    });
    final MainThreadConfig config;
    private final HashSet<MainThreadExecutor> cooling = new HashSet();
    private int currentTick;
    private long budget;
    private boolean canExecute = true;
    private long minimumTime = 0L;

    public MainThread() {
        this(MainThreadConfig.DEFAULT);
    }

    public MainThread(MainThreadConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queue(MainThreadExecutor executor) {
        TreeSet<MainThreadExecutor> treeSet = this.executors;
        synchronized (treeSet) {
            if (executor.onQueue) {
                throw new IllegalStateException("Cannot queue already queued executor");
            }
            executor.onQueue = true;
            executor.updateTime();
            long newRuntime = this.minimumTime;
            if (executor.virtualTime == 0L) {
                newRuntime += this.config.maxComputerTime();
            }
            executor.virtualTime = Math.max(newRuntime, executor.virtualTime);
            this.executors.add(executor);
        }
    }

    void cooling(MainThreadExecutor executor) {
        this.cooling.add(executor);
    }

    void consumeTime(long time) {
        this.budget -= time;
    }

    boolean canExecute() {
        return this.canExecute;
    }

    int currentTick() {
        return this.currentTick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        long taskStop;
        ++this.currentTick;
        long maxGlobal = this.config.maxGlobalTime();
        this.budget = Math.min(this.budget + maxGlobal, maxGlobal);
        this.canExecute = this.budget > 0L;
        this.cooling.removeIf(MainThreadExecutor::tickCooling);
        if (!this.canExecute) {
            return;
        }
        long start = System.nanoTime();
        long deadline = start + this.budget;
        do {
            MainThreadExecutor executor;
            TreeSet<MainThreadExecutor> treeSet = this.executors;
            synchronized (treeSet) {
                executor = this.executors.pollFirst();
            }
            if (executor == null) break;
            long taskStart = System.nanoTime();
            executor.execute();
            taskStop = System.nanoTime();
            TreeSet<MainThreadExecutor> treeSet2 = this.executors;
            synchronized (treeSet2) {
                if (executor.afterExecute(taskStop - taskStart)) {
                    this.executors.add(executor);
                }
                long newMinimum = executor.virtualTime;
                if (!this.executors.isEmpty()) {
                    MainThreadExecutor next = this.executors.first();
                    if (next.virtualTime < newMinimum) {
                        newMinimum = next.virtualTime;
                    }
                }
                this.minimumTime = Math.max(this.minimumTime, newMinimum);
            }
        } while (taskStop < deadline);
        this.consumeTime(System.nanoTime() - start);
    }

    @Override
    public MainThreadScheduler.Executor createExecutor(MetricsObserver metrics) {
        return new MainThreadExecutor(metrics, this);
    }
}

