/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.common;

import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.util.DataComponentUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public final class ClearColourRecipe
extends CustomRecipe {
    public ClearColourRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inv, Level world) {
        boolean hasColourable = false;
        boolean hasSponge = false;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is(ComputerCraftTags.Items.DYEABLE)) {
                if (hasColourable) {
                    return false;
                }
                if (!stack.has(DataComponents.DYED_COLOR)) {
                    return false;
                }
                hasColourable = true;
                continue;
            }
            if (stack.getItem() == Items.WET_SPONGE) {
                if (hasSponge) {
                    return false;
                }
                hasSponge = true;
                continue;
            }
            return false;
        }
        return hasColourable && hasSponge;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        ItemStack colourable = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (!stack.is(ComputerCraftTags.Items.DYEABLE)) continue;
            colourable = stack;
        }
        if (colourable.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return DataComponentUtil.createResult(colourable, DataComponents.DYED_COLOR, null);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput container) {
        NonNullList remaining = NonNullList.withSize((int)container.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < remaining.size(); ++i) {
            if (container.getItem(i).getItem() != Items.WET_SPONGE) continue;
            remaining.set(i, (Object)new ItemStack((ItemLike)Items.WET_SPONGE));
        }
        return remaining;
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x * y >= 2;
    }

    public RecipeSerializer<ClearColourRecipe> getSerializer() {
        return (RecipeSerializer)ModRegistry.RecipeSerializers.DYEABLE_ITEM_CLEAR.get();
    }
}

