/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.recipes;

import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.ColourTracker;
import dan200.computercraft.shared.util.ColourUtils;
import dan200.computercraft.shared.util.DataComponentUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DiskRecipe
extends CustomRecipe {
    private final Ingredient redstone = PlatformHelper.get().getRecipeIngredients().redstone();

    public DiskRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inv, Level world) {
        boolean paperFound = false;
        boolean redstoneFound = false;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() == Items.PAPER) {
                if (paperFound) {
                    return false;
                }
                paperFound = true;
                continue;
            }
            if (this.redstone.test(stack)) {
                if (redstoneFound) {
                    return false;
                }
                redstoneFound = true;
                continue;
            }
            if (ColourUtils.getStackColour(stack) != null) continue;
            return false;
        }
        return redstoneFound && paperFound;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        ColourTracker tracker = new ColourTracker();
        for (int i = 0; i < inv.size(); ++i) {
            DyeColor dye;
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || stack.getItem() == Items.PAPER || this.redstone.test(stack) || (dye = ColourUtils.getStackColour(stack)) == null) continue;
            tracker.addColour(dye);
        }
        return DataComponentUtil.createStack((ItemLike)ModRegistry.Items.DISK.get(), DataComponents.DYED_COLOR, new DyedItemColor(tracker.hasColour() ? tracker.getColour() : Colour.BLUE.getHex(), false));
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x >= 2 && y >= 2;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return DataComponentUtil.createStack((ItemLike)ModRegistry.Items.DISK.get(), DataComponents.DYED_COLOR, new DyedItemColor(Colour.BLUE.getHex(), false));
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRegistry.RecipeSerializers.DISK.get();
    }
}

