/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.shared.computer.upload.UploadResult;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.network.codec.MoreStreamCodecs;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class UploadResultMessage
implements NetworkMessage<ClientNetworkContext> {
    public static final StreamCodec<RegistryFriendlyByteBuf, UploadResultMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, x -> x.containerId, MoreStreamCodecs.ofEnum(UploadResult.class), x -> x.result, (StreamCodec)ComponentSerialization.OPTIONAL_STREAM_CODEC, x -> x.errorMessage, UploadResultMessage::new);
    private final int containerId;
    private final UploadResult result;
    private final Optional<Component> errorMessage;

    private UploadResultMessage(int containerId, UploadResult result, Optional<Component> errorMessage) {
        this.containerId = containerId;
        this.result = result;
        this.errorMessage = errorMessage;
    }

    public static UploadResultMessage queued(AbstractContainerMenu container) {
        return new UploadResultMessage(container.containerId, UploadResult.QUEUED, Optional.empty());
    }

    public static UploadResultMessage consumed(AbstractContainerMenu container) {
        return new UploadResultMessage(container.containerId, UploadResult.CONSUMED, Optional.empty());
    }

    public static UploadResultMessage error(AbstractContainerMenu container, Component errorMessage) {
        return new UploadResultMessage(container.containerId, UploadResult.ERROR, Optional.of(errorMessage));
    }

    @Override
    public void handle(ClientNetworkContext context) {
        context.handleUploadResult(this.containerId, this.result, this.errorMessage.orElse(null));
    }

    public CustomPacketPayload.Type<UploadResultMessage> type() {
        return NetworkMessages.UPLOAD_RESULT;
    }
}

