/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.diskdrive;

import dan200.computercraft.shared.ModRegistry;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class DiskDriveMenu
extends AbstractContainerMenu {
    private final Container inventory;

    public DiskDriveMenu(int id, Inventory player, Container inventory) {
        super((MenuType)ModRegistry.Menus.DISK_DRIVE.get(), id);
        this.inventory = inventory;
        this.addSlot(new Slot(this.inventory, 0, 80, 35));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)player, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)player, x, 8 + x * 18, 142));
        }
    }

    public DiskDriveMenu(int id, Inventory player) {
        this(id, player, (Container)new SimpleContainer(1));
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot == null || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack existing = slot.getItem().copy();
        ItemStack result = existing.copy();
        if (slotIndex == 0 ? !this.moveItemStackTo(existing, 1, 37, true) : !this.moveItemStackTo(existing, 0, 1, false)) {
            return ItemStack.EMPTY;
        }
        if (existing.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (existing.getCount() == result.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, existing);
        return result;
    }
}

