/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.platform.PlatformHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class RedstoneUtil {
    private RedstoneUtil() {
    }

    public static int getRedstoneInput(Level world, BlockPos pos, Direction side) {
        int power = world.getSignal(pos, side);
        if (power >= 15) {
            return power;
        }
        BlockState neighbour = world.getBlockState(pos);
        return neighbour.getBlock() == Blocks.REDSTONE_WIRE ? Math.max(power, (Integer)neighbour.getValue((Property)RedStoneWireBlock.POWER)) : power;
    }

    public static void propagateRedstoneOutput(Level world, BlockPos pos, Direction side) {
        BlockState block = world.getBlockState(pos);
        if (!PlatformHelper.get().onNotifyNeighbour(world, pos, block, side)) {
            return;
        }
        BlockPos neighbourPos = pos.relative(side);
        world.neighborChanged(neighbourPos, block.getBlock(), pos);
        world.updateNeighborsAt(neighbourPos, block.getBlock());
    }
}

