/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.block.component.data;

import codechicken.lib.block.component.data.DataGenComponent;
import codechicken.lib.datagen.NoValidationBLockLootSubProvider;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class LootTableComponent
extends DataGenComponent {
    private LootTable.Builder table = new LootTable.Builder();
    private final Consumer<LootTableComponent> configure;

    public LootTableComponent(Consumer<LootTableComponent> configure) {
        this.configure = configure;
    }

    @Override
    protected void addToProvider(DataProvider p) {
        if (p instanceof LootTableProvider) {
            LootTableProvider provider = (LootTableProvider)p;
            if (!(provider.subProviders instanceof ArrayList)) {
                provider.subProviders = new ArrayList(provider.subProviders);
            }
            provider.subProviders.add(new LootTableProvider.SubProviderEntry(registries -> new NoValidationBLockLootSubProvider((HolderLookup.Provider)registries){

                protected void generate() {
                    this.add(LootTableComponent.this.getBlock(), LootTableComponent.this.table);
                }
            }, LootContextParamSets.BLOCK));
            this.configure.accept(this);
        }
    }

    public void setTable(LootTable.Builder table) {
        this.table = table;
    }

    public void addPool(LootPool.Builder builder) {
        this.table.withPool(builder);
    }

    public void singleItemPool(ItemLike item) {
        this.addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)));
    }
}

