/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.common.compat.jei;

import earth.terrarium.chipped.common.compat.jei.WorkbenchCategory;
import earth.terrarium.chipped.common.recipes.ChippedRecipe;
import earth.terrarium.chipped.common.registry.ModItems;
import earth.terrarium.chipped.common.registry.ModRecipeTypes;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class ChippedJeiPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"chipped", (String)"jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new WorkbenchCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager();
        recipeManager.getAllRecipesFor((RecipeType)ModRecipeTypes.WORKBENCH.get()).forEach(recipe -> {
            List<Ingredient> ingredients = ((ChippedRecipe)recipe.value()).ingredients();
            registration.addRecipes(WorkbenchCategory.RECIPE, ingredients);
        });
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalysts(WorkbenchCategory.RECIPE, new ItemLike[]{(ItemLike)ModItems.BOTANIST_WORKBENCH.get(), (ItemLike)ModItems.GLASSBLOWER.get(), (ItemLike)ModItems.CARPENTERS_TABLE.get(), (ItemLike)ModItems.LOOM_TABLE.get(), (ItemLike)ModItems.MASON_TABLE.get(), (ItemLike)ModItems.ALCHEMY_BENCH.get(), (ItemLike)ModItems.TINKERING_TABLE.get()});
    }
}

