/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.twilightdelight.content.effect;

import dev.xkmc.twilightdelight.content.effect.RangeRenderEffect;
import dev.xkmc.twilightdelight.content.recipe.BaseEffectRecipe;
import dev.xkmc.twilightdelight.init.registrate.TDRecipes;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import twilightforest.init.TFMobEffects;

public class FrozenRange
extends RangeRenderEffect {
    public FrozenRange() {
        super(MobEffectCategory.BENEFICIAL, -16724788);
    }

    @Override
    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (entity.hasEffect((Holder)TFMobEffects.FROSTY)) {
            entity.removeEffect((Holder)TFMobEffects.FROSTY);
        }
        return super.applyEffectTick(entity, amplifier);
    }

    @Override
    protected void searchEntities(LivingEntity entity, int amplifier) {
        super.searchEntities(entity, amplifier);
        for (ItemEntity e : this.getEntitiesInRange(entity, ItemEntity.class)) {
            SingleRecipeInput inv = new SingleRecipeInput(e.getItem());
            Optional opt = entity.level().getRecipeManager().getRecipeFor((RecipeType)TDRecipes.WORLD_RECIPE.get(), (RecipeInput)inv, entity.level());
            if (!opt.isPresent()) continue;
            e.setTicksFrozen(e.getTicksFrozen() + 10);
            if (!e.isFullyFrozen()) continue;
            e.setItem(((BaseEffectRecipe)((RecipeHolder)opt.get()).value()).assemble(inv, (HolderLookup.Provider)entity.level().registryAccess()));
            e.setTicksFrozen(0);
        }
    }

    @Override
    protected void applyEffect(LivingEntity target, int amplifier) {
        target.addEffect(new MobEffectInstance((Holder)TFMobEffects.FROSTY, 21, 4));
    }

    @Override
    protected ParticleOptions getParticle() {
        return ParticleTypes.SNOWFLAKE;
    }
}

