/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.twilightdelight.init;

import dev.xkmc.twilightdelight.init.registrate.TDBlocks;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import twilightforest.block.DarkLeavesBlock;

@EventBusSubscriber(value={Dist.CLIENT}, modid="twilightdelight", bus=EventBusSubscriber.Bus.MOD)
public class TwilightDelightClient {
    @SubscribeEvent
    public static void registerBlockColor(RegisterColorHandlersEvent.Block event) {
        event.register(TwilightDelightClient::getLeafBlockColor, new Block[]{(Block)TDBlocks.IRON_LEAVES.get()});
    }

    @SubscribeEvent
    public static void registerItemColor(RegisterColorHandlersEvent.Item event) {
        event.register(TwilightDelightClient::getLeafItemColor, new ItemLike[]{((DarkLeavesBlock)TDBlocks.IRON_LEAVES.get()).asItem()});
    }

    private static int getLeafBlockColor(BlockState state, @Nullable BlockAndTintGetter getter, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex > 15) {
            return 0xFFFFFF;
        }
        if (getter != null && pos != null) {
            int red = 0;
            int grn = 0;
            int blu = 0;
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dx = -1; dx <= 1; ++dx) {
                    int i2 = BiomeColors.getAverageFoliageColor((BlockAndTintGetter)getter, (BlockPos)pos.offset(dx, 0, dz));
                    red += (i2 & 0xFF0000) >> 16;
                    grn += (i2 & 0xFF00) >> 8;
                    blu += i2 & 0xFF;
                }
            }
            return (red / 9 & 0xFF) << 16 | (grn / 9 & 0xFF) << 8 | blu / 9 & 0xFF;
        }
        return FoliageColor.getDefaultColor();
    }

    private static int getLeafItemColor(ItemStack stack, int tintIndex) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return TwilightDelightClient.getLeafBlockColor(blockItem.getBlock().defaultBlockState(), null, null, tintIndex);
        }
        return 0xFFFFFF;
    }
}

