/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.registration.reflect;

import io.wispforest.owo.registration.annotations.RegistryNamespace;
import io.wispforest.owo.registration.reflect.AutoRegistryContainer;
import io.wispforest.owo.registration.reflect.FieldProcessingSubject;
import io.wispforest.owo.registration.reflect.SimpleFieldProcessingSubject;
import io.wispforest.owo.util.ReflectionUtils;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public final class FieldRegistrationHandler {
    private FieldRegistrationHandler() {
    }

    public static <T> void process(Class<? extends FieldProcessingSubject<T>> clazz, ReflectionUtils.FieldConsumer<T> processor, boolean recurseIntoInnerClasses) {
        FieldProcessingSubject<T> handler = ReflectionUtils.tryInstantiateWithNoArgs(clazz);
        ReflectionUtils.iterateAccessibleStaticFields(clazz, handler.getTargetFieldType(), FieldRegistrationHandler.createProcessor(processor, handler));
        if (recurseIntoInnerClasses) {
            ReflectionUtils.forApplicableSubclasses(clazz, FieldProcessingSubject.class, subclass -> FieldRegistrationHandler.process(subclass, processor, true));
        }
        handler.afterFieldProcessing();
    }

    public static <T> void processSimple(Class<? extends SimpleFieldProcessingSubject<T>> clazz, boolean recurseIntoInnerClasses) {
        SimpleFieldProcessingSubject<T> handler = ReflectionUtils.tryInstantiateWithNoArgs(clazz);
        ReflectionUtils.iterateAccessibleStaticFields(clazz, handler.getTargetFieldType(), FieldRegistrationHandler.createProcessor(handler::processField, handler));
        if (recurseIntoInnerClasses) {
            ReflectionUtils.forApplicableSubclasses(clazz, SimpleFieldProcessingSubject.class, subclass -> FieldRegistrationHandler.processSimple(subclass, true));
        }
        handler.afterFieldProcessing();
    }

    public static <T> void register(Class<? extends AutoRegistryContainer<T>> clazz, String namespace, boolean recurseIntoInnerClasses) {
        AutoRegistryContainer container = ReflectionUtils.tryInstantiateWithNoArgs(clazz);
        ReflectionUtils.iterateAccessibleStaticFields(clazz, container.getTargetFieldType(), FieldRegistrationHandler.createProcessor((fieldValue, identifier, field) -> {
            Registry.register(container.getRegistry(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), (Object)fieldValue);
            container.postProcessField(namespace, fieldValue, identifier, field);
        }, container));
        if (recurseIntoInnerClasses) {
            ReflectionUtils.forApplicableSubclasses(clazz, AutoRegistryContainer.class, subclass -> {
                String classModId = namespace;
                if (subclass.isAnnotationPresent(RegistryNamespace.class)) {
                    classModId = subclass.getAnnotation(RegistryNamespace.class).value();
                }
                FieldRegistrationHandler.register(subclass, classModId, true);
            });
        }
        container.afterFieldProcessing();
    }

    private static <T> ReflectionUtils.FieldConsumer<T> createProcessor(ReflectionUtils.FieldConsumer<T> delegate, FieldProcessingSubject<T> handler) {
        return (value, name, field) -> {
            if (!handler.shouldProcessField(value, name, field)) {
                return;
            }
            delegate.accept(value, name, field);
        };
    }
}

