/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.item;

import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.WireConnectResult;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.index.CAItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WireSpool
extends Item {
    public WireSpool(Item.Properties props) {
        super(props);
    }

    public InteractionResult useOn(UseOnContext c) {
        CustomData data1 = (CustomData)c.getItemInHand().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag nbt = data1.copyTag();
        BlockPos clickedPos = c.getClickedPos();
        BlockEntity te = c.getLevel().getBlockEntity(clickedPos);
        if (te == null) {
            return InteractionResult.PASS;
        }
        if (!(te instanceof IWireNode)) {
            return InteractionResult.PASS;
        }
        IWireNode node = (IWireNode)te;
        Item heldItem = c.getItemInHand().getItem();
        if (WireSpool.hasPos(nbt)) {
            WireType connectionType = IWireNode.getTypeOfConnection(c.getLevel(), clickedPos, WireSpool.getPos(nbt));
            WireConnectResult result = WireSpool.isRemover(heldItem) ? IWireNode.disconnect(c.getLevel(), clickedPos, WireSpool.getPos(nbt)) : IWireNode.connect(c.getLevel(), WireSpool.getPos(nbt), WireSpool.getNode(nbt), clickedPos, node.getAvailableNode(c.getClickLocation()), WireType.of(c.getItemInHand().getItem()));
            if (result.isLinked()) {
                c.getLevel().playLocalSound((double)clickedPos.getX(), (double)clickedPos.getY(), (double)clickedPos.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_XYLOPHONE.value(), SoundSource.BLOCKS, 0.7f, 1.0f, false);
            } else if (result.isConnect()) {
                c.getLevel().playLocalSound((double)clickedPos.getX(), (double)clickedPos.getY(), (double)clickedPos.getZ(), SoundEvents.BOOK_PUT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            } else if (result == WireConnectResult.REMOVED) {
                c.getLevel().playLocalSound((double)clickedPos.getX(), (double)clickedPos.getY(), (double)clickedPos.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_XYLOPHONE.value(), SoundSource.BLOCKS, 0.7f, 0.5f, false);
            } else {
                c.getLevel().playLocalSound((double)clickedPos.getX(), (double)clickedPos.getY(), (double)clickedPos.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_DIDGERIDOO.value(), SoundSource.BLOCKS, 0.7f, 1.0f, false);
            }
            te.setChanged();
            if (c.getPlayer() != null && !c.getPlayer().isCreative()) {
                if (result == WireConnectResult.REMOVED) {
                    boolean shouldDrop;
                    c.getItemInHand().shrink(1);
                    ItemStack stack = connectionType.getSourceDrop();
                    boolean bl = shouldDrop = !c.getPlayer().addItem(stack);
                    if (shouldDrop) {
                        c.getPlayer().drop(stack, false);
                    }
                } else if (result.isLinked()) {
                    boolean shouldDrop;
                    c.getItemInHand().shrink(1);
                    ItemStack stack = new ItemStack((ItemLike)CAItems.SPOOL.get(), 1);
                    boolean bl = shouldDrop = !c.getPlayer().addItem(stack);
                    if (shouldDrop) {
                        c.getPlayer().drop(stack, false);
                    }
                }
            }
            c.getItemInHand().set(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            c.getItemInHand().remove(DataComponents.CUSTOM_DATA);
            c.getPlayer().displayClientMessage(result.getMessage(), true);
        } else {
            if (c.getPlayer() == null) {
                return InteractionResult.PASS;
            }
            if (WireSpool.isRemover(heldItem) && !node.hasAnyConnection()) {
                c.getPlayer().displayClientMessage(WireConnectResult.NO_CONNECTION.getMessage(), true);
                c.getLevel().playLocalSound((double)clickedPos.getX(), (double)clickedPos.getY(), (double)clickedPos.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_DIDGERIDOO.value(), SoundSource.BLOCKS, 0.7f, 1.0f, false);
                return InteractionResult.CONSUME;
            }
            int index = node.getAvailableNode(c.getClickLocation());
            if (index < 0) {
                return InteractionResult.PASS;
            }
            if (!WireSpool.isRemover(heldItem)) {
                c.getPlayer().displayClientMessage(WireConnectResult.getConnect(node.isNodeInput(index), node.isNodeOutput(index)).getMessage(), true);
            }
            c.getItemInHand().set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)WireSpool.setContent(nbt, node.getPos(), index)));
        }
        return InteractionResult.CONSUME;
    }

    public static boolean hasPos(CompoundTag nbt) {
        return nbt.contains("x") && nbt.contains("y") && nbt.contains("z") && nbt.contains("node");
    }

    public static BlockPos getPos(CompoundTag nbt) {
        return new BlockPos(nbt.getInt("x"), nbt.getInt("y"), nbt.getInt("z"));
    }

    public static int getNode(CompoundTag nbt) {
        return nbt.getInt("node");
    }

    public static CompoundTag setContent(CompoundTag nbt, BlockPos pos, int node) {
        if (nbt == null) {
            return new CompoundTag();
        }
        nbt.putInt("x", pos.getX());
        nbt.putInt("y", pos.getY());
        nbt.putInt("z", pos.getZ());
        nbt.putInt("node", node);
        return nbt;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return;
        }
        CompoundTag nbt = data.copyTag();
        if (WireSpool.hasPos(nbt)) {
            tooltipComponents.add((Component)Component.translatable((String)"item.createaddition.spool.nbt"));
        }
    }

    public static boolean isRemover(Item item) {
        return item == CAItems.SPOOL.get();
    }
}

