/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.nicguzzo.wands.WandsMod;
import net.nicguzzo.wands.client.WandToast;
import net.nicguzzo.wands.client.render.ClientRender;
import net.nicguzzo.wands.client.screens.MagicBagScreen;
import net.nicguzzo.wands.client.screens.PaletteScreen;
import net.nicguzzo.wands.client.screens.WandScreen;
import net.nicguzzo.wands.items.MagicBagItem;
import net.nicguzzo.wands.items.WandItem;
import net.nicguzzo.wands.networking.Networking;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.utils.WandUtils;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandProps;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WandsModClient {
    static boolean shift = false;
    static boolean alt = false;
    public static boolean has_optifine = false;
    public static boolean has_opac = false;
    public static KeyMapping wand_menu_km;
    public static final Logger LOGGER;
    public static final Map keys;
    public static final int wand_menu_key = 89;
    public static final int wand_mode_key = 86;
    public static final int wand_action_key = 72;
    public static final int wand_orientation_key = 88;
    public static final int wand_undo_key = 85;
    public static final int wand_invert_key = 73;
    public static final int wand_fill_circle_key = 75;
    public static final int wand_rotate = 82;
    public static final int palette_mode_key = 80;
    public static final int palette_menu_key = 74;
    public static final int wand_conf_key = -1;
    public static final int wand_m_inc_key = 262;
    public static final int wand_m_dec_key = 263;
    public static final int wand_n_inc_key = 265;
    public static final int wand_n_dec_key = 264;
    public static final int toggle_stair_slab_key = 46;
    public static final int area_diagonal_spread = 44;
    public static final int inc_sel_block = 90;
    static final String tab = "key.categories.wands";
    static final String k = "key.wands.";

    public static void initialize() {
        wand_menu_km = new KeyMapping("key.wands.wand_menu", 89, tab);
        keys.put(wand_menu_km, WandsMod.WandKeys.MENU);
        keys.put(new KeyMapping("key.wands.wand_mode", 86, tab), WandsMod.WandKeys.MODE);
        keys.put(new KeyMapping("key.wands.palette_menu", 74, tab), WandsMod.WandKeys.PALETTE_MENU);
        keys.put(new KeyMapping("key.wands.wand_action", 72, tab), WandsMod.WandKeys.ACTION);
        keys.put(new KeyMapping("key.wands.wand_orientation", 88, tab), WandsMod.WandKeys.ORIENTATION);
        keys.put(new KeyMapping("key.wands.wand_invert", 73, tab), WandsMod.WandKeys.INVERT);
        keys.put(new KeyMapping("key.wands.wand_fill_circle", 75, tab), WandsMod.WandKeys.FILL);
        keys.put(new KeyMapping("key.wands.wand_undo", 85, tab), WandsMod.WandKeys.UNDO);
        keys.put(new KeyMapping("key.wands.wand_palette_mode", 80, tab), WandsMod.WandKeys.PALETTE_MODE);
        keys.put(new KeyMapping("key.wands.wand_rotate", 82, tab), WandsMod.WandKeys.ROTATE);
        keys.put(new KeyMapping("key.wands.m_inc", 262, tab), WandsMod.WandKeys.M_INC);
        keys.put(new KeyMapping("key.wands.m_dec", 263, tab), WandsMod.WandKeys.M_DEC);
        keys.put(new KeyMapping("key.wands.n_inc", 265, tab), WandsMod.WandKeys.N_INC);
        keys.put(new KeyMapping("key.wands.n_dec", 264, tab), WandsMod.WandKeys.N_DEC);
        keys.put(new KeyMapping("key.wands.toggle_stair_slab", 46, tab), WandsMod.WandKeys.TOGGLE_STAIRSLAB);
        keys.put(new KeyMapping("key.wands.area_diagonal_spread", 44, tab), WandsMod.WandKeys.DIAGONAL_SPREAD);
        keys.put(new KeyMapping("key.wands.inc_sel_block", 90, tab), WandsMod.WandKeys.INC_SEL_BLK);
        keys.put(new KeyMapping("key.wands.clear_wand", 67, tab), WandsMod.WandKeys.CLEAR);
        keys.forEach((km, v) -> Compat.register_key((KeyMapping)km));
        ClientTickEvent.CLIENT_PRE.register(e -> {
            boolean any = false;
            for (Map.Entry me : keys.entrySet()) {
                KeyMapping km = (KeyMapping)me.getKey();
                WandsMod.WandKeys key = (WandsMod.WandKeys)((Object)((Object)me.getValue()));
                if (!km.consumeClick()) continue;
                if (!any) {
                    any = true;
                }
                if (key == WandsMod.WandKeys.CLEAR) {
                    WandsModClient.cancel_wand();
                } else {
                    WandsModClient.send_key(key.ordinal(), Screen.hasShiftDown(), Screen.hasAltDown());
                }
                if (key != WandsMod.WandKeys.ROTATE || ClientRender.wand == null || ClientRender.wand.mode != WandProps.Mode.ROCK) continue;
                ClientRender.wand.get_mode().randomize();
            }
            if (!(any || alt == Screen.hasAltDown() && shift == Screen.hasShiftDown())) {
                alt = Screen.hasAltDown();
                shift = Screen.hasShiftDown();
                ClientRender.wand.is_alt_pressed = alt;
                ClientRender.wand.is_shift_pressed = shift;
                WandsModClient.send_key(-1, shift, alt);
            }
        });
        Compat.render_info();
        if (WandsMod.is_forge) {
            ClientLifecycleEvent.CLIENT_SETUP.register(e -> {
                try {
                    MenuRegistry.registerScreenFactory((MenuType)((MenuType)WandsMod.PALETTE_CONTAINER.get()), PaletteScreen::new);
                    MenuRegistry.registerScreenFactory((MenuType)((MenuType)WandsMod.WAND_CONTAINER.get()), WandScreen::new);
                    MenuRegistry.registerScreenFactory((MenuType)((MenuType)WandsMod.MAGIC_WAND_CONTANIER.get()), MagicBagScreen::new);
                }
                catch (Exception ex) {
                    WandsMod.LOGGER.error(ex.getMessage());
                }
            });
        } else if (!WandsMod.is_neoforge) {
            MenuRegistry.registerScreenFactory((MenuType)((MenuType)WandsMod.PALETTE_CONTAINER.get()), PaletteScreen::new);
            MenuRegistry.registerScreenFactory((MenuType)((MenuType)WandsMod.WAND_CONTAINER.get()), WandScreen::new);
            MenuRegistry.registerScreenFactory((MenuType)((MenuType)WandsMod.MAGIC_WAND_CONTANIER.get()), MagicBagScreen::new);
        }
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, Networking.PlayerDataPacket.TYPE, Networking.PlayerDataPacket.STREAM_CODEC, (data, context) -> {
            if (ClientRender.wand != null) {
                ClientRender.wand.player_data = data.tag();
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, Networking.ConfPacket.TYPE, Networking.ConfPacket.STREAM_CODEC, (data, context) -> {
            if (WandsMod.config != null) {
                WandsMod.config.blocks_per_xp = data.blocks_per_xp();
                WandsMod.config.destroy_in_survival_drop = data.destroy_in_survival_drop();
                WandsMod.config.survival_unenchanted_drops = data.survival_unenchanted_drops();
                WandsMod.config.allow_wand_to_break = data.allow_wand_to_break();
                WandsMod.config.allow_offhand_to_break = data.allow_offhand_to_break();
                WandsMod.config.mend_tools = data.mend_tools();
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, Networking.SndPacket.TYPE, Networking.SndPacket.STREAM_CODEC, (data, context) -> {
            BlockPos pos = data.pos();
            boolean destroy = data.destroy();
            ItemStack item_stack = data.item_stack();
            int i_sound = data.i_sound();
            if (i_sound > -1 && i_sound < Wand.Sounds.values().length) {
                Wand.Sounds snd = Wand.Sounds.values()[i_sound];
                SoundEvent sound = snd.get_sound();
                Compat.player_level(context.getPlayer()).playSound(context.getPlayer(), pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (!item_stack.isEmpty()) {
                Block block = Block.byItem((Item)item_stack.getItem());
                BlockState bs = block.defaultBlockState();
                SoundType sound_type = bs.getSoundType();
                SoundEvent sound = destroy ? sound_type.getBreakSound() : sound_type.getPlaceSound();
                Compat.player_level(context.getPlayer()).playSound(context.getPlayer(), pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, Networking.ToastPacket.TYPE, Networking.ToastPacket.STREAM_CODEC, (data, context) -> {
            boolean no_tool = data.no_tool();
            boolean damaged_tool = data.damaged_tool();
            if (no_tool) {
                Compat.toast(new WandToast("no tool"));
            }
            if (damaged_tool) {
                Compat.toast(new WandToast("invalid or damaged"));
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, Networking.StatePacket.TYPE, Networking.StatePacket.STREAM_CODEC, (data, context) -> {
            int mode = data.mode();
            int slot = data.slot();
            boolean xp = data.xp();
            int levels = data.levels();
            float prog = data.prog();
            if (ClientRender.wand != null) {
                ClientRender.wand.mode = WandProps.Mode.values()[mode];
                if (ClientRender.wand.mode == WandProps.Mode.DIRECTION) {
                    ClientRender.wand.palette.slot = slot;
                }
                if (xp) {
                    context.getPlayer().experienceLevel = levels;
                    context.getPlayer().experienceProgress = prog;
                }
            }
        });
    }

    public static void send_key(int key, boolean shift, boolean alt) {
        Minecraft client = Minecraft.getInstance();
        if (client.getConnection() != null) {
            NetworkManager.sendToServer((CustomPacketPayload)new Networking.KbPacket(key, shift, alt));
        }
    }

    public static void send_palette(boolean next_mode, boolean toggle_rotate, int grad_h) {
        NetworkManager.sendToServer((CustomPacketPayload)new Networking.PalettePacket(next_mode, toggle_rotate, grad_h));
    }

    public static void send_wand(ItemStack item) {
        NetworkManager.sendToServer((CustomPacketPayload)new Networking.WandPacket(item));
    }

    public static void render_wand_info(GuiGraphics gui) {
        Minecraft client = Minecraft.getInstance();
        if (client != null && client.player != null) {
            ItemStack stack = client.player.getMainHandItem();
            ItemStack offhand_stack = client.player.getOffhandItem();
            boolean main = stack != null && !stack.isEmpty() && stack.getItem() instanceof WandItem;
            boolean main_bag = stack != null && !stack.isEmpty() && stack.getItem() instanceof MagicBagItem;
            boolean off_bag = offhand_stack != null && !offhand_stack.isEmpty() && offhand_stack.getItem() instanceof MagicBagItem;
            int screenWidth = client.getWindow().getGuiScaledWidth();
            int screenHeight = client.getWindow().getGuiScaledHeight();
            if (main_bag || off_bag || main) {
                Font font;
                if (main_bag || off_bag) {
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    font = client.font;
                    Compat.set_color(1.0f, 1.0f, 1.0f, 1.0f);
                    Compat.set_pos_tex_shader();
                    Objects.requireNonNull(font);
                    int h = 3 * 9;
                    float x = (int)((float)screenWidth * (WandsMod.config.wand_mode_display_x_pos / 100.0f));
                    float y = (int)((float)(screenHeight - h) * (WandsMod.config.wand_mode_display_y_pos / 100.0f));
                    ItemStack s = main_bag ? stack : offhand_stack;
                    ItemStack bgi = MagicBagItem.getItem(s, (HolderLookup.Provider)client.level.registryAccess());
                    int y_off = 0;
                    if (main) {
                        Objects.requireNonNull(font);
                        y_off = -9 * 3;
                    }
                    String string = "Item: " + Component.translatable((String)bgi.getItem().getDescriptionId()).getString();
                    int n = (int)x;
                    int n2 = (int)y + y_off;
                    Objects.requireNonNull(font);
                    gui.drawString(font, string, n, n2 + 9, 0xFFFFFF);
                    String string2 = "Total: " + MagicBagItem.getTotal(s);
                    int n3 = (int)x;
                    int n4 = (int)y + y_off;
                    Objects.requireNonNull(font);
                    gui.drawString(font, string2, n3, n4 + 9 * 2, 0xFFFFFF);
                }
                if (main) {
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    font = client.font;
                    Compat.set_color(1.0f, 1.0f, 1.0f, 1.0f);
                    Compat.set_pos_tex_shader();
                    Wand wand = ClientRender.wand;
                    WandProps.Mode mode = WandProps.getMode(stack);
                    WandProps.Action action = WandProps.getAction(stack);
                    Rotation r = WandProps.getRotation(stack);
                    String rot = "";
                    switch (r) {
                        case NONE: {
                            rot = "0\u00b0";
                            break;
                        }
                        case CLOCKWISE_90: {
                            rot = "90\u00b0";
                            break;
                        }
                        case CLOCKWISE_180: {
                            rot = "180\u00b0";
                            break;
                        }
                        case COUNTERCLOCKWISE_90: {
                            rot = "270\u00b0";
                        }
                    }
                    Object p1 = "";
                    Object p2 = "";
                    BlockPos bp1 = wand.getP1();
                    BlockPos bp2 = wand.getP2();
                    if (wand.getP1() != null) {
                        p1 = "p1:[" + bp1.getX() + "," + bp1.getY() + "," + bp1.getZ() + "]";
                    }
                    if (wand.getP2() != null) {
                        p2 = "p2:[" + bp2.getX() + "," + bp2.getY() + "," + bp2.getZ() + "]";
                    } else if (wand.getP1() != null) {
                        p2 = "p2:[" + ClientRender.last_pos.getX() + "," + ClientRender.last_pos.getY() + "," + ClientRender.last_pos.getZ() + "]";
                    }
                    Object ln1 = "";
                    String ln2 = "Action: " + Compat.translatable(action.toString()).getString();
                    String ln3 = "Mode: " + Compat.translatable(mode.toString()).getString() + " Rot:" + rot;
                    if (wand.valid) {
                        switch (mode) {
                            case DIRECTION: {
                                int mult = WandProps.getVal(stack, WandProps.Value.MULTIPLIER);
                                ln1 = "pos: [" + wand.pos.getX() + "," + wand.pos.getY() + "," + wand.pos.getZ() + "] x" + mult;
                                break;
                            }
                            case GRID: {
                                int gm = WandProps.getVal(stack, WandProps.Value.GRIDM);
                                int gn = WandProps.getVal(stack, WandProps.Value.GRIDN);
                                int gms = WandProps.getVal(stack, WandProps.Value.GRIDMS);
                                int gns = WandProps.getVal(stack, WandProps.Value.GRIDNS);
                                Object skp = "";
                                if (gms > 0 || gns > 0) {
                                    skp = " - (" + gms + "x" + gns + ")";
                                }
                                ln1 = "Grid " + gm + "x" + gn + (String)skp;
                                break;
                            }
                            case ROW_COL: 
                            case LINE: 
                            case AREA: 
                            case VEIN: 
                            case FILL: {
                                if (mode == WandProps.Mode.FILL) {
                                    int nx = wand.fill_nx + 1;
                                    int ny = wand.fill_ny + 1;
                                    int nz = wand.fill_nz + 1;
                                    ln1 = (String)ln1 + "volume [" + nx + "," + ny + "," + nz + "] ";
                                }
                                int arealim = WandProps.getVal(stack, WandProps.Value.AREALIM);
                                ln1 = (String)ln1 + "Blocks: " + wand.block_buffer.get_length();
                                if (arealim <= 0) break;
                                ln1 = (String)ln1 + " Limit: " + arealim;
                                break;
                            }
                            case CIRCLE: 
                            case SPHERE: {
                                ln1 = "Radius: " + wand.radius + " N: " + wand.block_buffer.get_length();
                                break;
                            }
                            case COPY: 
                            case PASTE: {
                                ln1 = "Copied Blocks: " + wand.copy_paste_buffer.size();
                            }
                        }
                    }
                    Objects.requireNonNull(font);
                    int h = 3 * 9;
                    float x = (int)((float)screenWidth * (WandsMod.config.wand_mode_display_x_pos / 100.0f));
                    float y = (int)((float)(screenHeight - h) * (WandsMod.config.wand_mode_display_y_pos / 100.0f));
                    gui.drawString(font, (String)ln1, (int)x, (int)y, 0xFFFFFF);
                    int n = (int)x;
                    int n5 = (int)y;
                    Objects.requireNonNull(font);
                    gui.drawString(font, ln2, n, n5 + 9, 0xFFFFFF);
                    int n6 = (int)x;
                    int n7 = (int)y;
                    Objects.requireNonNull(font);
                    gui.drawString(font, ln3, n6, n7 + 9 * 2, 0xFFFFFF);
                    int n8 = (int)x;
                    int n9 = (int)y;
                    Objects.requireNonNull(font);
                    gui.drawString(font, (String)p1, n8, n9 - 9 * 2, 0xFFFFFF);
                    int n10 = (int)x;
                    int n11 = (int)y;
                    Objects.requireNonNull(font);
                    gui.drawString(font, (String)p2, n10, n11 - 9, 0xFFFFFF);
                }
            }
        }
    }

    public static void cancel_wand() {
        if (ClientRender.wand != null && ClientRender.wand.wand_stack != null && WandUtils.is_wand(ClientRender.wand.wand_stack)) {
            ClientRender.wand.clear();
            if (ClientRender.wand.player != null) {
                ClientRender.wand.player.displayClientMessage((Component)Compat.literal("wand cleared"), false);
            }
        }
    }

    static {
        LOGGER = LogManager.getLogger();
        keys = new HashMap();
    }
}

