/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.event;

import com.mojang.blaze3d.pipeline.RenderTarget;
import fi.dy.masa.malilib.interfaces.IRenderDispatcher;
import fi.dy.masa.malilib.interfaces.IRenderer;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

public class RenderEventHandler
implements IRenderDispatcher {
    private static final RenderEventHandler INSTANCE = new RenderEventHandler();
    private final List<IRenderer> overlayRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> tooltipLastRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> worldLastRenderers = new ArrayList<IRenderer>();

    public static IRenderDispatcher getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerGameOverlayRenderer(IRenderer renderer) {
        if (!this.overlayRenderers.contains(renderer)) {
            this.overlayRenderers.add(renderer);
        }
    }

    @Override
    public void registerTooltipLastRenderer(IRenderer renderer) {
        if (!this.tooltipLastRenderers.contains(renderer)) {
            this.tooltipLastRenderers.add(renderer);
        }
    }

    @Override
    public void registerWorldLastRenderer(IRenderer renderer) {
        if (!this.worldLastRenderers.contains(renderer)) {
            this.worldLastRenderers.add(renderer);
        }
    }

    @ApiStatus.Internal
    public void onRenderGameOverlayLastDrawer(GuiGraphics drawContext, Minecraft mc, float partialTicks) {
        mc.getProfiler().push("malilib_rendergameoverlaydrawer");
        if (!this.overlayRenderers.isEmpty()) {
            for (IRenderer renderer : this.overlayRenderers) {
                mc.getProfiler().push(renderer.getProfilerSectionSupplier());
                renderer.onRenderGameOverlayLastDrawer(drawContext, partialTicks, mc.getProfiler(), mc);
                mc.getProfiler().pop();
            }
        }
        mc.getProfiler().pop();
    }

    @ApiStatus.Internal
    public void onRenderGameOverlayPost(GuiGraphics drawContext, Minecraft mc, float partialTicks) {
        mc.getProfiler().push("malilib_rendergameoverlaypost");
        if (!this.overlayRenderers.isEmpty()) {
            for (IRenderer renderer : this.overlayRenderers) {
                mc.getProfiler().push(renderer.getProfilerSectionSupplier());
                renderer.onRenderGameOverlayPost(drawContext);
                mc.getProfiler().pop();
            }
        }
        mc.getProfiler().push("malilib_ingamemessages");
        InfoUtils.renderInGameMessages(drawContext);
        mc.getProfiler().pop();
        mc.getProfiler().pop();
    }

    @ApiStatus.Internal
    public void onRenderTooltipComponentInsertFirst(Item.TooltipContext context, ItemStack stack, List<Component> list) {
        if (!this.tooltipLastRenderers.isEmpty()) {
            for (IRenderer renderer : this.tooltipLastRenderers) {
                renderer.onRenderTooltipComponentInsertFirst(context, stack, list);
            }
        }
    }

    @ApiStatus.Internal
    public void onRenderTooltipComponentInsertMiddle(Item.TooltipContext context, ItemStack stack, List<Component> list) {
        if (!this.tooltipLastRenderers.isEmpty()) {
            for (IRenderer renderer : this.tooltipLastRenderers) {
                renderer.onRenderTooltipComponentInsertMiddle(context, stack, list);
            }
        }
    }

    @ApiStatus.Internal
    public void onRenderTooltipComponentInsertLast(Item.TooltipContext context, ItemStack stack, List<Component> list) {
        if (!this.tooltipLastRenderers.isEmpty()) {
            for (IRenderer renderer : this.tooltipLastRenderers) {
                renderer.onRenderTooltipComponentInsertLast(context, stack, list);
            }
        }
    }

    @ApiStatus.Internal
    public void onRenderTooltipLast(GuiGraphics drawContext, ItemStack stack, int x, int y) {
        if (!this.tooltipLastRenderers.isEmpty()) {
            for (IRenderer renderer : this.tooltipLastRenderers) {
                renderer.onRenderTooltipLast(drawContext, stack, x, y);
            }
        }
    }

    @ApiStatus.Internal
    public void onRenderWorldLast(Matrix4f matrix4f, Matrix4f projMatrix, Minecraft mc) {
        if (!this.worldLastRenderers.isEmpty()) {
            RenderTarget fb;
            mc.getProfiler().popPush("malilib_renderworldlast");
            RenderTarget renderTarget = fb = Minecraft.useShaderTransparency() ? mc.levelRenderer.getTranslucentTarget() : null;
            if (fb != null) {
                fb.bindWrite(false);
            }
            for (IRenderer renderer : this.worldLastRenderers) {
                mc.getProfiler().push(renderer.getProfilerSectionSupplier());
                renderer.onRenderWorldLast(matrix4f, projMatrix);
                mc.getProfiler().pop();
            }
            if (fb != null) {
                mc.getMainRenderTarget().bindWrite(false);
            }
        }
    }
}

