/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.CommonComponents;

public class GuiTextFieldGeneric
extends EditBox {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int zLevel;

    public GuiTextFieldGeneric(int x, int y, int width, int height, Font textRenderer) {
        super(textRenderer, x, y, width, height, CommonComponents.EMPTY);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.setMaxLength(256);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean ret = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.isMouseOver((int)mouseX, (int)mouseY)) {
            if (mouseButton == 1) {
                this.setValue("");
            }
            this.setFocused(true);
            return true;
        }
        this.setFocused(false);
        return ret;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height;
    }

    public GuiTextFieldGeneric setZLevel(int zLevel) {
        this.zLevel = zLevel;
        return this;
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.zLevel != 0) {
            PoseStack matrixStack = context.pose();
            matrixStack.pushPose();
            matrixStack.translate(0.0f, 0.0f, (float)this.zLevel);
            super.renderWidget(context, mouseX, mouseY, delta);
            matrixStack.popPose();
        } else {
            super.renderWidget(context, mouseX, mouseY, delta);
        }
    }

    public void setTextWrapper(String text) {
        this.setValue(text);
    }

    public String getTextWrapper() {
        return this.getValue();
    }

    public void setMaxLengthWrapper(int length) {
        this.setMaxLength(length);
    }

    public int getCursorWrapper() {
        return this.getCursorPosition();
    }

    public void setFocusedWrapper(boolean focus) {
        this.setFocused(focus);
    }

    public boolean isFocusedWrapper() {
        return this.isFocused();
    }

    public int getXWrapper() {
        return this.getX();
    }

    public int getYWrapper() {
        return this.getY();
    }

    public void setXWrapper(int x) {
        this.setX(x);
    }

    public void setYWrapper(int y) {
        this.setY(y);
    }

    public int getWidthWrapper() {
        return this.getWidth();
    }

    public void renderWrapper(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.render(context, mouseX, mouseY, delta);
    }

    public boolean keyPressedWrapper(int keyCode, int scanCode, int modifiers) {
        return this.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTypedWrapper(char chr, int modifiers) {
        return this.charTyped(chr, modifiers);
    }

    public boolean mouseClickedWrapper(double mouseX, double mouseY, int mouseButton) {
        return this.mouseClicked(mouseX, mouseY, mouseButton);
    }
}

