/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.wrappers;

import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import net.minecraft.client.gui.GuiGraphics;

public class TextFieldWrapper<T extends GuiTextFieldGeneric> {
    private final T textField;
    private final ITextFieldListener<T> listener;

    public TextFieldWrapper(T textField, ITextFieldListener<T> listener) {
        this.textField = textField;
        this.listener = listener;
    }

    public T getTextField() {
        return this.textField;
    }

    public ITextFieldListener<T> getListener() {
        return this.listener;
    }

    public boolean isFocused() {
        return this.textField.isFocused();
    }

    public void setFocused(boolean isFocused) {
        this.textField.setFocused(isFocused);
    }

    public void onGuiClosed() {
        if (this.listener != null) {
            this.listener.onGuiClosed(this.textField);
        }
    }

    public void draw(int mouseX, int mouseY, GuiGraphics drawContext) {
        this.textField.render(drawContext, mouseX, mouseY, 0.0f);
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (((GuiTextFieldGeneric)((Object)this.textField)).mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (!((GuiTextFieldGeneric)((Object)this.textField)).isMouseOver(mouseX, mouseY)) {
            this.textField.setFocused(false);
        }
        return false;
    }

    public boolean onKeyTyped(int keyCode, int scanCode, int modifiers) {
        String textPre = this.textField.getValue();
        if (this.textField.isFocused() && this.textField.keyPressed(keyCode, scanCode, modifiers)) {
            if (!(this.listener == null || keyCode != 257 && keyCode != 258 && this.textField.getValue().equals(textPre))) {
                this.listener.onTextChange(this.textField);
            }
            return true;
        }
        return false;
    }

    public boolean onCharTyped(char charIn, int modifiers) {
        String textPre = this.textField.getValue();
        if (this.textField.isFocused() && this.textField.charTyped(charIn, modifiers)) {
            if (this.listener != null && !this.textField.getValue().equals(textPre)) {
                this.listener.onTextChange(this.textField);
            }
            return true;
        }
        return false;
    }
}

