/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.MathUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class RenderUtils {
    public static final ResourceLocation TEXTURE_MAP_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/map/map_background.png");
    public static final ResourceLocation TEXTURE_MAP_BACKGROUND_CHECKERBOARD = ResourceLocation.withDefaultNamespace((String)"textures/map/map_background_checkerboard.png");
    private static final SingleThreadedRandomSource RAND = new SingleThreadedRandomSource(0L);

    public static void setupBlend() {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    public static void setupBlendSimple() {
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    public static void bindTexture(ResourceLocation texture) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
    }

    public static void forceDraw(GuiGraphics drawContext) {
        drawContext.flush();
    }

    public static void color(float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public static void disableDiffuseLighting() {
        Lighting.setupForFlatItems();
    }

    public static void enableDiffuseLightingForLevel() {
        Lighting.setupNetherLevel();
    }

    public static void enableDiffuseLightingGui3D() {
        Lighting.setupFor3DItems();
    }

    public static void drawOutlinedBox(int x, int y, int width, int height, int colorBg, int colorBorder) {
        RenderUtils.drawOutlinedBox(x, y, width, height, colorBg, colorBorder, 0.0f);
    }

    public static void drawOutlinedBox(int x, int y, int width, int height, int colorBg, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, width, height, colorBg, zLevel);
        RenderUtils.drawOutline(x - 1, y - 1, width + 2, height + 2, colorBorder, zLevel);
    }

    public static void drawOutline(int x, int y, int width, int height, int colorBorder) {
        RenderUtils.drawOutline(x, y, width, height, colorBorder, 0.0f);
    }

    public static void drawOutline(int x, int y, int width, int height, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, 1, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + width - 1, y, 1, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + 1, y, width - 2, 1, colorBorder, zLevel);
        RenderUtils.drawRect(x + 1, y + height - 1, width - 2, 1, colorBorder, zLevel);
    }

    public static void drawOutline(int x, int y, int width, int height, int borderWidth, int colorBorder) {
        RenderUtils.drawOutline(x, y, width, height, borderWidth, colorBorder, 0.0f);
    }

    public static void drawOutline(int x, int y, int width, int height, int borderWidth, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, borderWidth, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + width - borderWidth, y, borderWidth, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + borderWidth, y, width - 2 * borderWidth, borderWidth, colorBorder, zLevel);
        RenderUtils.drawRect(x + borderWidth, y + height - borderWidth, width - 2 * borderWidth, borderWidth, colorBorder, zLevel);
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height) {
        RenderUtils.drawTexturedRect(x, y, u, v, width, height, 0.0f);
    }

    public static void drawRect(int x, int y, int width, int height, int color) {
        RenderUtils.drawRect(x, y, width, height, color, 0.0f);
    }

    public static void drawRect(int x, int y, int width, int height, int color, float zLevel) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.applyModelViewMatrix();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderUtils.setupBlend();
        buffer.addVertex((float)x, (float)y, zLevel).setColor(r, g, b, a);
        buffer.addVertex((float)x, (float)(y + height), zLevel).setColor(r, g, b, a);
        buffer.addVertex((float)(x + width), (float)(y + height), zLevel).setColor(r, g, b, a);
        buffer.addVertex((float)(x + width), (float)y, zLevel).setColor(r, g, b, a);
        try {
            MeshData builtBuffer = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void drawScreenBlur(Minecraft mc) {
        mc.gameRenderer.processBlurEffect((float)mc.options.getMenuBackgroundBlurriness());
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height, float zLevel) {
        float pixelWidth = 0.00390625f;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.applyModelViewMatrix();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        RenderUtils.setupBlend();
        buffer.addVertex((float)x, (float)(y + height), zLevel).setUv((float)u * pixelWidth, (float)(v + height) * pixelWidth);
        buffer.addVertex((float)(x + width), (float)(y + height), zLevel).setUv((float)(u + width) * pixelWidth, (float)(v + height) * pixelWidth);
        buffer.addVertex((float)(x + width), (float)y, zLevel).setUv((float)(u + width) * pixelWidth, (float)v * pixelWidth);
        buffer.addVertex((float)x, (float)y, zLevel).setUv((float)u * pixelWidth, (float)v * pixelWidth);
        try {
            MeshData builtBuffer = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, BufferBuilder buffer) {
        RenderUtils.drawTexturedRectBatched(x, y, u, v, width, height, 0.0f, buffer);
    }

    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, float zLevel, BufferBuilder buffer) {
        float pixelWidth = 0.00390625f;
        buffer.addVertex((float)x, (float)(y + height), zLevel).setUv((float)u * pixelWidth, (float)(v + height) * pixelWidth);
        buffer.addVertex((float)(x + width), (float)(y + height), zLevel).setUv((float)(u + width) * pixelWidth, (float)(v + height) * pixelWidth);
        buffer.addVertex((float)(x + width), (float)y, zLevel).setUv((float)(u + width) * pixelWidth, (float)v * pixelWidth);
        buffer.addVertex((float)x, (float)y, zLevel).setUv((float)u * pixelWidth, (float)v * pixelWidth);
    }

    public static void drawHoverText(int x, int y, List<String> textLines, GuiGraphics drawContext) {
        Minecraft mc = RenderUtils.mc();
        if (!textLines.isEmpty() && GuiUtils.getCurrentScreen() != null) {
            RenderSystem.enableDepthTest();
            Font font = mc.font;
            int maxLineLength = 0;
            int maxWidth = GuiUtils.getCurrentScreen().width;
            ArrayList<String> linesNew = new ArrayList<String>();
            for (String lineOrig : textLines) {
                String[] lines;
                for (String line : lines = lineOrig.split("\\n")) {
                    int length = font.width(line);
                    if (length > maxLineLength) {
                        maxLineLength = length;
                    }
                    linesNew.add(line);
                }
            }
            textLines = linesNew;
            Objects.requireNonNull(font);
            int lineHeight = 9 + 1;
            int textHeight = textLines.size() * lineHeight - 2;
            int textStartX = x + 4;
            int textStartY = Math.max(8, y - textHeight - 6);
            if (textStartX + maxLineLength + 6 > maxWidth) {
                textStartX = Math.max(2, maxWidth - maxLineLength - 8);
            }
            PoseStack matrixStack = drawContext.pose();
            matrixStack.pushPose();
            matrixStack.translate(0.0f, 0.0f, 300.0f);
            RenderSystem.applyModelViewMatrix();
            float zLevel = 300.0f;
            int borderColor = -267386864;
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 4, textStartX + maxLineLength + 3, textStartY - 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY + textHeight + 3, textStartX + maxLineLength + 3, textStartY + textHeight + 4, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 4, textStartY - 3, textStartX - 3, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX + maxLineLength + 3, textStartY - 3, textStartX + maxLineLength + 4, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            int fillColor1 = 0x505000FF;
            int fillColor2 = 1344798847;
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3 + 1, textStartX - 3 + 1, textStartY + textHeight + 3 - 1, zLevel, fillColor1, fillColor2);
            RenderUtils.drawGradientRect(textStartX + maxLineLength + 2, textStartY - 3 + 1, textStartX + maxLineLength + 3, textStartY + textHeight + 3 - 1, zLevel, fillColor1, fillColor2);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY - 3 + 1, zLevel, fillColor1, fillColor1);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY + textHeight + 2, textStartX + maxLineLength + 3, textStartY + textHeight + 3, zLevel, fillColor2, fillColor2);
            for (int i = 0; i < textLines.size(); ++i) {
                String str = textLines.get(i);
                drawContext.drawString(font, str, textStartX, textStartY, -1, false);
                textStartY += lineHeight;
            }
            matrixStack.popPose();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static void drawGradientRect(float left, float top, float right, float bottom, float zLevel, int startColor, int endColor) {
        int sa = startColor >> 24 & 0xFF;
        int sr = startColor >> 16 & 0xFF;
        int sg = startColor >> 8 & 0xFF;
        int sb = startColor & 0xFF;
        int ea = endColor >> 24 & 0xFF;
        int er = endColor >> 16 & 0xFF;
        int eg = endColor >> 8 & 0xFF;
        int eb = endColor & 0xFF;
        RenderUtils.setupBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.applyModelViewMatrix();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(right, top, zLevel).setColor(sr, sg, sb, sa);
        buffer.addVertex(left, top, zLevel).setColor(sr, sg, sb, sa);
        buffer.addVertex(left, bottom, zLevel).setColor(er, eg, eb, ea);
        buffer.addVertex(right, bottom, zLevel).setColor(er, eg, eb, ea);
        try {
            MeshData builtBuffer = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RenderSystem.disableBlend();
    }

    public static void drawCenteredString(int x, int y, int color, String text, GuiGraphics drawContext) {
        Font textRenderer = RenderUtils.mc().font;
        drawContext.drawCenteredString(textRenderer, text, x, y, color);
    }

    public static void drawHorizontalLine(int x, int y, int width, int color) {
        RenderUtils.drawRect(x, y, width, 1, color);
    }

    public static void drawVerticalLine(int x, int y, int height, int color) {
        RenderUtils.drawRect(x, y, 1, height, color);
    }

    public static void renderSprite(int x, int y, int width, int height, ResourceLocation atlas, ResourceLocation texture, GuiGraphics drawContext) {
        if (texture != null) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)RenderUtils.mc().getTextureAtlas(atlas).apply(texture);
            drawContext.blit(x, y, 0, width, height, sprite);
        }
    }

    public static void renderText(int x, int y, int color, String text, GuiGraphics drawContext) {
        String[] parts = text.split("\\\\n");
        Font textRenderer = RenderUtils.mc().font;
        for (String line : parts) {
            drawContext.drawString(textRenderer, line, x, y, color, true);
            Objects.requireNonNull(textRenderer);
            y += 9 + 1;
        }
    }

    public static void renderText(int x, int y, int color, List<String> lines, GuiGraphics drawContext) {
        if (!lines.isEmpty()) {
            Font textRenderer = RenderUtils.mc().font;
            for (String line : lines) {
                drawContext.drawString(textRenderer, line, x, y, color, false);
                Objects.requireNonNull(textRenderer);
                y += 9 + 2;
            }
        }
    }

    public static int renderText(int xOff, int yOff, double scale, int textColor, int bgColor, HudAlignment alignment, boolean useBackground, boolean useShadow, List<String> lines, GuiGraphics drawContext) {
        return RenderUtils.renderText(xOff, yOff, scale, textColor, bgColor, alignment, useBackground, useShadow, true, lines, drawContext);
    }

    public static int renderText(int xOff, int yOff, double scale, int textColor, int bgColor, HudAlignment alignment, boolean useBackground, boolean useShadow, boolean useStatusShift, List<String> lines, GuiGraphics drawContext) {
        boolean scaled;
        Font fontRenderer = RenderUtils.mc().font;
        int scaledWidth = GuiUtils.getScaledWindowWidth();
        Objects.requireNonNull(fontRenderer);
        int lineHeight = 9 + 2;
        int contentHeight = lines.size() * lineHeight - 2;
        int bgMargin = 2;
        if (scale < 0.0125) {
            return 0;
        }
        Matrix4fStack global4fStack = RenderSystem.getModelViewStack();
        boolean bl = scaled = scale != 1.0;
        if (scaled) {
            if (scale != 0.0) {
                xOff = (int)((double)xOff * scale);
                yOff = (int)((double)yOff * scale);
            }
            global4fStack.pushMatrix();
            global4fStack.scale((float)scale, (float)scale, 1.0f);
            RenderSystem.applyModelViewMatrix();
        }
        double posX = xOff + 2;
        double posY = yOff + 2;
        posY = RenderUtils.getHudPosY((int)posY, yOff, contentHeight, scale, alignment);
        if (useStatusShift) {
            posY += (double)RenderUtils.getHudOffsetForPotions(alignment, scale, (Player)RenderUtils.mc().player);
        }
        for (String line : lines) {
            int width = fontRenderer.width(line);
            switch (alignment) {
                case TOP_RIGHT: 
                case BOTTOM_RIGHT: {
                    posX = (double)scaledWidth / scale - (double)width - (double)xOff - 2.0;
                    break;
                }
                case CENTER: {
                    posX = (double)scaledWidth / scale / 2.0 - (double)width / 2.0 - (double)xOff;
                    break;
                }
            }
            int x = (int)posX;
            int y = (int)posY;
            posY += (double)lineHeight;
            if (useBackground) {
                Objects.requireNonNull(fontRenderer);
                RenderUtils.drawRect(x - 2, y - 2, width + 2, 2 + 9, bgColor);
            }
            drawContext.drawString(fontRenderer, line, x, y, textColor, useShadow);
        }
        if (scaled) {
            global4fStack.popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
        return contentHeight + 4;
    }

    public static int getHudOffsetForPotions(HudAlignment alignment, double scale, Player player) {
        if (alignment == HudAlignment.TOP_RIGHT) {
            if (scale == 0.0) {
                return 0;
            }
            Collection effects = player.getActiveEffects();
            boolean hasTurtleHelmet = EntityUtils.hasTurtleHelmetEquipped(player);
            if (!effects.isEmpty()) {
                int y1 = 0;
                int y2 = 0;
                for (MobEffectInstance effectInstance : effects) {
                    MobEffect effect = (MobEffect)effectInstance.getEffect().value();
                    if (!effectInstance.isVisible() || !effectInstance.showIcon()) continue;
                    if (effect.isBeneficial()) {
                        y1 = 26;
                        continue;
                    }
                    y2 = 52;
                    break;
                }
                if (hasTurtleHelmet && y1 == 0) {
                    y1 = 26;
                }
                return (int)((double)Math.max(y1, y2) / scale);
            }
            if (hasTurtleHelmet) {
                return (int)(26.0 / scale);
            }
        }
        return 0;
    }

    public static int getHudPosY(int yOrig, int yOffset, int contentHeight, double scale, HudAlignment alignment) {
        int scaledHeight = GuiUtils.getScaledWindowHeight();
        int posY = yOrig;
        switch (alignment) {
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: {
                posY = (int)((double)scaledHeight / scale - (double)contentHeight - (double)yOffset);
                break;
            }
            case CENTER: {
                posY = (int)((double)scaledHeight / scale / 2.0 - (double)contentHeight / 2.0 + (double)yOffset);
                break;
            }
        }
        return posY;
    }

    public static void drawBlockBoundingBoxSidesBatchedQuads(BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        float minX = (float)((double)pos.getX() - expand);
        float minY = (float)((double)pos.getY() - expand);
        float minZ = (float)((double)pos.getZ() - expand);
        float maxX = (float)((double)pos.getX() + expand + 1.0);
        float maxY = (float)((double)pos.getY() + expand + 1.0);
        float maxZ = (float)((double)pos.getZ() + expand + 1.0);
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines(pos, Vec3.ZERO, color, expand, buffer);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(BlockPos pos, Vec3 cameraPos, Color4f color, double expand, BufferBuilder buffer) {
        float minX = (float)((double)pos.getX() - expand - cameraPos.x);
        float minY = (float)((double)pos.getY() - expand - cameraPos.y);
        float minZ = (float)((double)pos.getZ() - expand - cameraPos.z);
        float maxX = (float)((double)pos.getX() + expand - cameraPos.x + 1.0);
        float maxY = (float)((double)pos.getY() + expand - cameraPos.y + 1.0);
        float maxZ = (float)((double)pos.getZ() + expand - cameraPos.z + 1.0);
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBoxAllSidesBatchedQuads(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color, BufferBuilder buffer) {
        RenderUtils.drawBoxHorizontalSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxTopBatchedQuads(minX, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxBottomBatchedQuads(minX, minY, minZ, maxX, maxZ, color, buffer);
    }

    public static void drawBoxWithEdgesBatched(BlockPos posMin, BlockPos posMax, Color4f colorLines, Color4f colorSides, BufferBuilder bufferQuads, BufferBuilder bufferLines) {
        RenderUtils.drawBoxWithEdgesBatched(posMin, posMax, Vec3.ZERO, colorLines, colorSides, bufferQuads, bufferLines);
    }

    public static void drawBoxWithEdgesBatched(BlockPos posMin, BlockPos posMax, Vec3 cameraPos, Color4f colorLines, Color4f colorSides, BufferBuilder bufferQuads, BufferBuilder bufferLines) {
        float x1 = (float)((double)posMin.getX() - cameraPos.x);
        float y1 = (float)((double)posMin.getY() - cameraPos.y);
        float z1 = (float)((double)posMin.getZ() - cameraPos.z);
        float x2 = (float)((double)(posMax.getX() + 1) - cameraPos.x);
        float y2 = (float)((double)(posMax.getY() + 1) - cameraPos.y);
        float z2 = (float)((double)(posMax.getZ() + 1) - cameraPos.z);
        RenderUtils.drawBoxAllSidesBatchedQuads(x1, y1, z1, x2, y2, z2, colorSides, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(x1, y1, z1, x2, y2, z2, colorLines, bufferLines);
    }

    public static void drawBoxHorizontalSidesBatchedQuads(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color, BufferBuilder buffer) {
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
    }

    public static void drawBoxTopBatchedQuads(float minX, float minZ, float maxX, float maxY, float maxZ, Color4f color, BufferBuilder buffer) {
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
    }

    public static void drawBoxBottomBatchedQuads(float minX, float minY, float minZ, float maxX, float maxZ, Color4f color, BufferBuilder buffer) {
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
    }

    public static void drawBoxAllEdgesBatchedLines(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color, BufferBuilder buffer) {
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
    }

    public static void drawBox(IntBoundingBox bb, Vec3 cameraPos, Color4f color, BufferBuilder bufferQuads, BufferBuilder bufferLines) {
        float minX = (float)((double)bb.minX - cameraPos.x);
        float minY = (float)((double)bb.minY - cameraPos.y);
        float minZ = (float)((double)bb.minZ - cameraPos.z);
        float maxX = (float)((double)(bb.maxX + 1) - cameraPos.x);
        float maxY = (float)((double)(bb.maxY + 1) - cameraPos.y);
        float maxZ = (float)((double)(bb.maxZ + 1) - cameraPos.z);
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, bufferLines);
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float scale) {
        Entity entity = RenderUtils.mc().getCameraEntity();
        if (entity != null) {
            RenderUtils.drawTextPlate(text, x, y, z, entity.getYRot(), entity.getXRot(), scale, -1, 0x40000000, true);
        }
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float yaw, float pitch, float scale, int textColor, int bgColor, boolean disableDepth) {
        Vec3 cameraPos = RenderUtils.mc().gameRenderer.getMainCamera().getPosition();
        double cx = cameraPos.x;
        double cy = cameraPos.y;
        double cz = cameraPos.z;
        Font textRenderer = RenderUtils.mc().font;
        Matrix4fStack global4fStack = RenderSystem.getModelViewStack();
        global4fStack.pushMatrix();
        global4fStack.translate((float)(x - cx), (float)(y - cy), (float)(z - cz));
        global4fStack.rotateYXZ(-yaw * ((float)Math.PI / 180), pitch * ((float)Math.PI / 180), 0.0f);
        global4fStack.scale(-scale, -scale, scale);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableCull();
        RenderUtils.setupBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        int maxLineLen = 0;
        for (String line : text) {
            maxLineLen = Math.max(maxLineLen, textRenderer.width(line));
        }
        int strLenHalf = maxLineLen / 2;
        Objects.requireNonNull(textRenderer);
        int textHeight = 9 * text.size() - 1;
        int bga = bgColor >>> 24 & 0xFF;
        int bgr = bgColor >>> 16 & 0xFF;
        int bgg = bgColor >>> 8 & 0xFF;
        int bgb = bgColor & 0xFF;
        if (disableDepth) {
            RenderSystem.disableDepthTest();
        }
        buffer.addVertex((float)(-strLenHalf - 1), -1.0f, 0.0f).setColor(bgr, bgg, bgb, bga);
        buffer.addVertex((float)(-strLenHalf - 1), (float)textHeight, 0.0f).setColor(bgr, bgg, bgb, bga);
        buffer.addVertex((float)strLenHalf, (float)textHeight, 0.0f).setColor(bgr, bgg, bgb, bga);
        buffer.addVertex((float)strLenHalf, -1.0f, 0.0f).setColor(bgr, bgg, bgb, bga);
        try {
            MeshData builtBuffer = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int textY = 0;
        if (!disableDepth) {
            RenderSystem.enablePolygonOffset();
            RenderSystem.polygonOffset((float)-0.6f, (float)-1.2f);
        }
        Matrix4f modelMatrix = new Matrix4f();
        modelMatrix.identity();
        ByteBufferBuilder allocator = new ByteBufferBuilder(1536);
        for (String line : text) {
            MultiBufferSource.BufferSource immediate;
            if (disableDepth) {
                RenderSystem.disableDepthTest();
                immediate = MultiBufferSource.immediate((ByteBufferBuilder)allocator);
                textRenderer.drawInBatch(line, (float)(-strLenHalf), (float)textY, 0x20000000 | textColor & 0xFFFFFF, false, modelMatrix, (MultiBufferSource)immediate, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                immediate.endBatch();
                RenderSystem.enableDepthTest();
            }
            immediate = MultiBufferSource.immediate((ByteBufferBuilder)allocator);
            textRenderer.drawInBatch(line, (float)(-strLenHalf), (float)textY, textColor, false, modelMatrix, (MultiBufferSource)immediate, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
            immediate.endBatch();
            Objects.requireNonNull(textRenderer);
            textY += 9;
        }
        allocator.close();
        if (!disableDepth) {
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
        }
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableCull();
        global4fStack.popMatrix();
    }

    public static void renderBlockTargetingOverlay(Entity entity, BlockPos pos, Direction side, Vec3 hitVec, Color4f color, Matrix4f posMatrix, Minecraft mc) {
        MeshData builtBuffer;
        Direction playerFacing = entity.getDirection();
        PositionUtils.HitPart part = PositionUtils.getHitPart(side, playerFacing, pos, hitVec);
        Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
        double x = (double)pos.getX() + 0.5 - cameraPos.x;
        double y = (double)pos.getY() + 0.5 - cameraPos.y;
        double z = (double)pos.getZ() + 0.5 - cameraPos.z;
        Matrix4fStack global4fStack = RenderSystem.getModelViewStack();
        global4fStack.pushMatrix();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing, global4fStack);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        int quadAlpha = 45;
        int hr = (int)(color.r * 255.0f);
        int hg = (int)(color.g * 255.0f);
        int hb = (int)(color.b * 255.0f);
        int ha = (int)(color.a * 255.0f);
        int c = 255;
        buffer.addVertex((float)(x - 0.5), (float)(y - 0.5), (float)z).setColor(c, c, c, quadAlpha);
        buffer.addVertex((float)(x + 0.5), (float)(y - 0.5), (float)z).setColor(c, c, c, quadAlpha);
        buffer.addVertex((float)(x + 0.5), (float)(y + 0.5), (float)z).setColor(c, c, c, quadAlpha);
        buffer.addVertex((float)(x - 0.5), (float)(y + 0.5), (float)z).setColor(c, c, c, quadAlpha);
        switch (part) {
            case CENTER: {
                buffer.addVertex((float)(x - 0.25), (float)(y - 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x + 0.25), (float)(y - 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x + 0.25), (float)(y + 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x - 0.25), (float)(y + 0.25), (float)z).setColor(hr, hg, hb, ha);
                break;
            }
            case LEFT: {
                buffer.addVertex((float)(x - 0.5), (float)(y - 0.5), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x - 0.25), (float)(y - 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x - 0.25), (float)(y + 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x - 0.5), (float)(y + 0.5), (float)z).setColor(hr, hg, hb, ha);
                break;
            }
            case RIGHT: {
                buffer.addVertex((float)(x + 0.5), (float)(y - 0.5), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x + 0.25), (float)(y - 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x + 0.25), (float)(y + 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x + 0.5), (float)(y + 0.5), (float)z).setColor(hr, hg, hb, ha);
                break;
            }
            case TOP: {
                buffer.addVertex((float)(x - 0.5), (float)(y + 0.5), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x - 0.25), (float)(y + 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x + 0.25), (float)(y + 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x + 0.5), (float)(y + 0.5), (float)z).setColor(hr, hg, hb, ha);
                break;
            }
            case BOTTOM: {
                buffer.addVertex((float)(x - 0.5), (float)(y - 0.5), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x - 0.25), (float)(y - 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x + 0.25), (float)(y - 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x + 0.5), (float)(y - 0.5), (float)z).setColor(hr, hg, hb, ha);
                break;
            }
        }
        try {
            builtBuffer = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RenderSystem.lineWidth((float)1.6f);
        buffer = tessellator.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex((float)(x - 0.25), (float)(y - 0.25), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x + 0.25), (float)(y - 0.25), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x + 0.25), (float)(y + 0.25), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x - 0.25), (float)(y + 0.25), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x - 0.25), (float)(y - 0.25), (float)z).setColor(c, c, c, c);
        try {
            builtBuffer = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        buffer = tessellator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex((float)(x - 0.5), (float)(y - 0.5), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x - 0.25), (float)(y - 0.25), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x - 0.5), (float)(y + 0.5), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x - 0.25), (float)(y + 0.25), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x + 0.5), (float)(y - 0.5), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x + 0.25), (float)(y - 0.25), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x + 0.5), (float)(y + 0.5), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x + 0.25), (float)(y + 0.25), (float)z).setColor(c, c, c, c);
        try {
            builtBuffer = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        global4fStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    public static void renderBlockTargetingOverlaySimple(Entity entity, BlockPos pos, Direction side, Color4f color, Matrix4f posMatrix, Minecraft mc) {
        MeshData builtBuffer;
        Direction playerFacing = entity.getDirection();
        Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
        double x = (double)pos.getX() + 0.5 - cameraPos.x;
        double y = (double)pos.getY() + 0.5 - cameraPos.y;
        double z = (double)pos.getZ() + 0.5 - cameraPos.z;
        Matrix4fStack global4fStack = RenderSystem.getModelViewStack();
        global4fStack.pushMatrix();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing, global4fStack);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        int a = (int)(color.a * 255.0f);
        int r = (int)(color.r * 255.0f);
        int g = (int)(color.g * 255.0f);
        int b = (int)(color.b * 255.0f);
        int c = 255;
        buffer.addVertex((float)(x - 0.5), (float)(y - 0.5), (float)z).setColor(r, g, b, a);
        buffer.addVertex((float)(x + 0.5), (float)(y - 0.5), (float)z).setColor(r, g, b, a);
        buffer.addVertex((float)(x + 0.5), (float)(y + 0.5), (float)z).setColor(r, g, b, a);
        buffer.addVertex((float)(x - 0.5), (float)(y + 0.5), (float)z).setColor(r, g, b, a);
        try {
            builtBuffer = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RenderSystem.lineWidth((float)1.6f);
        buffer = tessellator.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex((float)(x - 0.375), (float)(y - 0.375), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x + 0.375), (float)(y - 0.375), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x + 0.375), (float)(y + 0.375), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x - 0.375), (float)(y + 0.375), (float)z).setColor(c, c, c, c);
        try {
            builtBuffer = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        global4fStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    private static void blockTargetingOverlayTranslations(double x, double y, double z, Direction side, Direction playerFacing, Matrix4fStack matrix4fStack) {
        matrix4fStack.translate((float)x, (float)y, (float)z);
        switch (side) {
            case DOWN: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(180.0f - playerFacing.toYRot()));
                matrix4fStack.rotateX(RenderUtils.matrix4fRotateFix(90.0f));
                break;
            }
            case UP: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(180.0f - playerFacing.toYRot()));
                matrix4fStack.rotateX(RenderUtils.matrix4fRotateFix(-90.0f));
                break;
            }
            case NORTH: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(180.0f));
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(-90.0f));
                break;
            }
            case EAST: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(90.0f));
            }
        }
        matrix4fStack.translate((float)(-x), (float)(-y), (float)(-z + 0.51));
    }

    public static void renderMapPreview(ItemStack stack, int x, int y, int dimensions) {
        RenderUtils.renderMapPreview(stack, x, y, dimensions, true);
    }

    public static void renderMapPreview(ItemStack stack, int x, int y, int dimensions, boolean requireShift) {
        if (stack.getItem() instanceof MapItem && (!requireShift || GuiBase.isShiftDown())) {
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            int y1 = y - dimensions - 20;
            int y2 = y1 + dimensions;
            int x1 = x + 8;
            int x2 = x1 + dimensions;
            int z = 300;
            MapItemSavedData mapState = MapItem.getSavedData((ItemStack)stack, (Level)RenderUtils.mc().level);
            DataComponentMap data = stack.getComponents();
            MapId mapId = (MapId)data.get(DataComponents.MAP_ID);
            ResourceLocation bgTexture = mapState == null ? TEXTURE_MAP_BACKGROUND : TEXTURE_MAP_BACKGROUND_CHECKERBOARD;
            RenderUtils.bindTexture(bgTexture);
            RenderUtils.setupBlend();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.applyModelViewMatrix();
            Tesselator tessellator = Tesselator.getInstance();
            BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            buffer.addVertex((float)x1, (float)y2, (float)z).setUv(0.0f, 1.0f);
            buffer.addVertex((float)x2, (float)y2, (float)z).setUv(1.0f, 1.0f);
            buffer.addVertex((float)x2, (float)y1, (float)z).setUv(1.0f, 0.0f);
            buffer.addVertex((float)x1, (float)y1, (float)z).setUv(0.0f, 0.0f);
            try {
                MeshData builtBuffer = buffer.buildOrThrow();
                BufferUploader.drawWithShader((MeshData)builtBuffer);
                builtBuffer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            RenderSystem.disableBlend();
            if (mapState != null) {
                x1 += 8;
                y1 += 8;
                z = 310;
                ByteBufferBuilder allocator = new ByteBufferBuilder(1536);
                MultiBufferSource.BufferSource consumer = MultiBufferSource.immediate((ByteBufferBuilder)allocator);
                double scale = (double)(dimensions - 16) / 128.0;
                PoseStack matrixStack = new PoseStack();
                matrixStack.pushPose();
                matrixStack.translate((float)x1, (float)y1, (float)z);
                matrixStack.scale((float)scale, (float)scale, 0.0f);
                RenderUtils.mc().gameRenderer.getMapRenderer().render(matrixStack, (MultiBufferSource)consumer, mapId, mapState, false, 0xF000F0);
                consumer.endBatch();
                matrixStack.popPose();
                allocator.close();
            }
        }
    }

    public static void renderShulkerBoxPreview(ItemStack stack, int baseX, int baseY, boolean useBgColors, GuiGraphics drawContext) {
        if (stack.getComponents().has(DataComponents.CONTAINER)) {
            NonNullList<ItemStack> items = InventoryUtils.getStoredItems(stack, -1);
            if (items.isEmpty()) {
                return;
            }
            CompoundTag nbt = InventoryUtils.getStoredBlockEntityNbt(stack);
            HashSet<Integer> lockedSlots = new HashSet();
            Container inv = InventoryUtils.getAsInventory(items);
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(stack);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, items.size());
            int screenWidth = GuiUtils.getScaledWindowWidth();
            int screenHeight = GuiUtils.getScaledWindowHeight();
            int height = props.height + 18;
            int x = Mth.clamp((int)(baseX + 8), (int)0, (int)(screenWidth - props.width));
            int y = Mth.clamp((int)(baseY - height), (int)0, (int)(screenHeight - height));
            if (stack.getItem() instanceof BlockItem && ((BlockItem)stack.getItem()).getBlock() instanceof ShulkerBoxBlock) {
                RenderUtils.setShulkerboxBackgroundTintColor((ShulkerBoxBlock)((BlockItem)stack.getItem()).getBlock(), useBgColors);
            } else {
                RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            }
            RenderUtils.disableDiffuseLighting();
            Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
            matrix4fStack.pushMatrix();
            matrix4fStack.translate(0.0f, 0.0f, 500.0f);
            RenderSystem.applyModelViewMatrix();
            InventoryOverlay.renderInventoryBackground(type, x, y, props.slotsPerRow, props.totalSlots, RenderUtils.mc());
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            RenderUtils.enableDiffuseLightingGui3D();
            if (type == InventoryOverlay.InventoryRenderType.CRAFTER && !nbt.isEmpty()) {
                lockedSlots = NbtBlockUtils.getDisabledSlotsFromNbt(nbt);
                InventoryOverlay.renderInventoryStacks(type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, -1, lockedSlots, RenderUtils.mc(), drawContext);
            } else {
                InventoryOverlay.renderInventoryStacks(type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, -1, RenderUtils.mc(), drawContext);
            }
            matrix4fStack.popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static void renderBundlePreview(ItemStack stack, int baseX, int baseY, boolean useBgColors, GuiGraphics drawContext) {
        RenderUtils.renderBundlePreview(stack, baseX, baseY, 9, useBgColors, drawContext);
    }

    public static void renderBundlePreview(ItemStack stack, int baseX, int baseY, int slotsPerRow, boolean useBgColors, GuiGraphics drawContext) {
        if (stack.getComponents().has(DataComponents.BUNDLE_CONTENTS)) {
            int count = InventoryUtils.bundleCountItems(stack);
            NonNullList<ItemStack> items = InventoryUtils.getBundleItems(stack, count);
            int n = slotsPerRow = slotsPerRow != 9 ? MathUtils.clamp(slotsPerRow, 6, 9) : 9;
            if (items.isEmpty()) {
                return;
            }
            Container inv = InventoryUtils.getAsInventory(items);
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(stack);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, count, slotsPerRow);
            int screenWidth = GuiUtils.getScaledWindowWidth();
            int screenHeight = GuiUtils.getScaledWindowHeight();
            int height = props.height + 18;
            int x = Mth.clamp((int)(baseX + 8), (int)0, (int)(screenWidth - props.width));
            int y = Mth.clamp((int)(baseY - height), (int)0, (int)(screenHeight - height));
            RenderUtils.setBundleBackgroundTintColor(stack, useBgColors);
            RenderUtils.disableDiffuseLighting();
            Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
            matrix4fStack.pushMatrix();
            matrix4fStack.translate(0.0f, 0.0f, 500.0f);
            InventoryOverlay.renderInventoryBackground(type, x, y, props.slotsPerRow, props.totalSlots, RenderUtils.mc());
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            RenderUtils.enableDiffuseLightingGui3D();
            InventoryOverlay.renderInventoryStacks(type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, count, RenderUtils.mc(), drawContext);
            matrix4fStack.popMatrix();
        }
    }

    public static void renderNbtItemsPreview(ItemStack stackIn, @Nonnull CompoundTag itemsTag, int baseX, int baseY, boolean useBgColors, GuiGraphics drawContext) {
        if (InventoryUtils.hasNbtItems(itemsTag)) {
            if (RenderUtils.mc().level == null) {
                return;
            }
            NonNullList<ItemStack> items = InventoryUtils.getNbtItems(itemsTag, -1, (HolderLookup.Provider)RenderUtils.mc().level.registryAccess());
            if (items.size() == 0) {
                return;
            }
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(stackIn);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, items.size());
            int screenWidth = GuiUtils.getScaledWindowWidth();
            int screenHeight = GuiUtils.getScaledWindowHeight();
            int height = props.height + 18;
            int x = Mth.clamp((int)(baseX + 8), (int)0, (int)(screenWidth - props.width));
            int y = Mth.clamp((int)(baseY - height), (int)0, (int)(screenHeight - height));
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            RenderUtils.disableDiffuseLighting();
            Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
            matrix4fStack.pushMatrix();
            matrix4fStack.translate(0.0f, 0.0f, 500.0f);
            RenderSystem.applyModelViewMatrix();
            InventoryOverlay.renderInventoryBackground(type, x, y, props.slotsPerRow, items.size(), RenderUtils.mc());
            RenderUtils.enableDiffuseLightingGui3D();
            Container inv = InventoryUtils.getAsInventory(items);
            InventoryOverlay.renderInventoryStacks(type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, -1, RenderUtils.mc(), drawContext);
            matrix4fStack.popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static void setShulkerboxBackgroundTintColor(@Nullable ShulkerBoxBlock block, boolean useBgColors) {
        if (block != null && useBgColors) {
            DyeColor dye = block.getColor() != null ? block.getColor() : DyeColor.PURPLE;
            float[] colors = RenderUtils.getColorComponents(dye.getTextureDiffuseColor());
            RenderUtils.color(colors[0], colors[1], colors[2], 1.0f);
        } else {
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static float[] getColorComponents(int color) {
        int j = (color & 0xFF0000) >> 16;
        int k = (color & 0xFF00) >> 8;
        int l = (color & 0xFF) >> 0;
        return new float[]{(float)j / 255.0f, (float)k / 255.0f, (float)l / 255.0f};
    }

    public static void setBundleBackgroundTintColor(ItemStack bundle, boolean useBgColors) {
        DyeColor dye;
        if (useBgColors && (dye = RenderUtils.getBundleColor(bundle)) != null) {
            float[] colors = RenderUtils.getColorComponents(dye.getTextureDiffuseColor());
            RenderUtils.color(colors[0], colors[1], colors[2], 1.0f);
            return;
        }
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static DyeColor getBundleColor(ItemStack bundle) {
        Item item = bundle.getItem();
        if (item == null) {
            return null;
        }
        return DyeColor.BROWN;
    }

    public static void setVillagerBackgroundTintColor(VillagerData data, boolean useBgColors) {
        if (useBgColors) {
            VillagerProfession profession = data != null ? data.getProfession() : null;
            RenderUtils.setVillagerBackgroundTintColor(profession, useBgColors);
        }
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void setVillagerBackgroundTintColor(VillagerProfession profession, boolean useBgColors) {
        DyeColor dye;
        if (useBgColors && (dye = RenderUtils.getVillagerColor(profession)) != null) {
            float[] colors = RenderUtils.getColorComponents(dye.getTextureDiffuseColor());
            RenderUtils.color(colors[0], colors[1], colors[2], 1.0f);
            return;
        }
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static DyeColor getVillagerColor(VillagerProfession profession) {
        if (profession == null) {
            return null;
        }
        if (profession.equals((Object)VillagerProfession.NONE)) {
            return DyeColor.BLUE;
        }
        if (profession.equals((Object)VillagerProfession.ARMORER)) {
            return DyeColor.GRAY;
        }
        if (profession.equals((Object)VillagerProfession.BUTCHER)) {
            return DyeColor.PINK;
        }
        if (profession.equals((Object)VillagerProfession.CARTOGRAPHER)) {
            return DyeColor.LIGHT_BLUE;
        }
        if (profession.equals((Object)VillagerProfession.CLERIC)) {
            return DyeColor.PURPLE;
        }
        if (profession.equals((Object)VillagerProfession.FARMER)) {
            return DyeColor.YELLOW;
        }
        if (profession.equals((Object)VillagerProfession.FISHERMAN)) {
            return DyeColor.CYAN;
        }
        if (profession.equals((Object)VillagerProfession.FLETCHER)) {
            return DyeColor.ORANGE;
        }
        if (profession.equals((Object)VillagerProfession.LEATHERWORKER)) {
            return DyeColor.BROWN;
        }
        if (profession.equals((Object)VillagerProfession.LIBRARIAN)) {
            return DyeColor.RED;
        }
        if (profession.equals((Object)VillagerProfession.MASON)) {
            return DyeColor.MAGENTA;
        }
        if (profession.equals((Object)VillagerProfession.NITWIT)) {
            return DyeColor.GREEN;
        }
        if (profession.equals((Object)VillagerProfession.SHEPHERD)) {
            return DyeColor.WHITE;
        }
        if (profession.equals((Object)VillagerProfession.TOOLSMITH)) {
            return DyeColor.LIGHT_GRAY;
        }
        if (profession.equals((Object)VillagerProfession.WEAPONSMITH)) {
            return DyeColor.BLACK;
        }
        return DyeColor.LIME;
    }

    public static void renderModelInGui(int x, int y, BakedModel model, BlockState state, float zLevel) {
        if (state.getBlock() == Blocks.AIR) {
            return;
        }
        Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
        matrix4fStack.pushMatrix();
        RenderUtils.bindTexture(InventoryMenu.BLOCK_ATLAS);
        RenderUtils.mc().getTextureManager().getTexture(InventoryMenu.BLOCK_ATLAS).setFilter(false, false);
        RenderSystem.enableBlend();
        RenderUtils.setupBlendSimple();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderUtils.setupGuiTransform(x, y, model.isGui3d(), zLevel);
        matrix4fStack.rotateX(RenderUtils.matrix4fRotateFix(30.0f));
        matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(225.0f));
        matrix4fStack.scale(0.625f, 0.625f, 0.625f);
        RenderUtils.renderModel(model, state);
        matrix4fStack.popMatrix();
    }

    public static void setupGuiTransform(int xPosition, int yPosition, boolean isGui3d, float zLevel) {
        RenderUtils.setupGuiTransform(RenderSystem.getModelViewStack(), xPosition, yPosition, zLevel);
    }

    public static void setupGuiTransform(Matrix4fStack matrix4fStack, int xPosition, int yPosition, float zLevel) {
        matrix4fStack.translate((float)((double)xPosition + 8.0), (float)((double)yPosition + 8.0), (float)((double)zLevel + 100.0));
        matrix4fStack.scale(16.0f, -16.0f, 16.0f);
    }

    private static void renderModel(BakedModel model, BlockState state) {
        Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
        matrix4fStack.pushMatrix();
        matrix4fStack.translate(-0.5f, -0.5f, -0.5f);
        int color = -1;
        if (!model.isCustomRenderer()) {
            RenderSystem.setShader(GameRenderer::getRendertypeSolidShader);
            RenderSystem.applyModelViewMatrix();
            Tesselator tessellator = Tesselator.getInstance();
            BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
            for (Direction face : Direction.values()) {
                RAND.setSeed(0L);
                RenderUtils.renderQuads(bufferbuilder, model.getQuads(state, face, (RandomSource)RAND), state, color);
            }
            RAND.setSeed(0L);
            RenderUtils.renderQuads(bufferbuilder, model.getQuads(state, null, (RandomSource)RAND), state, color);
            try {
                MeshData builtBuffer = bufferbuilder.buildOrThrow();
                BufferUploader.drawWithShader((MeshData)builtBuffer);
                builtBuffer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        matrix4fStack.popMatrix();
    }

    private static void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, BlockState state, int color) {
        int quadCount = quads.size();
        for (int i = 0; i < quadCount; ++i) {
            BakedQuad quad = quads.get(i);
            RenderUtils.renderQuad(renderer, quad, state, -1);
        }
    }

    private static void renderQuad(BufferBuilder buffer, BakedQuad quad, BlockState state, int color) {
    }

    private static Minecraft mc() {
        return Minecraft.getInstance();
    }

    public static float matrix4fRotateFix(float ang) {
        return ang * ((float)Math.PI / 180);
    }
}

