/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;

public enum ActiveMode implements IConfigOptionListEntry,
StringRepresentable
{
    NEVER("never", "malilib.label.active_mode.never"),
    WITH_KEY("with_key", "malilib.label.active_mode.with_key"),
    ALWAYS("always", "malilib.label.active_mode.always");

    public static final StringRepresentable.EnumCodec<ActiveMode> CODEC;
    public static final StreamCodec<ByteBuf, ActiveMode> PACKET_CODEC;
    public static final ImmutableList<ActiveMode> VALUES;
    private final String configString;
    private final String translationKey;

    private ActiveMode(String configString, String translationKey) {
        this.configString = configString;
        this.translationKey = translationKey;
    }

    @Override
    public String getStringValue() {
        return this.configString;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.translate(this.translationKey, new Object[0]);
    }

    public String getSerializedName() {
        return this.configString;
    }

    @Override
    public IConfigOptionListEntry cycle(boolean forward) {
        int id = this.ordinal();
        if (forward) {
            if (++id >= ActiveMode.values().length) {
                id = 0;
            }
        } else if (--id < 0) {
            id = ActiveMode.values().length - 1;
        }
        return ActiveMode.values()[id % ActiveMode.values().length];
    }

    @Override
    public ActiveMode fromString(String name) {
        return ActiveMode.fromStringStatic(name);
    }

    public static ActiveMode fromStringStatic(String name) {
        for (ActiveMode mode : ActiveMode.values()) {
            if (!mode.configString.equalsIgnoreCase(name)) continue;
            return mode;
        }
        return NEVER;
    }

    static {
        CODEC = StringRepresentable.fromEnum(ActiveMode::values);
        PACKET_CODEC = ByteBufCodecs.STRING_UTF8.map(ActiveMode::fromStringStatic, ActiveMode::getSerializedName);
        VALUES = ImmutableList.copyOf((Object[])ActiveMode.values());
    }
}

