/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class ListUtils {
    public static <T> void extractEntriesToSecondList(List<T> listFrom, List<T> listTo, Predicate<T> filter, boolean removeMatched) {
        ArrayList<T> newList = new ArrayList<T>();
        for (T entry : listFrom) {
            boolean matches = filter.test(entry);
            if (matches) {
                listTo.add(entry);
                continue;
            }
            if (!removeMatched) continue;
            newList.add(entry);
        }
        if (removeMatched) {
            listFrom.clear();
            listFrom.addAll(newList);
        }
    }

    public static <T> T getNextEntry(List<T> list, T currentValue, boolean reverse) {
        return (T)ListUtils.getNextEntry(list, currentValue, reverse, v -> true);
    }

    public static <T> T getNextEntry(List<T> list, T currentValue, boolean reverse, Predicate<T> predicate) {
        int newIndex;
        int size = list.size();
        if (size > 1 && (newIndex = list.indexOf(currentValue)) != -1) {
            int maxIndex = size - 1;
            int increment = reverse ? -1 : 1;
            for (int i = 0; i < size; ++i) {
                if ((newIndex += increment) >= size) {
                    newIndex = 0;
                } else if (newIndex < 0) {
                    newIndex = maxIndex;
                }
                T tmp = list.get(newIndex);
                if (!predicate.test(tmp)) continue;
                return tmp;
            }
        }
        return currentValue;
    }

    public static <T> ImmutableList<T> getAppendedList(Collection<? extends T> originalList, Collection<? extends T> additionalEntries) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(originalList);
        builder.addAll(additionalEntries);
        return builder.build();
    }

    public static <T> ImmutableList<T> getAppendedList(Collection<? extends T> originalList, T newEntry) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(originalList);
        builder.add(newEntry);
        return builder.build();
    }

    public static <T> ImmutableList<T> getPrependedList(T newEntry, Collection<? extends T> originalList) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(newEntry);
        builder.addAll(originalList);
        return builder.build();
    }

    public static <T> ImmutableList<T> replaceOrAddValue(Collection<? extends T> originalList, T oldValue, T newValue, boolean replaceInPlace) {
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean replaced = false;
        for (T value : originalList) {
            if (!value.equals(oldValue)) {
                builder.add(value);
                continue;
            }
            if (!replaceInPlace) continue;
            builder.add(newValue);
            replaced = true;
        }
        if (!replaceInPlace || !replaced) {
            builder.add(newValue);
        }
        return builder.build();
    }

    public static <T> boolean containsAny(Collection<T> hayStack, Collection<T> needles) {
        for (T needle : needles) {
            if (!hayStack.contains(needle)) continue;
            return true;
        }
        return false;
    }
}

