/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.block.roof;

import com.mamailes.merrymaking.init.MMBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.Tags;

public class RoofSlabBlock
extends SlabBlock {
    public RoofSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean isRandomlyTicking(BlockState pState) {
        return true;
    }

    protected void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pLevel.isRainingAt(pPos.above())) {
            this.handlePrecipitation(pState, (Level)pLevel, pPos, Biome.Precipitation.SNOW);
        }
        super.randomTick(pState, pLevel, pPos, pRandom);
    }

    protected static boolean shouldHandlePrecipitation(Level pLevel, Biome.Precipitation pPrecipitation) {
        return pLevel.getRandom().nextFloat() < 0.05f;
    }

    public void handlePrecipitation(BlockState state, Level pLevel, BlockPos pPos, Biome.Precipitation pPrecipitation) {
        if (RoofSlabBlock.shouldHandlePrecipitation(pLevel, pPrecipitation) && pPrecipitation == Biome.Precipitation.SNOW && pLevel.getBiome(pPos).is(Tags.Biomes.IS_COLD)) {
            if (state.getBlock() == MMBlocks.ACACIA_ROOF_SLAB.get()) {
                pLevel.setBlockAndUpdate(pPos, (BlockState)((Block)MMBlocks.ACACIA_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))));
                pLevel.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pPos);
            }
            if (state.getBlock() == MMBlocks.BIRCH_ROOF_SLAB.get()) {
                pLevel.setBlockAndUpdate(pPos, (BlockState)((Block)MMBlocks.BIRCH_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))));
                pLevel.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pPos);
            }
            if (state.getBlock() == MMBlocks.OAK_ROOF_SLAB.get()) {
                pLevel.setBlockAndUpdate(pPos, (BlockState)((Block)MMBlocks.OAK_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))));
                pLevel.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pPos);
            }
            if (state.getBlock() == MMBlocks.SPRUCE_ROOF_SLAB.get()) {
                pLevel.setBlockAndUpdate(pPos, (BlockState)((Block)MMBlocks.SPRUCE_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))));
                pLevel.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pPos);
            }
            if (state.getBlock() == MMBlocks.DARK_OAK_ROOF_SLAB.get()) {
                pLevel.setBlockAndUpdate(pPos, (BlockState)((Block)MMBlocks.DARK_OAK_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))));
                pLevel.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pPos);
            }
            if (state.getBlock() == MMBlocks.JUNGLE_ROOF_SLAB.get()) {
                pLevel.setBlockAndUpdate(pPos, (BlockState)((Block)MMBlocks.JUNGLE_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))));
                pLevel.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pPos);
            }
            if (state.getBlock() == MMBlocks.WARPED_ROOF_SLAB.get()) {
                pLevel.setBlockAndUpdate(pPos, (BlockState)((Block)MMBlocks.WARPED_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))));
                pLevel.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pPos);
            }
            if (state.getBlock() == MMBlocks.CRIMSON_ROOF_SLAB.get()) {
                pLevel.setBlockAndUpdate(pPos, (BlockState)((Block)MMBlocks.CRIMSON_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))));
                pLevel.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pPos);
            }
            if (state.getBlock() == MMBlocks.MANGROVE_ROOF_SLAB.get()) {
                pLevel.setBlockAndUpdate(pPos, (BlockState)((Block)MMBlocks.MANGROVE_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))));
                pLevel.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pPos);
            }
            if (state.getBlock() == MMBlocks.CHERRY_ROOF_SLAB.get()) {
                pLevel.setBlockAndUpdate(pPos, (BlockState)((Block)MMBlocks.CHERRY_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))));
                pLevel.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pPos);
            }
            if (state.getBlock() == MMBlocks.BAMBOO_ROOF_SLAB.get()) {
                pLevel.setBlockAndUpdate(pPos, (BlockState)((Block)MMBlocks.BAMBOO_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))));
                pLevel.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pPos);
            }
            if (state.getBlock() == MMBlocks.STONE_BRICK_ROOF_SLAB.get()) {
                pLevel.setBlockAndUpdate(pPos, (BlockState)((Block)MMBlocks.STONE_BRICK_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))));
                pLevel.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pPos);
            }
            if (state.getBlock() == MMBlocks.POLISHED_BLACKSTONE_BRICK_ROOF_SLAB.get()) {
                pLevel.setBlockAndUpdate(pPos, (BlockState)((Block)MMBlocks.POLISHED_BLACKSTONE_BRICK_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))));
                pLevel.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pPos);
            }
            if (state.getBlock() == MMBlocks.DEEPSLATE_BRICK_ROOF_SLAB.get()) {
                pLevel.setBlockAndUpdate(pPos, (BlockState)((Block)MMBlocks.DEEPSLATE_BRICK_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))));
                pLevel.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pPos);
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult pHitResult) {
        ItemStack snow = player.getItemInHand(hand);
        BlockState blockstate = level.getBlockState(pos);
        if (!level.isClientSide()) {
            if (snow.getItem() == Items.SNOWBALL && blockstate.getBlock() == MMBlocks.ACACIA_ROOF_SLAB.get()) {
                level.setBlock(pos, (BlockState)((Block)MMBlocks.ACACIA_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))), 3);
                snow.shrink(1);
            }
            if (snow.getItem() == Items.SNOWBALL && blockstate.getBlock() == MMBlocks.MANGROVE_ROOF_SLAB.get()) {
                level.setBlock(pos, (BlockState)((Block)MMBlocks.MANGROVE_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))), 3);
                snow.shrink(1);
            }
            if (snow.getItem() == Items.SNOWBALL && blockstate.getBlock() == MMBlocks.BIRCH_ROOF_SLAB.get()) {
                level.setBlock(pos, (BlockState)((Block)MMBlocks.BIRCH_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))), 3);
                snow.shrink(1);
            }
            if (snow.getItem() == Items.SNOWBALL && blockstate.getBlock() == MMBlocks.DARK_OAK_ROOF_SLAB.get()) {
                level.setBlock(pos, (BlockState)((Block)MMBlocks.DARK_OAK_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))), 3);
                snow.shrink(1);
            }
            if (snow.getItem() == Items.SNOWBALL && blockstate.getBlock() == MMBlocks.JUNGLE_ROOF_SLAB.get()) {
                level.setBlock(pos, (BlockState)((Block)MMBlocks.JUNGLE_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))), 3);
                snow.shrink(1);
            }
            if (snow.getItem() == Items.SNOWBALL && blockstate.getBlock() == MMBlocks.OAK_ROOF_SLAB.get()) {
                level.setBlock(pos, (BlockState)((Block)MMBlocks.OAK_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))), 3);
                snow.shrink(1);
            }
            if (snow.getItem() == Items.SNOWBALL && blockstate.getBlock() == MMBlocks.SPRUCE_ROOF_SLAB.get()) {
                level.setBlock(pos, (BlockState)((Block)MMBlocks.SPRUCE_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))), 3);
                snow.shrink(1);
            }
            if (snow.getItem() == Items.SNOWBALL && blockstate.getBlock() == MMBlocks.WARPED_ROOF_SLAB.get()) {
                level.setBlock(pos, (BlockState)((Block)MMBlocks.WARPED_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))), 3);
                snow.shrink(1);
            }
            if (snow.getItem() == Items.SNOWBALL && blockstate.getBlock() == MMBlocks.CRIMSON_ROOF_SLAB.get()) {
                level.setBlock(pos, (BlockState)((Block)MMBlocks.CRIMSON_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))), 3);
                snow.shrink(1);
            }
            if (snow.getItem() == Items.SNOWBALL && blockstate.getBlock() == MMBlocks.POLISHED_BLACKSTONE_BRICK_ROOF_SLAB.get()) {
                level.setBlock(pos, (BlockState)((Block)MMBlocks.POLISHED_BLACKSTONE_BRICK_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))), 3);
                snow.shrink(1);
            }
            if (snow.getItem() == Items.SNOWBALL && blockstate.getBlock() == MMBlocks.DEEPSLATE_BRICK_ROOF_SLAB.get()) {
                level.setBlock(pos, (BlockState)((Block)MMBlocks.DEEPSLATE_BRICK_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))), 3);
                snow.shrink(1);
            }
            if (snow.getItem() == Items.SNOWBALL && blockstate.getBlock() == MMBlocks.CHERRY_ROOF_SLAB.get()) {
                level.setBlock(pos, (BlockState)((Block)MMBlocks.CHERRY_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))), 3);
                snow.shrink(1);
            }
            if (snow.getItem() == Items.SNOWBALL && blockstate.getBlock() == MMBlocks.STONE_BRICK_ROOF_SLAB.get()) {
                level.setBlock(pos, (BlockState)((Block)MMBlocks.STONE_BRICK_SNOWY_SLAB.get()).defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE))), 3);
                snow.shrink(1);
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, pHitResult);
    }
}

