/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.block.tree;

import com.mamailes.merrymaking.block.tree.TopperBlock;
import com.mamailes.merrymaking.init.MMBlocks;
import com.mamailes.merrymaking.init.MMItems;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ChristmasTreeBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final IntegerProperty DECO = IntegerProperty.create((String)"deco", (int)0, (int)3);
    public static final BooleanProperty GARLAND = BooleanProperty.create((String)"garland");
    public static final IntegerProperty LIGHTS = IntegerProperty.create((String)"lights", (int)0, (int)3);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final IntegerProperty SECTION = IntegerProperty.create((String)"section", (int)0, (int)2);

    public ChristmasTreeBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DECO, (Comparable)Integer.valueOf(0))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)LIGHTS, (Comparable)Integer.valueOf(0))).setValue((Property)GARLAND, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_48946_, BlockPos p_48947_, CollisionContext p_48948_) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{DECO, GARLAND, LIGHTS, LIT, SECTION});
    }

    public static ToIntFunction<BlockState> litBlockEmission(int pLightValue) {
        return state -> (Boolean)state.getValue((Property)LIT) != false ? pLightValue : 0;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        level.setBlockAndUpdate(pos, (BlockState)this.defaultBlockState().setValue((Property)SECTION, (Comparable)Integer.valueOf(0)));
        level.setBlockAndUpdate(pos.above(), (BlockState)this.defaultBlockState().setValue((Property)SECTION, (Comparable)Integer.valueOf(1)));
        level.setBlockAndUpdate(pos.above(2), (BlockState)this.defaultBlockState().setValue((Property)SECTION, (Comparable)Integer.valueOf(2)));
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (!level.isClientSide) {
            if ((Integer)state.getValue((Property)LIGHTS) == 0) {
                if (heldItem.getItem() == ((Item)MMItems.TREE_LIGHTS_WHITE.get()).asItem()) {
                    level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)LIGHTS, (Comparable)Integer.valueOf(1))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
                    heldItem.shrink(1);
                    return ItemInteractionResult.CONSUME;
                }
                if (heldItem.getItem() == ((Item)MMItems.TREE_LIGHTS_MULTI.get()).asItem()) {
                    level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)LIGHTS, (Comparable)Integer.valueOf(2))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
                    heldItem.shrink(1);
                    return ItemInteractionResult.CONSUME;
                }
            }
            if ((Integer)state.getValue((Property)LIGHTS) == 1) {
                if (heldItem.getItem() == ((Item)MMItems.TREE_LIGHTS_MULTI.get()).asItem()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIGHTS, (Comparable)Integer.valueOf(2)));
                    heldItem.shrink(1);
                    ChristmasTreeBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)MMItems.TREE_LIGHTS_WHITE.get()));
                    return ItemInteractionResult.CONSUME;
                }
                if (heldItem.getItem() == ((Item)MMItems.TREE_LIGHTS_WHITE.get()).asItem()) {
                    return ItemInteractionResult.FAIL;
                }
            }
            if ((Integer)state.getValue((Property)LIGHTS) == 2) {
                if (heldItem.getItem() == ((Item)MMItems.TREE_LIGHTS_WHITE.get()).asItem()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIGHTS, (Comparable)Integer.valueOf(1)));
                    heldItem.shrink(1);
                    ChristmasTreeBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)MMItems.TREE_LIGHTS_MULTI.get()));
                    return ItemInteractionResult.CONSUME;
                }
                if (heldItem.getItem() == ((Item)MMItems.TREE_LIGHTS_MULTI.get()).asItem()) {
                    return ItemInteractionResult.FAIL;
                }
            }
            if ((Integer)state.getValue((Property)DECO) == 0) {
                if (heldItem.getItem() == MMItems.ORNAMENTS_WHITE.get()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DECO, (Comparable)Integer.valueOf(1)));
                    heldItem.shrink(1);
                    return ItemInteractionResult.CONSUME;
                }
                if (heldItem.getItem() == MMItems.ORNAMENTS.get()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DECO, (Comparable)Integer.valueOf(2)));
                    heldItem.shrink(1);
                    return ItemInteractionResult.CONSUME;
                }
            }
            if ((Integer)state.getValue((Property)DECO) == 1) {
                if (heldItem.getItem() == MMItems.ORNAMENTS.get()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DECO, (Comparable)Integer.valueOf(2)));
                    heldItem.shrink(1);
                    ChristmasTreeBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)MMItems.ORNAMENTS_WHITE.get()));
                    return ItemInteractionResult.CONSUME;
                }
                if (heldItem.getItem() == MMItems.ORNAMENTS_WHITE.get()) {
                    return ItemInteractionResult.FAIL;
                }
            }
            if ((Integer)state.getValue((Property)DECO) == 2 && heldItem.getItem() == MMItems.ORNAMENTS_WHITE.get()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DECO, (Comparable)Integer.valueOf(1)));
                heldItem.shrink(1);
                ChristmasTreeBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)MMItems.ORNAMENTS.get()));
                return ItemInteractionResult.CONSUME;
            }
            if (!((Boolean)state.getValue((Property)GARLAND)).booleanValue() && heldItem.getItem() == MMItems.TREE_GARLAND.get()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)GARLAND, (Comparable)Boolean.valueOf(true)));
                heldItem.shrink(1);
                return ItemInteractionResult.CONSUME;
            }
            if ((Integer)state.getValue((Property)SECTION) == 2) {
                boolean is_air;
                boolean bl = is_air = level.getBlockState(pos.above()).getBlock() == Blocks.AIR;
                if (is_air) {
                    if (heldItem.getItem() == MMItems.STAR.get()) {
                        level.setBlockAndUpdate(pos.above(), (BlockState)((Block)MMBlocks.TOPPER.get()).defaultBlockState().setValue((Property)TopperBlock.TOPPER, (Comparable)Integer.valueOf(1)));
                        heldItem.shrink(1);
                        return ItemInteractionResult.CONSUME;
                    }
                    if (heldItem.getItem() == MMItems.BOW.get()) {
                        level.setBlockAndUpdate(pos.above(), (BlockState)((Block)MMBlocks.TOPPER.get()).defaultBlockState().setValue((Property)TopperBlock.TOPPER, (Comparable)Integer.valueOf(2)));
                        heldItem.shrink(1);
                        return ItemInteractionResult.CONSUME;
                    }
                }
                if (!is_air && level.getBlockState(pos.above()).getBlock() == MMBlocks.TOPPER.get() && (Integer)level.getBlockState(pos.above()).getValue((Property)TopperBlock.TOPPER) == 0) {
                    if (heldItem.getItem() == MMItems.STAR.get()) {
                        level.setBlockAndUpdate(pos.above(), (BlockState)((Block)MMBlocks.TOPPER.get()).defaultBlockState().setValue((Property)TopperBlock.TOPPER, (Comparable)Integer.valueOf(1)));
                        heldItem.shrink(1);
                        return ItemInteractionResult.CONSUME;
                    }
                    if (heldItem.getItem() == MMItems.BOW.get()) {
                        level.setBlockAndUpdate(pos.above(), (BlockState)((Block)MMBlocks.TOPPER.get()).defaultBlockState().setValue((Property)TopperBlock.TOPPER, (Comparable)Integer.valueOf(2)));
                        heldItem.shrink(1);
                        return ItemInteractionResult.CONSUME;
                    }
                }
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide) {
            if (((Boolean)state.getValue((Property)GARLAND)).booleanValue()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)GARLAND, (Comparable)Boolean.valueOf(false)));
                player.addItem(new ItemStack((ItemLike)MMItems.TREE_GARLAND.get()));
                return InteractionResult.CONSUME;
            }
            if ((Integer)state.getValue((Property)DECO) == 2) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DECO, (Comparable)Integer.valueOf(0)));
                player.addItem(new ItemStack((ItemLike)MMItems.ORNAMENTS.get()));
                return InteractionResult.CONSUME;
            }
            if ((Integer)state.getValue((Property)DECO) == 1) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DECO, (Comparable)Integer.valueOf(0)));
                player.addItem(new ItemStack((ItemLike)MMItems.ORNAMENTS_WHITE.get()));
                return InteractionResult.CONSUME;
            }
            if ((Integer)state.getValue((Property)LIGHTS) == 2) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)LIGHTS, (Comparable)Integer.valueOf(0))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                player.addItem(new ItemStack((ItemLike)MMItems.TREE_LIGHTS_MULTI.get()));
                return InteractionResult.CONSUME;
            }
            if ((Integer)state.getValue((Property)LIGHTS) == 1) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)LIGHTS, (Comparable)Integer.valueOf(0))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                player.addItem(new ItemStack((ItemLike)MMItems.TREE_LIGHTS_WHITE.get()));
                return InteractionResult.CONSUME;
            }
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if ((Integer)state.getValue((Property)SECTION) == 0) {
            level.destroyBlock(pos, true);
            level.destroyBlock(pos.above(), true);
            level.destroyBlock(pos.above(2), true);
        }
        if ((Integer)state.getValue((Property)SECTION) == 1) {
            level.destroyBlock(pos, true);
            level.destroyBlock(pos.above(), true);
            level.destroyBlock(pos.below(), true);
        }
        if ((Integer)state.getValue((Property)SECTION) == 2) {
            level.destroyBlock(pos, true);
            level.destroyBlock(pos.below(), true);
            level.destroyBlock(pos.below(2), true);
        }
        if ((Integer)state.getValue((Property)SECTION) == 0 && level.getBlockState(pos.above(3)).getBlock() == MMBlocks.TOPPER.get()) {
            level.destroyBlock(pos, true);
            level.destroyBlock(pos.above(), true);
            level.destroyBlock(pos.above(2), true);
            level.destroyBlock(pos.above(3), true);
        }
        if ((Integer)state.getValue((Property)SECTION) == 1 && level.getBlockState(pos.above(2)).getBlock() == MMBlocks.TOPPER.get()) {
            level.destroyBlock(pos, true);
            level.destroyBlock(pos.above(), true);
            level.destroyBlock(pos.above(2), true);
            level.destroyBlock(pos.below(), true);
        }
        if ((Integer)state.getValue((Property)SECTION) == 2 && level.getBlockState(pos.above()).getBlock() == MMBlocks.TOPPER.get()) {
            level.destroyBlock(pos, true);
            level.destroyBlock(pos.above(), true);
            level.destroyBlock(pos.below(), true);
            level.destroyBlock(pos.below(2), true);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (state.getBlock() == MMBlocks.CHRISTMAS_TREE_SNOWY.get()) {
            return new ItemStack((ItemLike)MMItems.SNOWY_CHRISTMAS_TREE.get());
        }
        return new ItemStack((ItemLike)MMItems.CHRISTMAS_TREE.get());
    }
}

