/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.block.tree;

import com.mamailes.merrymaking.init.MMBlocks;
import com.mamailes.merrymaking.init.MMItems;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.TriState;

public class SpruceTopBlock
extends BushBlock {
    public static final MapCodec<SpruceTopBlock> CODEC = SpruceTopBlock.simpleCodec(SpruceTopBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public SpruceTopBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_48946_, BlockPos p_48947_, CollisionContext p_48948_) {
        return SHAPE;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        Block block = state.getBlock();
        return block == MMBlocks.TREE_MIDDLE.get();
    }

    protected boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.below();
        if (pState.getBlock() == this) {
            TriState soilDecision = pLevel.getBlockState(pPos.below()).canSustainPlant((BlockGetter)pLevel, pPos.below(), Direction.UP, pState);
            if (!soilDecision.isDefault()) {
                return soilDecision.isTrue();
            }
            return super.canSurvive(pState, pLevel, pPos);
        }
        return this.mayPlaceOn(pLevel.getBlockState(blockpos), (BlockGetter)pLevel, blockpos);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (level.getBlockState(pos.below()).getBlock() == MMBlocks.TREE_MIDDLE.get() && level.getBlockState(pos.below(2)).getBlock() == MMBlocks.TREE_BOTTOM.get()) {
            level.destroyBlock(pos, true);
            level.destroyBlock(pos.below(), false);
            level.destroyBlock(pos.below(2), true);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)MMItems.CHRISTMAS_TREE.get());
    }
}

