/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.event;

import com.mamailes.merrymaking.config.MerryMakingConfig;
import com.mamailes.merrymaking.entity.ChristmasCreeperEntity;
import com.mamailes.merrymaking.init.MMItems;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber(modid="merrymaking", bus=EventBusSubscriber.Bus.GAME)
public class MMEntityEvents {
    @SubscribeEvent
    public static void creeperDeathEvent(LivingDeathEvent event) {
        Level level = event.getEntity().level();
        BlockPos pos = event.getEntity().blockPosition();
        RandomSource random = level.getRandom();
        LivingEntity entity = event.getEntity();
        Vec3 vec3 = entity.getDeltaMovement();
        if (event.getEntity() instanceof ChristmasCreeperEntity) {
            level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, (double)pos.getX(), 1.0, (double)pos.getZ(), vec3.x, vec3.y + random.nextDouble() * (double)0.2f, vec3.z);
        }
    }

    @SubscribeEvent
    public static void entityJoin(EntityJoinLevelEvent event) {
        Level level = event.getEntity().level();
        BlockPos pos = event.getEntity().blockPosition();
        if (event.getEntity() instanceof ChristmasCreeperEntity && (!((Boolean)MerryMakingConfig.CHRISTMAS_CREEPER_WORLD_SPAWN.get()).booleanValue() || level.getBiome(pos).equals((Object)Biomes.MUSHROOM_FIELDS))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntitySpawn(FinalizeSpawnEvent event) {
        Mob entity = event.getEntity();
        boolean isBipedMonster = event.getEntity() instanceof Zombie || event.getEntity() instanceof Skeleton || event.getEntity() instanceof Stray || event.getEntity() instanceof WitherSkeleton || event.getEntity() instanceof Piglin || event.getEntity() instanceof PiglinBrute || event.getEntity() instanceof ZombifiedPiglin;
        Random rand = new Random();
        Integer choose_hat = rand.nextInt(2);
        Integer choose_sweater = rand.nextInt(2);
        ItemStack sweater_green_leather = new ItemStack((ItemLike)MMItems.UGLY_SWEATER_GREEN_LEATHER.get());
        ItemStack sweater_red_leather = new ItemStack((ItemLike)MMItems.UGLY_SWEATER_RED_LEATHER.get());
        ItemStack hat_red_leather = new ItemStack((ItemLike)MMItems.SANTA_HAT_RED_LEATHER.get());
        ItemStack hat_green_leather = new ItemStack((ItemLike)MMItems.REINDEER_EARS_LEATHER.get());
        if (((Boolean)MerryMakingConfig.MOBS_WEAR_CHRISTMAS_ARMOR_ENABLED.get()).booleanValue() && isBipedMonster) {
            if (rand.nextInt(10) == 0) {
                if (choose_hat == 0) {
                    entity.setItemSlot(EquipmentSlot.HEAD, hat_red_leather);
                }
                if (choose_hat == 1) {
                    entity.setItemSlot(EquipmentSlot.HEAD, hat_green_leather);
                }
            }
            if (rand.nextInt(4) == 1) {
                if (choose_sweater == 0) {
                    entity.setItemSlot(EquipmentSlot.CHEST, sweater_red_leather);
                }
                if (choose_sweater == 1) {
                    entity.setItemSlot(EquipmentSlot.CHEST, sweater_green_leather);
                }
            }
            if (rand.nextInt(4) == 2) {
                if (choose_hat == 0) {
                    entity.setItemSlot(EquipmentSlot.LEGS, hat_red_leather);
                }
                if (choose_hat == 1) {
                    entity.setItemSlot(EquipmentSlot.HEAD, hat_green_leather);
                }
                if (choose_sweater == 0) {
                    entity.setItemSlot(EquipmentSlot.CHEST, sweater_red_leather);
                }
                if (choose_sweater == 1) {
                    entity.setItemSlot(EquipmentSlot.CHEST, sweater_green_leather);
                }
            }
            if (((Boolean)MerryMakingConfig.MOBS_DROP_CHRISTMAS_ARMOR_ENABLED.get()).booleanValue()) {
                if (event.getEntity().getType() == EntityType.ZOMBIE) {
                    ((Zombie)entity).setDropChance(EquipmentSlot.CHEST, 0.05f);
                    ((Zombie)entity).setDropChance(EquipmentSlot.HEAD, 0.05f);
                }
                if (event.getEntity().getType() == EntityType.SKELETON) {
                    ((Skeleton)entity).setDropChance(EquipmentSlot.CHEST, 0.05f);
                    ((Skeleton)entity).setDropChance(EquipmentSlot.HEAD, 0.05f);
                }
                if (event.getEntity().getType() == EntityType.STRAY) {
                    ((Stray)entity).setDropChance(EquipmentSlot.CHEST, 0.05f);
                    ((Stray)entity).setDropChance(EquipmentSlot.HEAD, 0.05f);
                }
                if (event.getEntity().getType() == EntityType.WITHER) {
                    ((WitherSkeleton)entity).setDropChance(EquipmentSlot.CHEST, 0.05f);
                    ((WitherSkeleton)entity).setDropChance(EquipmentSlot.HEAD, 0.05f);
                }
                if (event.getEntity().getType() == EntityType.PIGLIN) {
                    ((Piglin)entity).setDropChance(EquipmentSlot.CHEST, 0.05f);
                    ((Piglin)entity).setDropChance(EquipmentSlot.HEAD, 0.05f);
                }
                if (event.getEntity().getType() == EntityType.PIGLIN_BRUTE) {
                    ((PiglinBrute)entity).setDropChance(EquipmentSlot.CHEST, 0.05f);
                    ((PiglinBrute)entity).setDropChance(EquipmentSlot.HEAD, 0.05f);
                }
                if (event.getEntity().getType() == EntityType.ZOMBIFIED_PIGLIN) {
                    ((ZombifiedPiglin)entity).setDropChance(EquipmentSlot.CHEST, 0.05f);
                    ((ZombifiedPiglin)entity).setDropChance(EquipmentSlot.HEAD, 0.05f);
                }
            }
        }
    }
}

