/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.network;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiCommonConfig;
import snownee.kiwi.customization.block.family.BlockFamilies;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.customization.network.SItemPopTimePacket;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.PayloadContext;
import snownee.kiwi.network.PlayPacketHandler;
import snownee.kiwi.util.KHolder;

@KiwiPacket
public record CConvertItemPacket(boolean inContainer, Action action, int slot, Holder<Item> from, Entry entry) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CConvertItemPacket> TYPE = new CustomPacketPayload.Type(Kiwi.id("convert_item"));
    public static final int MAX_STEPS = 4;

    public CConvertItemPacket(boolean inContainer, int slot, Entry entry, Item from, Action action) {
        this(inContainer, action, slot, (Holder<Item>)from.builtInRegistryHolder(), entry);
    }

    public CustomPacketPayload.Type<CConvertItemPacket> type() {
        return TYPE;
    }

    public static enum Action {
        CONVERT_ALL,
        CONVERT_ONE,
        CONVERT_FAMILY;

        private static final IntFunction<Action> BY_ID;
        public static final StreamCodec<ByteBuf, Action> STREAM_CODEC;

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])Action.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    public record Entry(float ratio, List<Pair<ResourceLocation, Item>> steps) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Pair<ResourceLocation, Item>> ENTRY_PAIR_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, Pair::getFirst, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), Pair::getSecond, Pair::of);
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, Entry::ratio, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, ENTRY_PAIR_STREAM_CODEC), Entry::steps, Entry::new);

        public Entry(float ratio) {
            this(ratio, Lists.newArrayList());
        }

        public Item item() {
            return (Item)this.steps.getLast().getSecond();
        }
    }

    public record Group(List<Entry> entries) {
        public Group() {
            this(Lists.newArrayList());
        }
    }

    public static class Handler
    implements PlayPacketHandler<CConvertItemPacket> {
        public static final StreamCodec<RegistryFriendlyByteBuf, CConvertItemPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, CConvertItemPacket::inContainer, Action.STREAM_CODEC, CConvertItemPacket::action, (StreamCodec)ByteBufCodecs.VAR_INT, CConvertItemPacket::slot, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM), CConvertItemPacket::from, Entry.STREAM_CODEC, CConvertItemPacket::entry, CConvertItemPacket::new);

        @Override
        public void handle(CConvertItemPacket packet, PayloadContext context) {
            ServerPlayer player = context.serverPlayer();
            if (KiwiCommonConfig.kSwitchCreativeOnly && !player.isCreative()) {
                return;
            }
            Action action = packet.action;
            boolean inContainer = packet.inContainer;
            int slotIndex = packet.slot;
            Item from = (Item)packet.from.value();
            List<Pair<ResourceLocation, Item>> steps = packet.entry.steps;
            if (steps.isEmpty() || steps.size() > 4) {
                return;
            }
            if (action == Action.CONVERT_FAMILY && inContainer) {
                return;
            }
            Item to = (Item)steps.getLast().getSecond();
            context.execute(() -> {
                ItemStack newItem;
                ItemStack sourceItem;
                Item item = from;
                int index = 0;
                float ratio = 1.0f;
                for (Pair step : steps) {
                    BlockFamily family = BlockFamilies.get((ResourceLocation)step.getFirst());
                    if (!(family != null && family.switchAttrs().enabled() && family.contains(item) && family.contains((Item)step.getSecond()))) {
                        return;
                    }
                    if (!family.switchAttrs().cascading() && index != steps.size() - 1) {
                        return;
                    }
                    if (!player.isCreative()) {
                        ratio *= BlockFamilies.getConvertRatio(item) / BlockFamilies.getConvertRatio((Item)step.getSecond());
                    }
                    item = (Item)step.getSecond();
                    ++index;
                }
                Slot slot = null;
                Inventory playerInventory = player.getInventory();
                try {
                    if (slotIndex == -500) {
                        if (!player.isCreative()) return;
                        sourceItem = from.getDefaultInstance();
                    } else if (inContainer) {
                        slot = (Slot)player.containerMenu.slots.get(slotIndex);
                        if (!slot.allowModification((Player)player)) {
                            return;
                        }
                        sourceItem = slot.getItem();
                    } else {
                        sourceItem = playerInventory.getItem(slotIndex);
                    }
                }
                catch (Exception e) {
                    return;
                }
                if (!sourceItem.is(from)) {
                    return;
                }
                if (action == Action.CONVERT_FAMILY) {
                    Handler.convertFamily(player, to, slotIndex, ratio);
                    return;
                }
                boolean skipSettingSlot = false;
                int inventorySwap = Integer.MIN_VALUE;
                if (ratio >= 1.0f) {
                    newItem = to.getDefaultInstance();
                } else {
                    if (action == Action.CONVERT_ONE) {
                        return;
                    }
                    for (int i = 0; i < playerInventory.getContainerSize(); ++i) {
                        ItemStack stack = playerInventory.getItem(i);
                        if (!stack.is(to)) continue;
                        inventorySwap = i;
                        break;
                    }
                    if (inventorySwap == Integer.MIN_VALUE) {
                        return;
                    }
                    newItem = playerInventory.getItem(inventorySwap);
                }
                int ratioInt = Mth.floor((float)ratio);
                if (action == Action.CONVERT_ONE) {
                    if (!player.isCreative()) {
                        sourceItem.shrink(1);
                        newItem.setCount(ratioInt);
                    }
                    if (!sourceItem.isEmpty()) {
                        Handler.addToPlayer(player, newItem, !inContainer);
                        skipSettingSlot = true;
                    }
                } else if (inventorySwap == Integer.MIN_VALUE) {
                    int maxSize = newItem.getMaxStackSize();
                    int count = Math.min(sourceItem.getCount(), maxSize / ratioInt);
                    newItem.setCount(count * ratioInt);
                    if (!player.isCreative()) {
                        sourceItem.shrink(count);
                    }
                }
                if (slotIndex != -500 && !skipSettingSlot) {
                    try {
                        if (inContainer) {
                            if (!slot.mayPlace(newItem)) {
                                return;
                            }
                            slot.setByPlayer(newItem);
                        } else {
                            newItem.setPopTime(5);
                            playerInventory.setItem(slotIndex, newItem);
                        }
                    }
                    catch (Exception e) {
                        return;
                    }
                }
                if (inventorySwap != Integer.MIN_VALUE) {
                    playerInventory.setItem(inventorySwap, sourceItem);
                } else if (!skipSettingSlot && !player.isCreative()) {
                    Handler.addToPlayer(player, sourceItem.copy(), !inContainer);
                }
                Handler.broadcastChanges(player);
            });
        }

        private static void broadcastChanges(ServerPlayer player) {
            Inventory inventory = player.getInventory();
            boolean success = false;
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                success |= SItemPopTimePacket.send(player, i);
            }
            if (success) {
                Handler.playPickupSound((Player)player);
                player.containerMenu.broadcastChanges();
            }
        }

        public static void convertFamily(ServerPlayer player, Item to, int slotIndex, float ratio) {
            Set set = BlockFamilies.findQuickSwitch(to, player.isCreative()).stream().map(KHolder::value).flatMap(BlockFamily::items).filter(Predicate.not(to::equals)).collect(Collectors.toSet());
            Inventory inventory = player.getInventory();
            boolean success = false;
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack stack = inventory.getItem(i);
                if (!set.contains(stack.getItem())) continue;
                success = true;
                inventory.setItem(i, ItemStack.EMPTY);
                ItemStack newItem = to.getDefaultInstance();
                newItem.setPopTime(5);
                int newCount = Mth.floor((float)((float)stack.getCount() * ratio));
                while (newCount > 0) {
                    int count = Math.min(newCount, newItem.getMaxStackSize());
                    newItem.setCount(count);
                    newCount -= count;
                    if (!inventory.add(slotIndex, newItem) && !inventory.add(newItem)) {
                        player.drop(newItem, true);
                    }
                    if (newCount <= 0) continue;
                    newItem = newItem.copy();
                }
            }
            if (success) {
                Handler.broadcastChanges(player);
            }
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, CConvertItemPacket> streamCodec() {
            return STREAM_CODEC;
        }

        private static void addToPlayer(ServerPlayer player, ItemStack itemStack, boolean nextToSelected) {
            int slot;
            Inventory inventory = player.getInventory();
            IntStream intStream = IntStream.range(0, 9);
            if (nextToSelected) {
                IntStream leftAndRight = IntStream.of(inventory.selected, inventory.selected + 1, inventory.selected - 1);
                intStream = IntStream.concat(leftAndRight, intStream);
            }
            if (!(inventory.add(slot = intStream.filter(Inventory::isHotbarSlot).filter(i -> {
                ItemStack stack = inventory.getItem(i);
                if (stack.isEmpty()) {
                    return true;
                }
                return stack.getCount() < stack.getMaxStackSize() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack);
            }).findFirst().orElse(-1), itemStack) || inventory.add(itemStack) || player.isCreative())) {
                player.drop(itemStack, true);
            }
        }

        public static void playPickupSound(Player player) {
            player.level().playSound((Player)(player.isLocalPlayer() ? player : null), player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }
}

